/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.component;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.crend.dynamiccrosshair.DynamicCrosshairMod;
import mod.crend.dynamiccrosshair.component.CrosshairComponent;
import mod.crend.dynamiccrosshair.component.State;
import mod.crend.dynamiccrosshair.style.CrosshairStyle;
import mod.crend.dynamiccrosshairapi.DynamicCrosshairApi;
import mod.crend.dynamiccrosshairapi.crosshair.Crosshair;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.exception.CrosshairContextChange;
import mod.crend.dynamiccrosshairapi.exception.InvalidContextState;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairBlock;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairEntity;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.phys.HitResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrosshairHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"dynamiccrosshair");
    private static CrosshairComponent activeCrosshair = new CrosshairComponent(new Crosshair());
    private static CrosshairStyle defaultCrosshair = DynamicCrosshairMod.config.getDefaultStyle();
    private static boolean shouldShowCrosshair = true;
    public static boolean forceShowCrosshair = false;
    static State state = null;

    public static CrosshairComponent getActiveCrosshair() {
        return activeCrosshair;
    }

    private static boolean isBlockInteractable(CrosshairContext context) {
        if (context.isWithBlock() && context.shouldInteract()) {
            return context.api().test(api -> api.isAlwaysInteractable(context.getBlockState()) || api.isInteractable(context.getBlockState()));
        }
        return false;
    }

    private static Crosshair buildCrosshairAdvancedFromItem(CrosshairContext context) {
        InteractionType interactionType = ((DynamicCrosshairItem)context.getItem()).dynamiccrosshair$compute(context);
        InteractionType finalInteractionType = interactionType = (switch (interactionType) {
            case InteractionType.MELEE_WEAPON -> {
                if (context.includeMeleeWeapon()) {
                    yield interactionType;
                }
                yield InteractionType.EMPTY;
            }
            case InteractionType.RANGED_WEAPON, InteractionType.RANGED_WEAPON_CHARGING, InteractionType.RANGED_WEAPON_CHARGED -> {
                if (context.includeRangedWeapon()) {
                    yield interactionType;
                }
                yield InteractionType.EMPTY;
            }
            case InteractionType.PLACE_BLOCK -> {
                if (context.includeHoldingBlock()) {
                    yield interactionType;
                }
                yield InteractionType.EMPTY;
            }
            case InteractionType.SHIELD -> {
                if (context.includeShield()) {
                    yield interactionType;
                }
                yield InteractionType.EMPTY;
            }
            case InteractionType.TOOL, InteractionType.CORRECT_TOOL, InteractionType.INCORRECT_TOOL -> {
                if (context.includeTool()) {
                    yield interactionType;
                }
                yield InteractionType.EMPTY;
            }
            case InteractionType.USABLE_TOOL -> {
                if (context.includeTool()) {
                    yield interactionType;
                }
                yield InteractionType.USE_ITEM_ON_BLOCK;
            }
            case InteractionType.USE_ITEM, InteractionType.USE_ITEM_ON_BLOCK, InteractionType.USE_ITEM_ON_ENTITY, InteractionType.CHARGE_ITEM, InteractionType.EQUIP_ITEM, InteractionType.CONSUME_ITEM, InteractionType.SPYGLASS -> {
                if (context.includeUsableItem()) {
                    yield interactionType;
                }
                yield InteractionType.EMPTY;
            }
            case InteractionType.THROW_ITEM -> {
                if (context.includeThrowable()) {
                    yield interactionType;
                }
                yield InteractionType.EMPTY;
            }
            default -> interactionType;
        });
        Crosshair override = (Crosshair)context.withApisUntilNonNull(api -> api.overrideFromItem(context, finalInteractionType));
        if (override != null) {
            return override;
        }
        if (interactionType == InteractionType.EMPTY || interactionType == InteractionType.NO_ACTION) {
            return (Crosshair)context.withApisUntilNonNull(api -> api.computeFromItem(context));
        }
        return new Crosshair(interactionType);
    }

    private static Crosshair buildCrosshairAdvancedFromEntity(CrosshairContext context) {
        InteractionType interactionType = ((DynamicCrosshairEntity)context.getEntity()).dynamiccrosshair$compute(context);
        if (interactionType != InteractionType.EMPTY) {
            return new Crosshair(interactionType);
        }
        return (Crosshair)context.withApisUntilNonNull(api -> api.computeFromEntity(context));
    }

    private static Crosshair buildCrosshairAdvancedFromBlock(CrosshairContext context) {
        InteractionType interactionType = ((DynamicCrosshairBlock)context.getBlock()).dynamiccrosshair$compute(context);
        if (interactionType != InteractionType.EMPTY) {
            return new Crosshair(interactionType);
        }
        return (Crosshair)context.withApisUntilNonNull(api -> api.computeFromBlock(context));
    }

    private static Crosshair buildCrosshairAdvancedByHand(CrosshairContext context) {
        Crosshair crosshair = null;
        if (context.isWithEntity()) {
            crosshair = CrosshairHandler.buildCrosshairAdvancedFromEntity(context);
        } else if (context.isWithBlock() && context.shouldInteract() && DynamicCrosshairMod.config.dynamicCrosshairOnInteractableBlock()) {
            crosshair = CrosshairHandler.buildCrosshairAdvancedFromBlock(context);
        }
        return Crosshair.combine((Crosshair)crosshair, (Crosshair)CrosshairHandler.buildCrosshairAdvancedFromItem(context));
    }

    private static Crosshair buildCrosshairDynamic(CrosshairContext context) {
        Crosshair crosshair = CrosshairHandler.buildCrosshairAdvancedByHand(context);
        if (crosshair != null && crosshair.hasSecondaryInteraction()) {
            return crosshair;
        }
        context.setHand(InteractionHand.OFF_HAND);
        Crosshair offhandCrosshair = CrosshairHandler.buildCrosshairAdvancedByHand(context);
        context.setHand(InteractionHand.MAIN_HAND);
        if (offhandCrosshair != null) {
            return Crosshair.combine((Crosshair)crosshair, (Crosshair)offhandCrosshair);
        }
        return crosshair;
    }

    private static void debug(List<DynamicCrosshairApi> apis, Function<DynamicCrosshairApi, Object> callback) {
        for (DynamicCrosshairApi api : apis) {
            try {
                LOGGER.info("  {}:{}: {}", new Object[]{api.getNamespace(), api.getModId(), callback.apply(api)});
            }
            catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
                if (e instanceof CrosshairContextChange) {
                    throw e;
                }
                LOGGER.info("  {}:{}: FAILED", (Object)api.getNamespace(), (Object)api.getModId());
            }
        }
    }

    public static void debug() {
        CrosshairContext context = CrosshairHandler.state.context;
        List apis = context.apis();
        LOGGER.info("Dynamic Crosshair evaluation");
        LOGGER.info("Context:");
        LOGGER.info("  Main hand:{}", (Object)context.getItemStack(InteractionHand.MAIN_HAND));
        LOGGER.info("  Offhand:{}", (Object)context.getItemStack(InteractionHand.OFF_HAND));
        LOGGER.info("  Block:{}", context.isWithBlock() ? context.getBlockState() : "null");
        LOGGER.info("  Entity:{}", context.isWithEntity() ? context.getEntity() : "null");
        LOGGER.info("Active APIs: {}", apis.stream().map(api -> api.getNamespace() + ":" + api.getModId()).toList());
        LOGGER.info("Forcing invalidation: {}", apis.stream().filter(api -> api.forceInvalidate(context)).collect(Collectors.toList()));
        LOGGER.info("MAIN_HAND.computeCrosshair: {}", (Object)((DynamicCrosshairItem)context.getItem()).dynamiccrosshair$compute(context));
        LOGGER.info(".computeFromItem(MAIN_HAND)");
        CrosshairHandler.debug(apis, api -> api.computeFromItem(context));
        context.setHand(InteractionHand.OFF_HAND);
        LOGGER.info("OFF_HAND.computeCrosshair: {}", (Object)((DynamicCrosshairItem)context.getItem()).dynamiccrosshair$compute(context));
        LOGGER.info(".computeFromItem(OFF_HAND)");
        CrosshairHandler.debug(apis, api -> api.computeFromItem(context));
        context.setHand(InteractionHand.MAIN_HAND);
        if (context.isWithEntity()) {
            LOGGER.info(".computeFromEntity(MAIN_HAND)");
            CrosshairHandler.debug(apis, api -> api.computeFromEntity(context));
            context.setHand(InteractionHand.OFF_HAND);
            LOGGER.info(".computeFromEntity(OFF_HAND)");
            CrosshairHandler.debug(apis, api -> api.computeFromEntity(context));
            context.setHand(InteractionHand.MAIN_HAND);
        }
        if (context.isWithBlock()) {
            LOGGER.info(".computeFromBlock(MAIN_HAND)");
            CrosshairHandler.debug(apis, api -> api.computeFromBlock(context));
            context.setHand(InteractionHand.OFF_HAND);
            LOGGER.info(".computeFromBlock(OFF_HAND)");
            CrosshairHandler.debug(apis, api -> api.computeFromBlock(context));
            context.setHand(InteractionHand.MAIN_HAND);
        }
    }

    private static Optional<Boolean> buildCrosshair(HitResult hitResult, LocalPlayer player, boolean recursion) {
        try {
            for (DynamicCrosshairApi api : CrosshairHandler.state.context.apis()) {
                try {
                    hitResult = api.overrideHitResult(CrosshairHandler.state.context, hitResult);
                }
                catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
                    if (e instanceof CrosshairContextChange) {
                        throw e;
                    }
                    LOGGER.error("Exception occurred during evaluation of API {}", (Object)api.getModId(), (Object)e);
                }
            }
            if (!state.changed(hitResult, player)) {
                return Optional.of(shouldShowCrosshair);
            }
            Crosshair newCrosshair = null;
            switch (hitResult.getType()) {
                case ENTITY: {
                    if (!DynamicCrosshairMod.config.dynamicCrosshairOnEntity()) break;
                    newCrosshair = new Crosshair(InteractionType.TARGET_ENTITY);
                    break;
                }
                case BLOCK: {
                    if (DynamicCrosshairMod.config.dynamicCrosshairOnBlock()) {
                        newCrosshair = new Crosshair(InteractionType.TARGET_BLOCK);
                        break;
                    }
                    if (!DynamicCrosshairMod.config.dynamicCrosshairOnInteractableBlock() || !CrosshairHandler.isBlockInteractable(CrosshairHandler.state.context)) break;
                    newCrosshair = new Crosshair(InteractionType.TARGET_BLOCK);
                }
            }
            activeCrosshair = new CrosshairComponent(Crosshair.combine((Crosshair)CrosshairHandler.buildCrosshairDynamic(CrosshairHandler.state.context), newCrosshair));
        }
        catch (CrosshairContextChange crosshairContextChange) {
            if (!recursion) {
                return CrosshairHandler.buildCrosshair(crosshairContextChange.newHitResult, player, true);
            }
        }
        catch (InvalidContextState invalidContextState) {
            LOGGER.error("Encountered invalid context state: ", (Throwable)invalidContextState);
        }
        catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError | RuntimeException e) {
            LOGGER.error("Encountered an unexpected error. This usually is due to outdated mod support.", e);
        }
        return Optional.empty();
    }

    private static boolean checkShowCrosshair() {
        Optional<Boolean> result;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || state != null && CrosshairHandler.state.context.getPlayer() != player) {
            state = null;
            return false;
        }
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult == null) {
            state = null;
            return false;
        }
        if (DynamicCrosshairMod.config.isHideWithScreen() && Minecraft.getInstance().screen != null) {
            state = null;
            return false;
        }
        if (DynamicCrosshairMod.config.isHideWithMap() && player.getMainHandItem().getItem() instanceof MapItem && player.getOffhandItem().isEmpty()) {
            state = null;
            return false;
        }
        if (state == null) {
            state = new State();
        }
        if ((result = CrosshairHandler.buildCrosshair(hitResult, player, false)).isPresent()) {
            return result.get();
        }
        if (activeCrosshair.getCrosshair().hasInteraction()) {
            return true;
        }
        if (DynamicCrosshairMod.config.isDynamicCrosshair()) {
            return false;
        }
        activeCrosshair = CrosshairComponent.FORCE_CROSSHAIR;
        return true;
    }

    public static boolean shouldShowCrosshair() {
        return shouldShowCrosshair;
    }

    public static CrosshairStyle getDefaultCrosshair() {
        return defaultCrosshair;
    }

    public static void tick() {
        shouldShowCrosshair = CrosshairHandler.checkShowCrosshair();
        defaultCrosshair = DynamicCrosshairMod.config.getDefaultStyle();
    }
}

