/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.common.block.elevatorid;

import com.vsngarcia.level.ElevatorBlockEntityBase;
import com.vsngarcia.neoforge.ElevatorBlock;
import com.vsngarcia.util.FakeUseContext;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.common.block.entity.elevatorid.DyenamicsElevatorBlockEntity;
import cy.jdkdigital.dyenamicsandfriends.compat.ElevatoridCompat;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class DyenamicsElevatorBlock
extends ElevatorBlock {
    private final DyenamicDyeColor color;

    public DyenamicsElevatorBlock(DyenamicDyeColor color) {
        super(DyeColor.WHITE);
        this.color = color;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DyenamicsElevatorBlockEntity(pos, state);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return this.color.getLightValue();
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        return this.getElevatorBlockEntity((BlockGetter)level, pos).map(tile -> {
            Block handBlock = Block.byItem((Item)player.getItemInHand(handIn).getItem());
            BlockState stateToApply = handBlock.getStateForPlacement((BlockPlaceContext)new FakeUseContext(player, handIn, hit));
            if (stateToApply != null && tile.setCamoAndUpdate(stateToApply)) {
                return ItemInteractionResult.SUCCESS;
            }
            if (player.isCrouching() && tile.getHeldState() != null) {
                tile.setCamoAndUpdate(null);
                return ItemInteractionResult.SUCCESS;
            }
            this.openMenu(player, (ElevatorBlockEntityBase)tile, pos);
            return ItemInteractionResult.SUCCESS;
        }).orElse(ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
    }

    private Optional<? extends ElevatorBlockEntityBase> getElevatorBlockEntity(BlockGetter level, BlockPos pos) {
        if (level == null || pos == null) {
            return Optional.empty();
        }
        return level.getBlockEntity(pos, ElevatoridCompat.ELEVATOR_BLOCK_ENTITY.get());
    }
}

