/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.core.util;

import cy.jdkdigital.dyenamics.common.item.DyenamicDyeItem;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FastColor;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.MapColor;

public enum DyenamicDyeColor implements StringRepresentable
{
    WHITE(0, "white", 0xF9FFFE, DyeColor.WHITE, MapColor.SNOW, 0xF0F0F0, 0xFFFFFF, 0),
    ORANGE(1, "orange", 16351261, DyeColor.ORANGE, MapColor.COLOR_ORANGE, 15435844, 16738335, 0),
    MAGENTA(2, "magenta", 13061821, DyeColor.MAGENTA, MapColor.COLOR_MAGENTA, 12801229, 0xFF00FF, 0),
    LIGHT_BLUE(3, "light_blue", 3847130, DyeColor.LIGHT_BLUE, MapColor.COLOR_LIGHT_BLUE, 6719955, 10141901, 0),
    YELLOW(4, "yellow", 16701501, DyeColor.YELLOW, MapColor.COLOR_YELLOW, 14602026, 0xFFFF00, 0),
    LIME(5, "lime", 8439583, DyeColor.LIME, MapColor.COLOR_LIGHT_GREEN, 4312372, 0xBFFF00, 0),
    PINK(6, "pink", 15961002, DyeColor.PINK, MapColor.COLOR_PINK, 14188952, 16738740, 0),
    GRAY(7, "gray", 4673362, DyeColor.GRAY, MapColor.COLOR_GRAY, 0x434343, 0x808080, 0),
    LIGHT_GRAY(8, "light_gray", 0x9D9D97, DyeColor.LIGHT_GRAY, MapColor.COLOR_LIGHT_GRAY, 0xABABAB, 0xD3D3D3, 0),
    CYAN(9, "cyan", 1481884, DyeColor.CYAN, MapColor.COLOR_CYAN, 2651799, 65535, 0),
    PURPLE(10, "purple", 8991416, DyeColor.PURPLE, MapColor.COLOR_PURPLE, 8073150, 10494192, 0),
    BLUE(11, "blue", 3949738, DyeColor.BLUE, MapColor.COLOR_BLUE, 2437522, 255, 0),
    BROWN(12, "brown", 8606770, DyeColor.BROWN, MapColor.COLOR_BROWN, 5320730, 9127187, 0),
    GREEN(13, "green", 6192150, DyeColor.GREEN, MapColor.COLOR_GREEN, 3887386, 65280, 0),
    RED(14, "red", 11546150, DyeColor.RED, MapColor.COLOR_RED, 11743532, 0xFF0000, 0),
    BLACK(15, "black", 0x1D1D21, DyeColor.BLACK, MapColor.COLOR_BLACK, 0x1E1B1B, 0, 0),
    PEACH(16, "peach", 12556403, DyeColor.ORANGE, MapColor.SAND, 12556403, 11570292, 0),
    AQUAMARINE(17, "aquamarine", 2915711, DyeColor.CYAN, MapColor.TERRACOTTA_CYAN, 2915711, 2717304, 0),
    FLUORESCENT(18, "fluorescent", 15657398, DyeColor.YELLOW, MapColor.SAND, 15657398, 16117951, 15),
    MINT(19, "mint", 9038008, DyeColor.LIME, MapColor.COLOR_GREEN, 9038008, 7917475, 0),
    MAROON(20, "maroon", 0x910000, DyeColor.RED, MapColor.COLOR_RED, 0x910000, 0x910000, 0),
    BUBBLEGUM(21, "bubblegum", 16216518, DyeColor.PINK, MapColor.COLOR_PINK, 16216518, 14574769, 0),
    LAVENDER(22, "lavender", 0xDD99FF, DyeColor.MAGENTA, MapColor.COLOR_PURPLE, 0xDD99FF, 13339371, 0),
    PERSIMMON(23, "persimmon", 13779225, DyeColor.ORANGE, MapColor.TERRACOTTA_ORANGE, 13779225, 12203795, 0),
    CHERENKOV(24, "cherenkov", 104655, DyeColor.LIGHT_BLUE, MapColor.COLOR_LIGHT_BLUE, 104655, 35002, 8),
    AMBER(25, "amber", 13857561, DyeColor.ORANGE, MapColor.TERRACOTTA_ORANGE, 13857561, 12801806, 0),
    HONEY(26, "honey", 16757830, DyeColor.YELLOW, MapColor.TERRACOTTA_YELLOW, 16757830, 16754768, 0),
    ULTRAMARINE(27, "ultramarine", 5655039, DyeColor.BLUE, MapColor.COLOR_BLUE, 5655039, 3944959, 0),
    SPRING_GREEN(28, "spring_green", 12844953, DyeColor.LIME, MapColor.TERRACOTTA_LIGHT_GREEN, 12844953, 0x8FFF99, 0),
    ROSE(29, "rose", 16722021, DyeColor.RED, MapColor.TERRACOTTA_RED, 16722021, 14231653, 0),
    NAVY(30, "navy", 1845361, DyeColor.BLUE, MapColor.TERRACOTTA_BLUE, 1845361, 1187691, 0),
    ICY_BLUE(31, "icy_blue", 10414847, DyeColor.BLUE, MapColor.TERRACOTTA_BLUE, 10414847, 7855103, 0),
    WINE(32, "wine", 7478875, DyeColor.PURPLE, MapColor.COLOR_PURPLE, 7478875, 7018338, 0),
    CONIFER(33, "conifer", 12245589, DyeColor.LIME, MapColor.TERRACOTTA_LIGHT_GREEN, 12245589, 11061816, 0);

    private static final DyenamicDyeColor[] VALUES;
    private static final IntFunction<DyenamicDyeColor> BY_ID;
    private static final Map<Integer, DyenamicDyeColor> BY_FIREWORK_COLOR;
    public static final StringRepresentable.EnumCodec<DyenamicDyeColor> CODEC;
    public static final StreamCodec<ByteBuf, DyenamicDyeColor> STREAM_CODEC;
    private final int id;
    private final String translationKey;
    private final DyeColor analogue;
    private final MapColor mapColor;
    private final int colorValue;
    private final int lightValue;
    private final int fireworkColor;
    private final TagKey<Item> tag;
    private final int textColor;

    private DyenamicDyeColor(int idIn, String translationKeyIn, int colorValueIn, DyeColor analogueIn, MapColor mapColorIn, int fireworkColorIn, int textColorIn, int lightValueIn) {
        this.id = idIn;
        this.translationKey = translationKeyIn;
        this.colorValue = FastColor.ARGB32.opaque((int)colorValueIn);
        this.analogue = analogueIn;
        this.mapColor = mapColorIn;
        this.textColor = textColorIn;
        this.lightValue = lightValueIn;
        this.tag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dyes/" + translationKeyIn)));
        this.fireworkColor = fireworkColorIn;
    }

    public int getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public int getColorComponentValue() {
        return this.colorValue;
    }

    public DyeColor getAnalogue() {
        return this.analogue;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public int getFireworkColor() {
        return this.fireworkColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public int getLightValue() {
        return this.lightValue;
    }

    public DyeColor getVanillaColor() {
        return DyeColor.byId((int)(this.id % 16));
    }

    public static DyenamicDyeColor[] dyenamicValues() {
        DyenamicDyeColor[] colors = DyenamicDyeColor.values();
        return Arrays.copyOfRange(colors, 16, colors.length);
    }

    public static DyenamicDyeColor byId(int colorId) {
        if (colorId < 0 || colorId >= VALUES.length) {
            colorId = 0;
        }
        return VALUES[colorId];
    }

    public static DyenamicDyeColor byTranslationKey(String translationKeyIn, DyenamicDyeColor fallback) {
        for (DyenamicDyeColor DyenamicDyeColor2 : DyenamicDyeColor.values()) {
            if (!DyenamicDyeColor2.translationKey.equals(translationKeyIn)) continue;
            return DyenamicDyeColor2;
        }
        return fallback;
    }

    @Nullable
    public static DyenamicDyeColor byFireworkColor(int fireworkColorIn) {
        return BY_FIREWORK_COLOR.get(fireworkColorIn);
    }

    public String toString() {
        return this.getTranslationKey();
    }

    public int getColorValue() {
        return this.colorValue;
    }

    public TagKey<Item> getTag() {
        return this.tag;
    }

    @Nullable
    public static DyenamicDyeColor getColor(ItemStack stack) {
        return DyenamicDyeColor.getColor(stack.getItem());
    }

    @Nullable
    public static DyenamicDyeColor getColor(Item item) {
        if (item instanceof DyenamicDyeItem) {
            return ((DyenamicDyeItem)item).getDyeColor();
        }
        for (DyenamicDyeColor color : VALUES) {
            if (!item.builtInRegistryHolder().is(color.getTag())) continue;
            return color;
        }
        return null;
    }

    @Nullable
    public static DyenamicDyeColor getColor(DyeColor colorIn) {
        for (DyenamicDyeColor color : VALUES) {
            if (!color.analogue.equals((Object)colorIn)) continue;
            return color;
        }
        return null;
    }

    public String getSerializedName() {
        return this.toString();
    }

    static {
        VALUES = (DyenamicDyeColor[])Arrays.stream(DyenamicDyeColor.values()).sorted(Comparator.comparingInt(DyenamicDyeColor::getId)).toArray(DyenamicDyeColor[]::new);
        BY_ID = ByIdMap.continuous(DyenamicDyeColor::getId, (Object[])DyenamicDyeColor.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        BY_FIREWORK_COLOR = Arrays.stream(DyenamicDyeColor.values()).collect(Collectors.toMap(color -> color.fireworkColor, color -> color));
        CODEC = StringRepresentable.fromEnum(DyenamicDyeColor::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, DyenamicDyeColor::getId);
    }
}

