/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.common.recipe;

import com.google.common.collect.Maps;
import cy.jdkdigital.dyenamics.common.item.DyenamicDyeItem;
import cy.jdkdigital.dyenamics.core.init.RecipeSerializerInit;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;

public class DyenamicFireworkStarRecipe
extends CustomRecipe {
    private static final Ingredient SHAPE_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{Items.FIRE_CHARGE, Items.FEATHER, Items.GOLD_NUGGET, Items.SKELETON_SKULL, Items.WITHER_SKELETON_SKULL, Items.CREEPER_HEAD, Items.PLAYER_HEAD, Items.DRAGON_HEAD, Items.ZOMBIE_HEAD, Items.PIGLIN_HEAD});
    private static final Map<Item, FireworkExplosion.Shape> SHAPE_BY_ITEM = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(Items.FIRE_CHARGE, FireworkExplosion.Shape.LARGE_BALL);
        map.put(Items.FEATHER, FireworkExplosion.Shape.BURST);
        map.put(Items.GOLD_NUGGET, FireworkExplosion.Shape.STAR);
        map.put(Items.SKELETON_SKULL, FireworkExplosion.Shape.CREEPER);
        map.put(Items.WITHER_SKELETON_SKULL, FireworkExplosion.Shape.CREEPER);
        map.put(Items.CREEPER_HEAD, FireworkExplosion.Shape.CREEPER);
        map.put(Items.PLAYER_HEAD, FireworkExplosion.Shape.CREEPER);
        map.put(Items.DRAGON_HEAD, FireworkExplosion.Shape.CREEPER);
        map.put(Items.ZOMBIE_HEAD, FireworkExplosion.Shape.CREEPER);
        map.put(Items.PIGLIN_HEAD, FireworkExplosion.Shape.CREEPER);
    });

    public DyenamicFireworkStarRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput pInv, Level pLevel) {
        boolean hasShapeIngredient = false;
        boolean hasFlickerIngredient = false;
        boolean hasTrailIngredient = false;
        boolean hasGunpowder = false;
        boolean hasDye = false;
        for (int i = 0; i < pInv.size(); ++i) {
            ItemStack itemstack = pInv.getItem(i);
            if (itemstack.isEmpty()) continue;
            if (SHAPE_INGREDIENT.test(itemstack)) {
                if (hasShapeIngredient) {
                    return false;
                }
                hasShapeIngredient = true;
                continue;
            }
            if (itemstack.is(Tags.Items.DUSTS_GLOWSTONE)) {
                if (hasFlickerIngredient) {
                    return false;
                }
                hasFlickerIngredient = true;
                continue;
            }
            if (itemstack.is(Tags.Items.GEMS_DIAMOND)) {
                if (hasTrailIngredient) {
                    return false;
                }
                hasTrailIngredient = true;
                continue;
            }
            if (itemstack.is(Tags.Items.GUNPOWDERS)) {
                if (hasGunpowder) {
                    return false;
                }
                hasGunpowder = true;
                continue;
            }
            if (!itemstack.is(Tags.Items.DYES)) {
                return false;
            }
            hasDye = true;
        }
        return hasGunpowder && hasDye;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider p_335498_) {
        FireworkExplosion.Shape fireworkexplosion$shape = FireworkExplosion.Shape.SMALL_BALL;
        boolean flag = false;
        boolean flag1 = false;
        IntArrayList intlist = new IntArrayList();
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemstack = craftingInput.getItem(i);
            if (itemstack.isEmpty()) continue;
            if (SHAPE_INGREDIENT.test(itemstack)) {
                fireworkexplosion$shape = SHAPE_BY_ITEM.get(itemstack.getItem());
                continue;
            }
            if (itemstack.is(Tags.Items.DUSTS_GLOWSTONE)) {
                flag = true;
                continue;
            }
            if (itemstack.is(Tags.Items.GEMS_DIAMOND)) {
                flag1 = true;
                continue;
            }
            Item item = itemstack.getItem();
            if (item instanceof DyenamicDyeItem) {
                DyenamicDyeItem dyeItem = (DyenamicDyeItem)item;
                intlist.add(dyeItem.getDyeColor().getFireworkColor());
                continue;
            }
            item = itemstack.getItem();
            if (!(item instanceof DyeItem)) continue;
            DyeItem dyeItem = (DyeItem)item;
            intlist.add(dyeItem.getDyeColor().getFireworkColor());
        }
        ItemStack itemstack1 = new ItemStack((ItemLike)Items.FIREWORK_STAR);
        itemstack1.set(DataComponents.FIREWORK_EXPLOSION, (Object)new FireworkExplosion(fireworkexplosion$shape, (IntList)intlist, IntList.of(), flag1, flag));
        return itemstack1;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return new ItemStack((ItemLike)Items.FIREWORK_STAR);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeSerializerInit.FIREWORK_STAR.get();
    }
}

