/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.dyenamics.common.blockentity.DyenamicBannerBlockEntity;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DyenamicBannerBlock
extends AbstractBannerBlock {
    public static final MapCodec<DyenamicBannerBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)DyenamicDyeColor.CODEC.fieldOf("color").forGetter(DyenamicBannerBlock::getDyenamicColor), (App)DyenamicBannerBlock.propertiesCodec()).apply((Applicative)builder, DyenamicBannerBlock::new));
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private final DyenamicDyeColor color;

    public DyenamicBannerBlock(DyenamicDyeColor color, BlockBehaviour.Properties properties) {
        super(color.getAnalogue(), properties);
        this.color = color;
    }

    protected MapCodec<? extends AbstractBannerBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DyenamicBannerBlockEntity(pos, state);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.below()).isSolid();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)(pContext.getRotation() + 180.0f))));
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing == Direction.DOWN && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(pRotation.rotate(((Integer)pState.getValue((Property)BlockStateProperties.ROTATION_16)).intValue(), 16)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(pMirror.mirror(((Integer)pState.getValue((Property)BlockStateProperties.ROTATION_16)).intValue(), 16)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.ROTATION_16});
    }

    public DyenamicDyeColor getDyenamicColor() {
        return this.color;
    }
}

