/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import cy.jdkdigital.dyenamics.Dyenamics;
import cy.jdkdigital.dyenamics.common.blockentity.DyenamicBedBlockEntity;
import cy.jdkdigital.dyenamics.core.init.BlockEntityInit;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class DyenamicBedRenderer
implements BlockEntityRenderer<DyenamicBedBlockEntity> {
    private final ModelPart headRoot;
    private final ModelPart footRoot;

    public DyenamicBedRenderer(BlockEntityRendererProvider.Context pContext) {
        this.headRoot = pContext.bakeLayer(ModelLayers.BED_HEAD);
        this.footRoot = pContext.bakeLayer(ModelLayers.BED_FOOT);
    }

    public void render(DyenamicBedBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Material material = Dyenamics.BED_MATERIAL_MAP.get(pBlockEntity.getColor().getSerializedName());
        Level level = pBlockEntity.getLevel();
        if (level != null) {
            BlockState blockstate = pBlockEntity.getBlockState();
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)((BlockEntityType)BlockEntityInit.BED.get()), BedBlock::getBlockType, BedBlock::getConnectedDirection, (DirectionProperty)ChestBlock.FACING, (BlockState)blockstate, (LevelAccessor)level, (BlockPos)pBlockEntity.getBlockPos(), (p_112202_, p_112203_) -> false);
            int i = ((Int2IntFunction)neighborcombineresult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(pPackedLight);
            this.renderPiece(pPoseStack, pBufferSource, blockstate.getValue((Property)BedBlock.PART) == BedPart.HEAD ? this.headRoot : this.footRoot, (Direction)blockstate.getValue((Property)BedBlock.FACING), material, i, pPackedOverlay, false);
        } else {
            this.renderPiece(pPoseStack, pBufferSource, this.headRoot, Direction.SOUTH, material, pPackedLight, pPackedOverlay, false);
            this.renderPiece(pPoseStack, pBufferSource, this.footRoot, Direction.SOUTH, material, pPackedLight, pPackedOverlay, true);
        }
    }

    private void renderPiece(PoseStack pPoseStack, MultiBufferSource pBufferSource, ModelPart pModelPart, Direction pDirection, Material pMaterial, int pPackedLight, int pPackedOverlay, boolean pFoot) {
        pPoseStack.pushPose();
        pPoseStack.translate(0.0, 0.5625, pFoot ? -1.0 : 0.0);
        pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        pPoseStack.translate(0.5, 0.5, 0.5);
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(180.0f + pDirection.toYRot()));
        pPoseStack.translate(-0.5, -0.5, -0.5);
        VertexConsumer vertexconsumer = pMaterial.buffer(pBufferSource, RenderType::entitySolid);
        pModelPart.render(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        pPoseStack.popPose();
    }
}

