/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import cy.jdkdigital.dyenamics.common.block.DyenamicBannerBlock;
import cy.jdkdigital.dyenamics.common.blockentity.DyenamicBannerBlockEntity;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;

public class DyenamicBannerRenderer
extends BannerRenderer {
    public DyenamicBannerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(BannerBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        DyenamicDyeColor dyenamicDyeColor;
        long i;
        boolean isItem = pBlockEntity.getLevel() == null;
        pPoseStack.pushPose();
        if (isItem) {
            i = 0L;
            pPoseStack.translate(0.5f, 0.5f, 0.5f);
            this.pole.visible = true;
        } else {
            i = pBlockEntity.getLevel().getGameTime();
            BlockState blockstate = pBlockEntity.getBlockState();
            if (blockstate.getBlock() instanceof DyenamicBannerBlock) {
                pPoseStack.translate(0.5f, 0.5f, 0.5f);
                float f1 = -RotationSegment.convertToDegrees((int)((Integer)blockstate.getValue((Property)BannerBlock.ROTATION)));
                pPoseStack.mulPose(Axis.YP.rotationDegrees(f1));
                this.pole.visible = true;
            } else {
                pPoseStack.translate(0.5f, -0.16666667f, 0.5f);
                float f3 = -((Direction)blockstate.getValue((Property)WallBannerBlock.FACING)).toYRot();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(f3));
                pPoseStack.translate(0.0f, -0.3125f, -0.4375f);
                this.pole.visible = false;
            }
        }
        pPoseStack.pushPose();
        pPoseStack.scale(0.6666667f, -0.6666667f, -0.6666667f);
        VertexConsumer vertexconsumer = ModelBakery.BANNER_BASE.buffer(pBuffer, RenderType::entitySolid);
        this.pole.render(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        this.bar.render(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        BlockPos blockpos = pBlockEntity.getBlockPos();
        float f2 = ((float)Math.floorMod((long)(blockpos.getX() * 7 + blockpos.getY() * 9 + blockpos.getZ() * 13) + i, 100L) + pPartialTick) / 100.0f;
        this.flag.xRot = (-0.0125f + 0.01f * Mth.cos((float)((float)Math.PI * 2 * f2))) * (float)Math.PI;
        this.flag.y = -32.0f;
        if (pBlockEntity instanceof DyenamicBannerBlockEntity) {
            DyenamicBannerBlockEntity dyenamicBannerBlockEntity = (DyenamicBannerBlockEntity)pBlockEntity;
            dyenamicDyeColor = dyenamicBannerBlockEntity.getDyenamicColor();
        } else {
            dyenamicDyeColor = DyenamicDyeColor.getColor(pBlockEntity.getBaseColor());
        }
        DyenamicDyeColor baseColor = dyenamicDyeColor;
        DyenamicBannerRenderer.renderPatterns(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, this.flag, ModelBakery.BANNER_BASE, true, baseColor, pBlockEntity.getPatterns(), false);
        pPoseStack.popPose();
        pPoseStack.popPose();
    }

    public static void renderPatterns(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, ModelPart pFlagPart, Material pFlagMaterial, boolean pBanner, DyenamicDyeColor pBaseColor, BannerPatternLayers pPatterns, boolean pGlint) {
        pFlagPart.render(pPoseStack, pFlagMaterial.buffer(pBuffer, RenderType::entitySolid, pGlint), pPackedLight, pPackedOverlay);
        DyenamicBannerRenderer.renderPatternLayer(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pFlagPart, pBanner ? Sheets.BANNER_BASE : Sheets.SHIELD_BASE, pBaseColor);
        for (int i = 0; i < 16 && i < pPatterns.layers().size(); ++i) {
            BannerPatternLayers.Layer patternLayer = (BannerPatternLayers.Layer)pPatterns.layers().get(i);
            Material material = pBanner ? Sheets.getBannerMaterial((Holder)patternLayer.pattern()) : Sheets.getShieldMaterial((Holder)patternLayer.pattern());
            DyenamicBannerRenderer.renderPatternLayer(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pFlagPart, material, DyenamicDyeColor.getColor(patternLayer.color()));
        }
    }

    private static void renderPatternLayer(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, ModelPart flagPart, Material material, DyenamicDyeColor color) {
        int i = color.getColorComponentValue();
        flagPart.render(poseStack, material.buffer(buffer, RenderType::entityNoOutline), packedLight, packedOverlay, i);
    }
}

