/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.util;

import com.ldtteam.domumornamentum.entity.block.AbstractMateriallyTexturedBlockEntity;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.fml.loading.FMLEnvironment;

public class BlockUtils {
    private BlockUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: BlockUtils. This is a utility class");
    }

    public static Component getHoverName(Block block) {
        return new ItemStack((ItemLike)block).getHoverName();
    }

    @Deprecated(forRemoval=true, since="1.21")
    public static List<ItemStack> getMaterializedDrops(LootParams.Builder builder, Property<?> ... blockStateProperties) {
        ItemStack stack = BlockUtils.getMaterializedItemStack((BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY), (HolderLookup.Provider)builder.getLevel().registryAccess(), blockStateProperties);
        if (!stack.isEmpty()) {
            return List.of(stack);
        }
        return Collections.emptyList();
    }

    public static ItemStack getMaterializedItemStack(BlockEntity blockEntity, HolderLookup.Provider provider, Property<?> ... blockStateProperties) {
        if (!(blockEntity instanceof AbstractMateriallyTexturedBlockEntity)) {
            return ItemStack.EMPTY;
        }
        AbstractMateriallyTexturedBlockEntity texturedBlockEntity = (AbstractMateriallyTexturedBlockEntity)blockEntity;
        ItemStack result = new ItemStack((ItemLike)blockEntity.getBlockState().getBlock());
        texturedBlockEntity.saveToItem(result, provider);
        if (blockStateProperties.length > 0) {
            BlockState blockState = texturedBlockEntity.getBlockState();
            result.update(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY, props -> {
                for (Property property : blockStateProperties) {
                    props = props.with(property, blockState);
                }
                return props;
            });
        }
        return result;
    }

    public static <T extends Comparable<T>> void putPropertyIntoBlockStateTag(ItemStack itemStack, Property<T> property, T value) {
        if (!FMLEnvironment.production && !(itemStack.getItem() instanceof BlockItem)) {
            throw new IllegalArgumentException("item not BlockItem: " + String.valueOf(itemStack.getItem()));
        }
        itemStack.update(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY, props -> props.with(property, value));
    }

    public static <T extends Comparable<T>> T getPropertyFromBlockStateTag(ItemStack itemStack, Property<T> property, T defaultValue) {
        Comparable blockValue = ((BlockItemStateProperties)itemStack.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY)).get(property);
        return (T)(blockValue == null ? defaultValue : blockValue);
    }
}

