/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.decoration;

import com.google.common.collect.ImmutableList;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.decorative.FancyTrapdoorBlock;
import com.ldtteam.domumornamentum.block.types.FancyTrapdoorType;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.item.BlockItemWithClientBePlacement;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.Constants;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;

public class FancyTrapdoorBlockItem
extends BlockItemWithClientBePlacement
implements IDoItem {
    private final FancyTrapdoorBlock trapdoorBlock;

    public FancyTrapdoorBlockItem(FancyTrapdoorBlock blockIn, Item.Properties builder) {
        super((Block)blockIn, builder);
        this.trapdoorBlock = blockIn;
    }

    public Component getName(ItemStack stack) {
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        IMateriallyTexturedBlockComponent coverComponent = (IMateriallyTexturedBlockComponent)this.trapdoorBlock.getComponents().get(0);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(coverComponent.getId(), coverComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return Component.translatable((String)"domum_ornamentum.fancytrapdoor.name.format", (Object[])new Object[]{centerBlockName});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
        FancyTrapdoorType trapdoorType = BlockUtils.getPropertyFromBlockStateTag(stack, FancyTrapdoorBlock.TYPE, FancyTrapdoorType.FULL);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.origin.tooltip"));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.fancytrapdoor.type.format", (Object[])new Object[]{Component.translatable((String)("domum_ornamentum.fancytrapdoor.type.name." + trapdoorType.getTranslationKeySuffix()))}));
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        IMateriallyTexturedBlockComponent trapDoorComponent = (IMateriallyTexturedBlockComponent)this.trapdoorBlock.getComponents().get(0);
        Block trapDoorBlock = textureData.getTexturedComponents().getOrDefault(trapDoorComponent.getId(), trapDoorComponent.getDefault());
        Component trapDoorBlockName = BlockUtils.getHoverName(trapDoorBlock);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.desc.frame", (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{trapDoorBlockName})}));
        tooltip.add((Component)Component.literal((String)""));
        IMateriallyTexturedBlockComponent trapDoorFrameComponent = (IMateriallyTexturedBlockComponent)this.trapdoorBlock.getComponents().get(1);
        Block trapDoorFrameBlock = textureData.getTexturedComponents().getOrDefault(trapDoorFrameComponent.getId(), trapDoorFrameComponent.getDefault());
        Component trapDoorFrameBlockName = BlockUtils.getHoverName(trapDoorFrameBlock);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.desc.center", (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{trapDoorFrameBlockName})}));
    }

    @Override
    public List<ResourceLocation> getInputIds() {
        return ImmutableList.of((Object)Constants.resLocDO("frame"), (Object)Constants.resLocDO("center"));
    }

    @Override
    public ResourceLocation getGroup() {
        return Constants.resLocDO("etrapdoor");
    }
}

