/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.entity.block;

import com.ldtteam.domumornamentum.block.decorative.DynamicTimberFrameBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.client.model.properties.ModProperties;
import com.ldtteam.domumornamentum.component.ModDataComponents;
import com.ldtteam.domumornamentum.entity.block.AbstractMateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.entity.block.ModBlockEntityTypes;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class DynamicTimberFrameBlockEntity
extends AbstractMateriallyTexturedBlockEntity {
    public static final ResourceLocation NORTH_UP = ResourceLocation.withDefaultNamespace((String)"block/white_wool");
    public static final ResourceLocation NORTH_DOWN = ResourceLocation.withDefaultNamespace((String)"block/orange_wool");
    public static final ResourceLocation SOUTH_UP = ResourceLocation.withDefaultNamespace((String)"block/magenta_wool");
    public static final ResourceLocation SOUTH_DOWN = ResourceLocation.withDefaultNamespace((String)"block/light_blue_wool");
    public static final ResourceLocation EAST_DOWN = ResourceLocation.withDefaultNamespace((String)"block/yellow_wool");
    public static final ResourceLocation EAST_UP = ResourceLocation.withDefaultNamespace((String)"block/lime_wool");
    public static final ResourceLocation WEST_DOWN = ResourceLocation.withDefaultNamespace((String)"block/pink_wool");
    public static final ResourceLocation WEST_UP = ResourceLocation.withDefaultNamespace((String)"block/gray_wool");
    public static final ResourceLocation NORTH_EAST_DOWN = ResourceLocation.withDefaultNamespace((String)"block/light_gray_wool");
    public static final ResourceLocation NORTH_EAST_UP = ResourceLocation.withDefaultNamespace((String)"block/cyan_wool");
    public static final ResourceLocation NORTH_EAST_CORNER = ResourceLocation.withDefaultNamespace((String)"block/purple_wool");
    public static final ResourceLocation NORTH_WEST_DOWN = ResourceLocation.withDefaultNamespace((String)"block/blue_wool");
    public static final ResourceLocation NORTH_WEST_UP = ResourceLocation.withDefaultNamespace((String)"block/brown_wool");
    public static final ResourceLocation NORTH_WEST_CORNER = ResourceLocation.withDefaultNamespace((String)"block/green_wool");
    public static final ResourceLocation SOUTH_EAST_DOWN = ResourceLocation.withDefaultNamespace((String)"block/red_wool");
    public static final ResourceLocation SOUTH_EAST_UP = ResourceLocation.withDefaultNamespace((String)"block/black_wool");
    public static final ResourceLocation SOUTH_EAST_CORNER = ResourceLocation.withDefaultNamespace((String)"block/white_terracotta");
    public static final ResourceLocation SOUTH_WEST_DOWN = ResourceLocation.withDefaultNamespace((String)"block/orange_terracotta");
    public static final ResourceLocation SOUTH_WEST_UP = ResourceLocation.withDefaultNamespace((String)"block/magenta_terracotta");
    public static final ResourceLocation SOUTH_WEST_CORNER = ResourceLocation.withDefaultNamespace((String)"block/light_blue_terracotta");
    public static final ResourceLocation CENTER = ResourceLocation.withDefaultNamespace((String)"block/yellow_terracotta");
    public static final ResourceLocation BOTTOM_CENTER = ResourceLocation.withDefaultNamespace((String)"block/lime_terracotta");
    public static final ResourceLocation BOTTOM_SOUTH_CENTER = ResourceLocation.withDefaultNamespace((String)"block/pink_terracotta");
    public static final ResourceLocation BOTTOM_NORTH_CENTER = ResourceLocation.withDefaultNamespace((String)"block/gray_terracotta");
    public static final ResourceLocation TOP_NORTH_CENTER = ResourceLocation.withDefaultNamespace((String)"block/light_gray_terracotta");
    public static final ResourceLocation TOP_SOUTH_CENTER = ResourceLocation.withDefaultNamespace((String)"block/cyan_terracotta");
    public static final ResourceLocation TOP_CENTER = ResourceLocation.withDefaultNamespace((String)"block/purple_terracotta");
    public static final ResourceLocation NORTH_WEST_CENTER = ResourceLocation.withDefaultNamespace((String)"block/blue_terracotta");
    public static final ResourceLocation NORTH_EAST_CENTER = ResourceLocation.withDefaultNamespace((String)"block/brown_terracotta");
    public static final ResourceLocation NORTH_WEST_UP_CENTER = ResourceLocation.withDefaultNamespace((String)"block/green_terracotta");
    public static final ResourceLocation NORTH_EAST_UP_CENTER = ResourceLocation.withDefaultNamespace((String)"block/red_terracotta");
    public static final ResourceLocation NORTH_EAST_DOWN_CENTER = ResourceLocation.withDefaultNamespace((String)"block/black_terracotta");
    public static final ResourceLocation NORTH_WEST_DOWN_CENTER = ResourceLocation.withDefaultNamespace((String)"block/white_concrete");
    public static final ResourceLocation SOUTH_EAST_CENTER = ResourceLocation.withDefaultNamespace((String)"block/orange_concrete");
    public static final ResourceLocation SOUTH_WEST_CENTER = ResourceLocation.withDefaultNamespace((String)"block/magenta_concrete");
    public static final ResourceLocation SOUTH_WEST_UP_CENTER = ResourceLocation.withDefaultNamespace((String)"block/light_blue_concrete");
    public static final ResourceLocation SOUTH_EAST_UP_CENTER = ResourceLocation.withDefaultNamespace((String)"block/yellow_concrete");
    public static final ResourceLocation SOUTH_EAST_DOWN_CENTER = ResourceLocation.withDefaultNamespace((String)"block/lime_concrete");
    public static final ResourceLocation SOUTH_WEST_DOWN_CENTER = ResourceLocation.withDefaultNamespace((String)"block/pink_concrete");
    public static final ResourceLocation EAST_NORTH_CENTER = ResourceLocation.withDefaultNamespace((String)"block/gray_concrete");
    public static final ResourceLocation EAST_SOUTH_CENTER = ResourceLocation.withDefaultNamespace((String)"block/light_gray_concrete");
    public static final ResourceLocation EAST_SOUTH_UP_CENTER = ResourceLocation.withDefaultNamespace((String)"block/cyan_concrete");
    public static final ResourceLocation EAST_NORTH_UP_CENTER = ResourceLocation.withDefaultNamespace((String)"block/purple_concrete");
    public static final ResourceLocation EAST_SOUTH_DOWN_CENTER = ResourceLocation.withDefaultNamespace((String)"block/blue_concrete");
    public static final ResourceLocation EAST_NORTH_DOWN_CENTER = ResourceLocation.withDefaultNamespace((String)"block/brown_concrete");
    public static final ResourceLocation WEST_NORTH_CENTER = ResourceLocation.withDefaultNamespace((String)"block/green_concrete");
    public static final ResourceLocation WEST_SOUTH_CENTER = ResourceLocation.withDefaultNamespace((String)"block/red_concrete");
    public static final ResourceLocation WEST_SOUTH_UP_CENTER = ResourceLocation.withDefaultNamespace((String)"block/black_concrete");
    public static final ResourceLocation WEST_NORTH_UP_CENTER = ResourceLocation.withDefaultNamespace((String)"block/glowstone");
    public static final ResourceLocation WEST_SOUTH_DOWN_CENTER = ResourceLocation.withDefaultNamespace((String)"block/cherry_planks");
    public static final ResourceLocation WEST_NORTH_DOWN_CENTER = ResourceLocation.withDefaultNamespace((String)"block/shroomlight");
    private MaterialTextureData textureDataCache = new MaterialTextureData(Map.of());
    private final Map<ResourceLocation, Block> textureMapping = new TreeMap<ResourceLocation, Block>();
    private Object2BooleanOpenHashMap<DynamicTimberFrameBlock.Offset> offsets = new Object2BooleanOpenHashMap();
    private Block centerBlock;
    private Block frameBlock;
    private boolean checkedAfterStartup = false;
    @NotNull
    private MaterialTextureData originalTextureData = new MaterialTextureData(new HashMap<ResourceLocation, Block>());

    public DynamicTimberFrameBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.DYNAMIC_TIMBERFRAME.get(), pos, state);
        this.centerBlock = Blocks.OAK_PLANKS;
        this.frameBlock = Blocks.DARK_OAK_PLANKS;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithId(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(Objects.requireNonNull(packet.getTag()), lookupProvider);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.put("originalTextureData", (Tag)this.originalTextureData.serializeNBT());
        compound.putString("primaryBlock", BuiltInRegistries.BLOCK.getKey((Object)this.centerBlock).toString());
        compound.putString("secondaryBlock", BuiltInRegistries.BLOCK.getKey((Object)this.frameBlock).toString());
        ListTag listTag = new ListTag();
        for (Object2BooleanMap.Entry mapEntry : this.offsets.object2BooleanEntrySet()) {
            CompoundTag localCompound = new CompoundTag();
            localCompound.putInt("offset", ((DynamicTimberFrameBlock.Offset)((Object)mapEntry.getKey())).ordinal());
            localCompound.putBoolean("bool", mapEntry.getBooleanValue());
            listTag.add((Object)localCompound);
        }
        compound.put("offsets", (Tag)listTag);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        ResourceLocation secondaryBlockName;
        ResourceLocation primaryBlockName;
        super.loadAdditional(nbt, registries);
        if (nbt.contains("originalTextureData")) {
            MaterialTextureData.deserializeFromNBT(nbt.getCompound("originalTextureData"));
        }
        if (BuiltInRegistries.BLOCK.get(primaryBlockName = ResourceLocation.parse((String)nbt.getString("primaryBlock"))) != Blocks.AIR) {
            this.centerBlock = (Block)BuiltInRegistries.BLOCK.get(primaryBlockName);
        }
        if (BuiltInRegistries.BLOCK.get(secondaryBlockName = ResourceLocation.parse((String)nbt.getString("secondaryBlock"))) != Blocks.AIR) {
            this.frameBlock = (Block)BuiltInRegistries.BLOCK.get(secondaryBlockName);
        }
        this.offsets.clear();
        for (Tag tag : nbt.getList("offsets", 10)) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.offsets.put((Object)DynamicTimberFrameBlock.Offset.values()[compoundTag.getInt("offset")], compoundTag.getBoolean("bool"));
        }
        if (this.level != null && this.level.isClientSide) {
            this.refreshTextureCache();
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        MaterialTextureData testTextureData = (MaterialTextureData)componentInput.getOrDefault(ModDataComponents.TEXTURE_DATA, (Object)MaterialTextureData.EMPTY);
        if (testTextureData.isEmpty()) {
            testTextureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(this.getBlockState().getBlock());
        }
        this.updateTextureDataWith(testTextureData);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder componentBuilder) {
        super.collectImplicitComponents(componentBuilder);
        componentBuilder.set(ModDataComponents.TEXTURE_DATA, (Object)this.originalTextureData);
    }

    public void removeComponentsFromTag(CompoundTag itemStackTag) {
        itemStackTag.remove("textureData");
    }

    @Override
    public void updateTextureDataWith(MaterialTextureData materialTextureData) {
        this.centerBlock = materialTextureData.getTexturedComponents().get(ResourceLocation.withDefaultNamespace((String)"block/dark_oak_planks"));
        this.frameBlock = materialTextureData.getTexturedComponents().get(ResourceLocation.withDefaultNamespace((String)"block/oak_planks"));
        this.handleTextureMapping();
        this.originalTextureData = materialTextureData;
    }

    private void handleTextureMapping() {
        this.textureMapping.put(NORTH_UP, this.frameBlock);
        this.textureMapping.put(NORTH_DOWN, this.frameBlock);
        this.textureMapping.put(SOUTH_UP, this.frameBlock);
        this.textureMapping.put(SOUTH_DOWN, this.frameBlock);
        this.textureMapping.put(EAST_DOWN, this.frameBlock);
        this.textureMapping.put(EAST_UP, this.frameBlock);
        this.textureMapping.put(WEST_DOWN, this.frameBlock);
        this.textureMapping.put(WEST_UP, this.frameBlock);
        this.textureMapping.put(NORTH_EAST_DOWN, this.frameBlock);
        this.textureMapping.put(NORTH_EAST_UP, this.frameBlock);
        this.textureMapping.put(NORTH_EAST_CORNER, this.frameBlock);
        this.textureMapping.put(NORTH_WEST_DOWN, this.frameBlock);
        this.textureMapping.put(NORTH_WEST_UP, this.frameBlock);
        this.textureMapping.put(NORTH_WEST_CORNER, this.frameBlock);
        this.textureMapping.put(SOUTH_EAST_DOWN, this.frameBlock);
        this.textureMapping.put(SOUTH_EAST_UP, this.frameBlock);
        this.textureMapping.put(SOUTH_EAST_CORNER, this.frameBlock);
        this.textureMapping.put(SOUTH_WEST_DOWN, this.frameBlock);
        this.textureMapping.put(SOUTH_WEST_UP, this.frameBlock);
        this.textureMapping.put(SOUTH_WEST_CORNER, this.frameBlock);
        this.textureMapping.put(CENTER, this.centerBlock);
        this.textureMapping.put(BOTTOM_CENTER, this.centerBlock);
        this.textureMapping.put(BOTTOM_SOUTH_CENTER, this.centerBlock);
        this.textureMapping.put(BOTTOM_NORTH_CENTER, this.centerBlock);
        this.textureMapping.put(TOP_NORTH_CENTER, this.centerBlock);
        this.textureMapping.put(TOP_SOUTH_CENTER, this.centerBlock);
        this.textureMapping.put(TOP_CENTER, this.centerBlock);
        this.textureMapping.put(NORTH_WEST_CENTER, Blocks.AIR);
        this.textureMapping.put(NORTH_EAST_CENTER, Blocks.AIR);
        this.textureMapping.put(NORTH_WEST_UP_CENTER, Blocks.AIR);
        this.textureMapping.put(NORTH_EAST_UP_CENTER, Blocks.AIR);
        this.textureMapping.put(NORTH_EAST_DOWN_CENTER, Blocks.AIR);
        this.textureMapping.put(NORTH_WEST_DOWN_CENTER, Blocks.AIR);
        this.textureMapping.put(SOUTH_EAST_CENTER, Blocks.AIR);
        this.textureMapping.put(SOUTH_WEST_CENTER, Blocks.AIR);
        this.textureMapping.put(SOUTH_WEST_UP_CENTER, Blocks.AIR);
        this.textureMapping.put(SOUTH_EAST_UP_CENTER, Blocks.AIR);
        this.textureMapping.put(SOUTH_EAST_DOWN_CENTER, Blocks.AIR);
        this.textureMapping.put(SOUTH_WEST_DOWN_CENTER, Blocks.AIR);
        this.textureMapping.put(EAST_NORTH_CENTER, Blocks.AIR);
        this.textureMapping.put(EAST_SOUTH_CENTER, Blocks.AIR);
        this.textureMapping.put(EAST_SOUTH_UP_CENTER, Blocks.AIR);
        this.textureMapping.put(EAST_NORTH_UP_CENTER, Blocks.AIR);
        this.textureMapping.put(EAST_SOUTH_DOWN_CENTER, Blocks.AIR);
        this.textureMapping.put(EAST_NORTH_DOWN_CENTER, Blocks.AIR);
        this.textureMapping.put(WEST_NORTH_CENTER, Blocks.AIR);
        this.textureMapping.put(WEST_SOUTH_CENTER, Blocks.AIR);
        this.textureMapping.put(WEST_SOUTH_UP_CENTER, Blocks.AIR);
        this.textureMapping.put(WEST_NORTH_UP_CENTER, Blocks.AIR);
        this.textureMapping.put(WEST_SOUTH_DOWN_CENTER, Blocks.AIR);
        this.textureMapping.put(WEST_NORTH_DOWN_CENTER, Blocks.AIR);
    }

    public void refreshTextureCache() {
        this.textureMapping.clear();
        this.handleTextureMapping();
        for (Object2BooleanMap.Entry offset : this.offsets.object2BooleanEntrySet()) {
            if (!offset.getBooleanValue()) continue;
            switch ((DynamicTimberFrameBlock.Offset)((Object)offset.getKey())) {
                case UP: {
                    this.textureMapping.put(NORTH_UP, Blocks.AIR);
                    this.textureMapping.put(EAST_UP, Blocks.AIR);
                    this.textureMapping.put(SOUTH_UP, Blocks.AIR);
                    this.textureMapping.put(WEST_UP, Blocks.AIR);
                    break;
                }
                case DOWN: {
                    this.textureMapping.put(NORTH_DOWN, Blocks.AIR);
                    this.textureMapping.put(EAST_DOWN, Blocks.AIR);
                    this.textureMapping.put(SOUTH_DOWN, Blocks.AIR);
                    this.textureMapping.put(WEST_DOWN, Blocks.AIR);
                    break;
                }
                case EAST: {
                    this.textureMapping.put(NORTH_EAST_CORNER, Blocks.AIR);
                    this.textureMapping.put(SOUTH_EAST_CORNER, Blocks.AIR);
                    this.textureMapping.put(SOUTH_EAST_CENTER, this.centerBlock);
                    this.textureMapping.put(NORTH_EAST_CENTER, this.centerBlock);
                    break;
                }
                case WEST: {
                    this.textureMapping.put(NORTH_WEST_CORNER, Blocks.AIR);
                    this.textureMapping.put(SOUTH_WEST_CORNER, Blocks.AIR);
                    this.textureMapping.put(SOUTH_WEST_CENTER, this.centerBlock);
                    this.textureMapping.put(NORTH_WEST_CENTER, this.centerBlock);
                    break;
                }
                case NORTH: {
                    this.textureMapping.put(NORTH_EAST_CORNER, Blocks.AIR);
                    this.textureMapping.put(NORTH_WEST_CORNER, Blocks.AIR);
                    this.textureMapping.put(EAST_NORTH_CENTER, this.centerBlock);
                    this.textureMapping.put(WEST_NORTH_CENTER, this.centerBlock);
                    break;
                }
                case SOUTH: {
                    this.textureMapping.put(SOUTH_EAST_CORNER, Blocks.AIR);
                    this.textureMapping.put(SOUTH_WEST_CORNER, Blocks.AIR);
                    this.textureMapping.put(EAST_SOUTH_CENTER, this.centerBlock);
                    this.textureMapping.put(WEST_SOUTH_CENTER, this.centerBlock);
                }
            }
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.NORTH)) {
            this.textureMapping.put(NORTH_UP, this.centerBlock);
            this.textureMapping.put(NORTH_DOWN, this.centerBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.SOUTH)) {
            this.textureMapping.put(SOUTH_UP, this.centerBlock);
            this.textureMapping.put(SOUTH_DOWN, this.centerBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.EAST)) {
            this.textureMapping.put(EAST_UP, this.centerBlock);
            this.textureMapping.put(EAST_DOWN, this.centerBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.WEST)) {
            this.textureMapping.put(WEST_UP, this.centerBlock);
            this.textureMapping.put(WEST_DOWN, this.centerBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.EAST) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP_EAST)) {
                this.textureMapping.put(SOUTH_EAST_UP, Blocks.AIR);
                this.textureMapping.put(NORTH_EAST_UP, Blocks.AIR);
                this.textureMapping.put(SOUTH_EAST_UP_CENTER, this.centerBlock);
                this.textureMapping.put(NORTH_EAST_UP_CENTER, this.centerBlock);
            }
            this.textureMapping.put(EAST_UP, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.NORTH) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP_NORTH)) {
                this.textureMapping.put(NORTH_WEST_UP, Blocks.AIR);
                this.textureMapping.put(NORTH_EAST_UP, Blocks.AIR);
                this.textureMapping.put(WEST_NORTH_UP_CENTER, this.centerBlock);
                this.textureMapping.put(EAST_NORTH_UP_CENTER, this.centerBlock);
            }
            this.textureMapping.put(NORTH_UP, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.SOUTH) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP_SOUTH)) {
                this.textureMapping.put(SOUTH_WEST_UP, Blocks.AIR);
                this.textureMapping.put(SOUTH_EAST_UP, Blocks.AIR);
                this.textureMapping.put(EAST_SOUTH_UP_CENTER, this.centerBlock);
                this.textureMapping.put(WEST_SOUTH_UP_CENTER, this.centerBlock);
            }
            this.textureMapping.put(SOUTH_UP, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.WEST) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP_WEST)) {
                this.textureMapping.put(NORTH_WEST_UP, Blocks.AIR);
                this.textureMapping.put(SOUTH_WEST_UP, Blocks.AIR);
                this.textureMapping.put(NORTH_WEST_UP_CENTER, this.centerBlock);
                this.textureMapping.put(SOUTH_WEST_UP_CENTER, this.centerBlock);
            }
            this.textureMapping.put(WEST_UP, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.EAST) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN_EAST)) {
                this.textureMapping.put(NORTH_EAST_DOWN, Blocks.AIR);
                this.textureMapping.put(SOUTH_EAST_DOWN, Blocks.AIR);
                this.textureMapping.put(NORTH_EAST_DOWN_CENTER, this.centerBlock);
                this.textureMapping.put(SOUTH_EAST_DOWN_CENTER, this.centerBlock);
            }
            this.textureMapping.put(EAST_DOWN, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.NORTH) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN_NORTH)) {
                this.textureMapping.put(NORTH_WEST_DOWN, Blocks.AIR);
                this.textureMapping.put(NORTH_EAST_DOWN, Blocks.AIR);
                this.textureMapping.put(WEST_NORTH_DOWN_CENTER, this.centerBlock);
                this.textureMapping.put(EAST_NORTH_DOWN_CENTER, this.centerBlock);
            }
            this.textureMapping.put(NORTH_DOWN, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.SOUTH) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN_SOUTH)) {
                this.textureMapping.put(SOUTH_WEST_DOWN, Blocks.AIR);
                this.textureMapping.put(SOUTH_EAST_DOWN, Blocks.AIR);
                this.textureMapping.put(WEST_SOUTH_DOWN_CENTER, this.centerBlock);
                this.textureMapping.put(EAST_SOUTH_DOWN_CENTER, this.centerBlock);
            }
            this.textureMapping.put(SOUTH_DOWN, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.WEST) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN_WEST)) {
                this.textureMapping.put(SOUTH_WEST_DOWN, Blocks.AIR);
                this.textureMapping.put(NORTH_WEST_DOWN, Blocks.AIR);
                this.textureMapping.put(SOUTH_WEST_DOWN_CENTER, this.centerBlock);
                this.textureMapping.put(NORTH_WEST_DOWN_CENTER, this.centerBlock);
            }
            this.textureMapping.put(WEST_DOWN, this.frameBlock);
        }
        this.textureDataCache = new MaterialTextureData(this.textureMapping);
        this.requestModelDataUpdate();
        if (this.level != null) {
            this.setChanged();
            this.level.getChunk(this.worldPosition.getX() >> 4, this.worldPosition.getZ() >> 4).setUnsaved(true);
            this.level.sendBlockUpdated(this.getBlockPos(), Blocks.AIR.defaultBlockState(), this.getBlockState(), 3);
        }
    }

    @NotNull
    public ModelData getModelData() {
        if (!this.checkedAfterStartup && this.level != null) {
            this.checkedAfterStartup = true;
            this.refreshTextureCache();
        }
        return ModelData.builder().with(ModProperties.MATERIAL_TEXTURE_PROPERTY, (Object)this.textureDataCache).build();
    }

    @Override
    @NotNull
    public MaterialTextureData getTextureData() {
        return this.originalTextureData;
    }

    public void onNeighborUpdate(DynamicTimberFrameBlockEntity newNeighbor, DynamicTimberFrameBlock.Offset offset, boolean added) {
        if (newNeighbor != null && (newNeighbor.frameBlock != this.frameBlock || newNeighbor.centerBlock != this.centerBlock)) {
            return;
        }
        this.offsets.put((Object)offset, added);
        this.refreshTextureCache();
    }

    public void resetOffsets() {
        this.offsets.clear();
    }

    public Block getFrameBlock() {
        return this.frameBlock;
    }

    public Block getCenterBlock() {
        return this.centerBlock;
    }

    public void rotate(int rotation) {
        Object2BooleanOpenHashMap resultMap = new Object2BooleanOpenHashMap();
        for (Map.Entry entry : this.offsets.entrySet()) {
            DynamicTimberFrameBlock.Offset offset = (DynamicTimberFrameBlock.Offset)((Object)entry.getKey());
            for (int i = 0; i < rotation; ++i) {
                offset = offset.rotate();
            }
            resultMap.put((Object)offset, (Boolean)entry.getValue());
        }
        this.offsets.clear();
        this.offsets.putAll((Map)resultMap);
    }
}

