/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.door.fancy;

import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.FancyDoorBlock;
import com.ldtteam.domumornamentum.block.types.FancyDoorType;
import com.ldtteam.domumornamentum.datagen.MateriallyTexturedModelBuilder;
import com.ldtteam.domumornamentum.datagen.utils.ModelBuilderUtils;
import com.ldtteam.domumornamentum.util.Constants;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class FancyDoorsBlockStateProvider
extends BlockStateProvider {
    public FancyDoorsBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "domum_ornamentum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.FancyDoorBlock(ModBlocks.getInstance().getFancyDoor(), FancyDoorType::getSerializedName);
    }

    private void FancyDoorBlock(FancyDoorBlock block, Function<FancyDoorType, String> baseName) {
        Function<FancyDoorType, ModelFile> bottomLeft = this.createModel(baseName, "bottom_left");
        Function<FancyDoorType, ModelFile> bottomLeftOpen = this.createModel(baseName, "bottom_left_open");
        Function<FancyDoorType, ModelFile> bottomRight = this.createModel(baseName, "bottom_right");
        Function<FancyDoorType, ModelFile> bottomRightOpen = this.createModel(baseName, "bottom_right_open");
        Function<FancyDoorType, ModelFile> topLeft = this.createModel(baseName, "top_left");
        Function<FancyDoorType, ModelFile> topLeftOpen = this.createModel(baseName, "top_left_open");
        Function<FancyDoorType, ModelFile> topRight = this.createModel(baseName, "top_right");
        Function<FancyDoorType, ModelFile> topRightOpen = this.createModel(baseName, "top_right_open");
        this.FancyDoorBlock(block, bottomLeft, bottomLeftOpen, bottomRight, bottomRightOpen, topLeft, topLeftOpen, topRight, topRightOpen);
    }

    private Function<FancyDoorType, ModelFile> createModel(Function<FancyDoorType, String> baseName, String stateDescription) {
        return type -> ((MateriallyTexturedModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/door/fancy/door_" + (String)baseName.apply((FancyDoorType)((Object)type)) + "_" + stateDescription, Constants.resLocDO("block/door/fancy/door_" + (String)baseName.apply((FancyDoorType)((Object)type)) + "_" + stateDescription + "_spec"))).customLoader(MateriallyTexturedModelBuilder::new)).end();
    }

    public void FancyDoorBlock(FancyDoorBlock block, Function<FancyDoorType, ModelFile> bottomLeft, Function<FancyDoorType, ModelFile> bottomLeftOpen, Function<FancyDoorType, ModelFile> bottomRight, Function<FancyDoorType, ModelFile> bottomRightOpen, Function<FancyDoorType, ModelFile> topLeft, Function<FancyDoorType, ModelFile> topLeftOpen, Function<FancyDoorType, ModelFile> topRight, Function<FancyDoorType, ModelFile> topRightOpen) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.getValue((Property)FancyDoorBlock.FACING)).toYRot() + 90;
            boolean right = state.getValue((Property)FancyDoorBlock.HINGE) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.getValue((Property)FancyDoorBlock.OPEN);
            boolean lower = state.getValue((Property)FancyDoorBlock.HALF) == DoubleBlockHalf.LOWER;
            FancyDoorType type = (FancyDoorType)((Object)((Object)state.getValue(FancyDoorBlock.TYPE)));
            if (open) {
                yRot += 90;
            }
            if (right && open) {
                yRot += 180;
            }
            yRot %= 360;
            ModelFile model = null;
            if (lower && right && open) {
                model = (ModelFile)bottomRightOpen.apply(type);
            } else if (lower && !right && open) {
                model = (ModelFile)bottomLeftOpen.apply(type);
            }
            if (lower && right && !open) {
                model = (ModelFile)bottomRight.apply(type);
            } else if (lower && !right && !open) {
                model = (ModelFile)bottomLeft.apply(type);
            }
            if (!lower && right && open) {
                model = (ModelFile)topRightOpen.apply(type);
            } else if (!lower && !right && open) {
                model = (ModelFile)topLeftOpen.apply(type);
            }
            if (!lower && right && !open) {
                model = (ModelFile)topRight.apply(type);
            } else if (!(lower || right || open)) {
                model = (ModelFile)topLeft.apply(type);
            }
            return ConfiguredModel.builder().modelFile(model).rotationY(yRot).build();
        }, new Property[]{FancyDoorBlock.POWERED});
        ItemModelBuilder overarchingSpecBuilder = (ItemModelBuilder)this.itemModels().getBuilder(ModBlocks.getInstance().getFancyDoor().getRegistryName().getPath() + "_spec");
        ModelBuilderUtils.applyDoorItemTransforms(overarchingSpecBuilder);
        FancyDoorType[] values = FancyDoorType.values();
        for (int i = 0; i < values.length; ++i) {
            FancyDoorType value = values[i];
            overarchingSpecBuilder.override().predicate(Constants.DOOR_MODEL_OVERRIDE, (float)i).model((ModelFile)this.models().getExistingFile(Constants.resLocDO("item/door/fancy/door_" + value.getSerializedName() + "_spec"))).end();
        }
        ItemModelBuilder rootBuilder = (ItemModelBuilder)this.itemModels().getBuilder(ModBlocks.getInstance().getFancyDoor().getRegistryName().getPath());
        ModelBuilderUtils.applyDoorItemTransforms(rootBuilder);
        rootBuilder.customLoader(MateriallyTexturedModelBuilder::new);
        rootBuilder.parent((ModelFile)overarchingSpecBuilder);
    }

    @NotNull
    public String getName() {
        return "Fancy Doors BlockStates Provider";
    }
}

