/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.render;

import com.ldtteam.domumornamentum.client.render.ModRenderTypes;
import com.ldtteam.domumornamentum.util.ItemStackUtils;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

public class ModelGhostRenderer {
    private static final ModelGhostRenderer INSTANCE = new ModelGhostRenderer();
    private static final ByteBufferBuilder BUFFER_BUILDER = new ByteBufferBuilder(0x200000);
    private static BufferBuilderTransparent BUFFER = null;
    private static final float[] DIRECTIONAL_BRIGHTNESS = new float[]{0.5f, 1.0f, 0.7f, 0.7f, 0.6f, 0.6f};

    public static ModelGhostRenderer getInstance() {
        return INSTANCE;
    }

    private ModelGhostRenderer() {
    }

    public void renderGhost(PoseStack poseStack, ItemStack renderStack, Vec3 targetedRenderPos, BlockHitResult blockHitResult, ClientLevel level, boolean ignoreDepth) {
        boolean renderItemMode;
        List<ModelToRender> models;
        BlockState placementState;
        poseStack.pushPose();
        Vec3 camera = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        poseStack.translate(targetedRenderPos.x - camera.x - 1.25E-4, targetedRenderPos.y - camera.y + 1.25E-4, targetedRenderPos.z - camera.z - 1.25E-4);
        poseStack.scale(1.001f, 1.001f, 1.001f);
        Vector4f color = new Vector4f(0.0f, 0.0f, 1.0f, 0.5f);
        ModelData modelData = null;
        Item item = renderStack.getItem();
        if (item instanceof BlockItem) {
            EntityBlock entityBlock;
            BlockEntity blockEntity;
            BlockItem blockItem = (BlockItem)item;
            BlockPlaceContext context = new BlockPlaceContext((Player)Objects.requireNonNull(Minecraft.getInstance().player), Objects.requireNonNull(ItemStackUtils.getHandWithMateriallyTexturedItemStackFromPlayer((Player)Minecraft.getInstance().player)), renderStack, blockHitResult);
            placementState = blockItem.getBlock().getStateForPlacement(context);
            if (placementState == null) {
                poseStack.popPose();
                return;
            }
            placementState = ((BlockItemStateProperties)renderStack.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY)).apply(placementState);
            BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(placementState);
            Block block = blockItem.getBlock();
            if (block instanceof EntityBlock && (blockEntity = (entityBlock = (EntityBlock)block).newBlockEntity(context.getClickedPos(), placementState)) != null) {
                blockEntity.applyComponentsFromItemStack(renderStack);
                modelData = blockEntity.getModelData();
                modelData = model.getModelData((BlockAndTintGetter)Objects.requireNonNull(Minecraft.getInstance().level), context.getClickedPos(), placementState, modelData);
            }
            if (modelData == null) {
                modelData = ModelData.EMPTY;
            }
            RandomSource randomSource = RandomSource.create();
            randomSource.setSeed(42L);
            ChunkRenderTypeSet renderTypeSet = model.getRenderTypes(placementState, randomSource, modelData);
            models = renderTypeSet.asList().stream().map(renderType -> new ModelToRender(model, (RenderType)renderType)).toList();
            renderItemMode = false;
        } else {
            placementState = null;
            BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(renderStack, null, null, 0);
            List renderPasses = model.getRenderPasses(renderStack, true);
            modelData = ModelData.EMPTY;
            models = renderPasses.stream().flatMap(pass -> pass.getRenderTypes(renderStack, true).stream().map(type -> new ModelToRender((BakedModel)pass, (RenderType)type))).toList();
            renderItemMode = true;
        }
        this.renderGhost(placementState, blockHitResult.getBlockPos(), poseStack, models, modelData, color, false, renderItemMode);
        poseStack.popPose();
    }

    private void renderGhost(BlockState state, BlockPos pos, PoseStack poseStack, List<ModelToRender> models, ModelData modelData, Vector4f color, boolean renderColoredGhost, boolean renderItemMode) {
        RenderType renderType = renderColoredGhost ? ModRenderTypes.GHOST_BLOCK_COLORED_PREVIEW.get() : ModRenderTypes.GHOST_BLOCK_PREVIEW.get();
        BUFFER = new BufferBuilderTransparent(BUFFER_BUILDER, renderType.mode(), renderType.format());
        BUFFER.setAlphaPercentage(color.w());
        if (renderColoredGhost) {
            for (ModelToRender model : models) {
                ModelGhostRenderer.renderColoredModelLists(state, model, modelData, poseStack, color);
            }
        } else {
            for (ModelToRender model : models) {
                ModelGhostRenderer.renderFullModelLists(model, modelData, state, pos, poseStack, renderItemMode);
            }
        }
        MeshData meshData = BUFFER.buildOrThrow();
        renderType.draw(meshData);
        BUFFER = null;
    }

    private static Vector3f[] getShadedColors(Vector4f color) {
        return (Vector3f[])Arrays.stream(Direction.values()).map(direction -> {
            float brightness = DIRECTIONAL_BRIGHTNESS[direction.get3DDataValue()];
            return new Vector3f(color.x() * brightness, color.y() * brightness, color.z() * brightness);
        }).toArray(Vector3f[]::new);
    }

    private static Vector3f[] getNormals(PoseStack.Pose pose) {
        return (Vector3f[])Arrays.stream(Direction.values()).map(direction -> {
            Vec3i faceNormal = direction.getNormal();
            Vector3f normal = new Vector3f((float)faceNormal.getX(), (float)faceNormal.getY(), (float)faceNormal.getZ());
            normal.mul((Matrix3fc)pose.normal());
            return normal;
        }).toArray(Vector3f[]::new);
    }

    private static void renderFullModelLists(ModelToRender pModel, ModelData modelData, BlockState state, BlockPos pos, PoseStack pPoseStack, boolean renderItemMode) {
        RandomSource randomsource = RandomSource.create();
        for (Direction direction : Direction.values()) {
            randomsource.setSeed(42L);
            if (renderItemMode) {
                Minecraft.getInstance().getItemRenderer().renderQuadList(pPoseStack, (VertexConsumer)BUFFER, pModel.model().getQuads(state, direction, randomsource, modelData, pModel.renderType()), new ItemStack((ItemLike)state.getBlock()), 0xF000F0, OverlayTexture.NO_OVERLAY);
                continue;
            }
            ModelGhostRenderer.renderBlockTintedQuadList(pPoseStack, pModel.model().getQuads(state, direction, randomsource, modelData, pModel.renderType()), state, pos);
        }
        randomsource.setSeed(42L);
        if (renderItemMode) {
            Minecraft.getInstance().getItemRenderer().renderQuadList(pPoseStack, (VertexConsumer)BUFFER, pModel.model().getQuads(state, null, randomsource, modelData, pModel.renderType()), new ItemStack((ItemLike)state.getBlock()), 0xF000F0, OverlayTexture.NO_OVERLAY);
        } else {
            ModelGhostRenderer.renderBlockTintedQuadList(pPoseStack, pModel.model().getQuads(state, null, randomsource, modelData, pModel.renderType()), state, pos);
        }
    }

    private static void renderBlockTintedQuadList(PoseStack pPoseStack, List<BakedQuad> pQuads, BlockState placementState, BlockPos pos) {
        PoseStack.Pose posestack$pose = pPoseStack.last();
        for (BakedQuad bakedquad : pQuads) {
            int i = -1;
            if (bakedquad.isTinted()) {
                i = Minecraft.getInstance().getBlockColors().getColor(placementState, (BlockAndTintGetter)Minecraft.getInstance().level, pos, bakedquad.getTintIndex());
            }
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            BUFFER.putBulkData(posestack$pose, bakedquad, f, f1, f2, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY, true);
        }
    }

    private static void renderColoredModelLists(BlockState state, ModelToRender model, ModelData modelData, PoseStack poseStack, Vector4f color) {
        RandomSource random = RandomSource.create((long)42L);
        Vector3f[] normals = ModelGhostRenderer.getNormals(poseStack.last());
        Vector3f[] shadedColors = ModelGhostRenderer.getShadedColors(color);
        Vector4f pos = new Vector4f();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            ModelGhostRenderer.renderColoredQuadList(poseStack.last().pose(), model.model().getQuads(state, direction, random, modelData, model.renderType()), normals, shadedColors, pos);
        }
        random.setSeed(42L);
        ModelGhostRenderer.renderColoredQuadList(poseStack.last().pose(), model.model().getQuads(state, null, random, modelData, model.renderType()), normals, shadedColors, pos);
    }

    private static void renderColoredQuadList(Matrix4f pose, List<BakedQuad> quads, Vector3f[] normals, Vector3f[] shadedColors, Vector4f pos) {
        for (BakedQuad quad : quads) {
            ModelGhostRenderer.putColoredBulkData(pose, quad, shadedColors[quad.getDirection().ordinal()], normals[quad.getDirection().ordinal()], pos);
        }
    }

    private static void putColoredBulkData(Matrix4f pose, BakedQuad bakedQuad, Vector3f color, Vector3f normal, Vector4f pos) {
        int[] vertices = bakedQuad.getVertices();
        int vertexCount = vertices.length / (DefaultVertexFormat.BLOCK.getVertexSize() / 4);
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.BLOCK.getVertexSize());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int v = 0; v < vertexCount; ++v) {
                ((Buffer)intbuffer).clear();
                intbuffer.put(vertices, v * 8, 8);
                pos.set(bytebuffer.getFloat(0), bytebuffer.getFloat(4), bytebuffer.getFloat(8), 1.0f);
                pos.mul((Matrix4fc)pose);
                BUFFER.addVertex(pos.x(), pos.y(), pos.z()).setColor(color.x(), color.y(), color.z(), 1.0f).setNormal(normal.x(), normal.y(), normal.z());
            }
        }
    }

    private static class BufferBuilderTransparent
    extends BufferBuilder {
        private float alphaPercentage;

        public BufferBuilderTransparent(ByteBufferBuilder memory, VertexFormat.Mode mode, VertexFormat format) {
            super(memory, mode, format);
        }

        public void setAlphaPercentage(float alphaPercentage) {
            this.alphaPercentage = Mth.clamp((float)alphaPercentage, (float)0.0f, (float)1.0f);
        }

        @NotNull
        public VertexConsumer setColor(int red, int green, int blue, int alpha) {
            return super.setColor(red, green, blue, (int)((float)alpha * this.alphaPercentage));
        }

        public VertexConsumer setColor(int argb) {
            int newAlpha = (int)((float)(argb >> 24) * this.alphaPercentage);
            return super.setColor(newAlpha << 24 | argb & 0xFFFFFF);
        }

        public void addVertex(float x, float y, float z, int argb, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
            int newAlpha = (int)((float)(argb >> 24) * this.alphaPercentage);
            super.addVertex(x, y, z, newAlpha << 24 | argb & 0xFFFFFF, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ);
        }
    }

    private record ModelToRender(BakedModel model, RenderType renderType) {
    }
}

