/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.IMateriallyTexturedBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMateriallyTexturedBlock {
    @NotNull
    public Collection<IMateriallyTexturedBlockComponent> getComponents();

    public void buildRecipes(RecipeOutput var1);

    @NotNull
    default public MaterialTextureData getRandomMaterials() {
        MaterialTextureData.Builder textureData = MaterialTextureData.builder();
        for (IMateriallyTexturedBlockComponent component : this.getComponents()) {
            ArrayList<Block> candidates = new ArrayList<Block>(StreamSupport.stream(BuiltInRegistries.BLOCK.getTagOrEmpty(component.getValidSkins()).spliterator(), false).map(Holder::value).toList());
            if (candidates.isEmpty()) continue;
            Block texture = (Block)candidates.get(ThreadLocalRandom.current().nextInt(candidates.size()));
            textureData.setComponent(component.getId(), texture);
        }
        return textureData.build();
    }

    default public boolean isCorrectToolForDrops(BlockState state, ItemStack stack, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof IMateriallyTexturedBlockEntity) {
            IMateriallyTexturedBlockEntity mtbe = (IMateriallyTexturedBlockEntity)be;
            if (this.getMainComponent() == null) {
                return stack.isCorrectToolForDrops(state);
            }
            Block block = mtbe.getTextureData().getTexturedComponents().get(this.getMainComponent().getId());
            if (block != null) {
                return stack.isCorrectToolForDrops(block.defaultBlockState());
            }
        }
        return stack.isCorrectToolForDrops(state);
    }

    default public float getDOExplosionResistance(PropertyDispatch.QuadFunction<BlockState, BlockGetter, BlockPos, Explosion, Float> inputFunction, BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof IMateriallyTexturedBlockEntity) {
            IMateriallyTexturedBlockEntity mtbe = (IMateriallyTexturedBlockEntity)be;
            if (this.getMainComponent() == null) {
                return ((Float)inputFunction.apply((Object)state, (Object)level, (Object)pos, (Object)explosion)).floatValue();
            }
            Block block = mtbe.getTextureData().getTexturedComponents().get(this.getMainComponent().getId());
            if (block != null) {
                return block.getExplosionResistance(state, level, pos, explosion);
            }
        }
        return ((Float)inputFunction.apply((Object)state, (Object)level, (Object)pos, (Object)explosion)).floatValue();
    }

    default public float getDODestroyProgress(PropertyDispatch.QuadFunction<BlockState, Player, BlockGetter, BlockPos, Float> inputFunction, BlockState state, Player player, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof IMateriallyTexturedBlockEntity) {
            IMateriallyTexturedBlockEntity mtbe = (IMateriallyTexturedBlockEntity)be;
            if (this.getMainComponent() == null) {
                return ((Float)inputFunction.apply((Object)state, (Object)player, (Object)level, (Object)pos)).floatValue();
            }
            Block block = mtbe.getTextureData().getTexturedComponents().get(this.getMainComponent().getId());
            if (block != null) {
                return block.defaultBlockState().getDestroyProgress(player, level, pos);
            }
        }
        return ((Float)inputFunction.apply((Object)state, (Object)player, (Object)level, (Object)pos)).floatValue();
    }

    default public SoundType getDOSoundType(PropertyDispatch.QuadFunction<BlockState, LevelReader, BlockPos, Entity, SoundType> inputFunction, BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof IMateriallyTexturedBlockEntity) {
            IMateriallyTexturedBlockEntity mtbe = (IMateriallyTexturedBlockEntity)be;
            if (this.getMainComponent() == null) {
                return (SoundType)inputFunction.apply((Object)state, (Object)level, (Object)pos, (Object)entity);
            }
            Block block = mtbe.getTextureData().getTexturedComponents().get(this.getMainComponent().getId());
            if (block != null) {
                return block.getSoundType(state, level, pos, entity);
            }
        }
        return (SoundType)inputFunction.apply((Object)state, (Object)level, (Object)pos, (Object)entity);
    }

    default public void fillDOItemCategory(Block inputBlock, @NotNull NonNullList<ItemStack> items, List<ItemStack> fillItemGroupCache) {
        if (!fillItemGroupCache.isEmpty()) {
            items.addAll(fillItemGroupCache);
            return;
        }
        try {
            ItemStack result = new ItemStack((ItemLike)inputBlock);
            fillItemGroupCache.add(result);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        items.addAll(fillItemGroupCache);
    }

    default public IMateriallyTexturedBlockComponent getMainComponent() {
        return null;
    }

    default public boolean usesWorldSpecificTinting() {
        return true;
    }
}

