/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.core;

import com.cursee.monolib.util.toml.Toml;
import forge.com.cursee.disenchanting_table.core.CommonConfigValues;
import forge.com.cursee.disenchanting_table.platform.Services;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class ForgeCommonConfigHandler {
    private static final String[] DEFAULT_CONFIG = new String[]{"# setting this to \"true\" will cause the disenchanting table to operate automatically, taking experience from the nearest player and", "# enabling it to work with hoppers", "automatic_disenchanting = false", "# setting this to \"false\" will stop the disenchanting table from resetting the anvil cost", "resets_repair_cost = true", "# setting this to \"false\" will cause the disenchanting table to operate without taking experience at any point", "requires_experience = true", "# setting this to \"false\" will cause the disenchanting table to require levels instead of points", "uses_points = true", "# this value adjusts how many levels or points are required for the player to use the disenchanting table", "experience_cost = 25"};

    public static void onLoad() {
        new File(Services.PLATFORM.getGameDirectory() + File.separator + "config").mkdirs();
        File CONFIG_FILE = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config" + File.separator + "disenchanting_table-common.toml");
        ForgeCommonConfigHandler.handleConfig(CONFIG_FILE);
    }

    public static void handleConfig(File file) {
        if (!file.isFile()) {
            try (PrintWriter writer2 = new PrintWriter(file, StandardCharsets.UTF_8);){
                for (String s : DEFAULT_CONFIG) {
                    writer2.println(s);
                }
            }
            catch (Exception writer2) {
                // empty catch block
            }
            return;
        }
        try {
            Toml toml = new Toml().read(file);
            CommonConfigValues.automatic_disenchanting = toml.getBoolean("automatic_disenchanting");
            CommonConfigValues.resets_repair_cost = toml.getBoolean("resets_repair_cost");
            CommonConfigValues.requires_experience = toml.getBoolean("requires_experience");
            CommonConfigValues.uses_points = toml.getBoolean("uses_points");
            CommonConfigValues.experience_cost = Math.toIntExact(toml.getLong("experience_cost"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

