/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.client;

import com.cursee.monolib.util.toml.Toml;
import forge.com.cursee.disenchanting_table.client.ClientConfigValues;
import forge.com.cursee.disenchanting_table.platform.Services;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class ForgeClientConfigHandler {
    private static final String[] DEFAULT_CONFIG = new String[]{"# setting this to \"false\" will stop particles from rendering around the disenchanting table", "render_ender_particles = true", "# setting this to \"false\" will cause the \"Insufficient Experience\" text to not display", "experience_indicator = true", "# setting this to \" false\" will stop input/output items from displaying on the block", "render_table_item = true"};

    public static void onLoad() {
        new File(Services.PLATFORM.getGameDirectory() + File.separator + "config").mkdirs();
        File CONFIG_FILE = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config" + File.separator + "disenchanting_table-client.toml");
        ForgeClientConfigHandler.handleConfig(CONFIG_FILE);
    }

    private static void handleConfig(File file) {
        if (!file.isFile()) {
            try (PrintWriter writer2 = new PrintWriter(file, StandardCharsets.UTF_8);){
                for (String s : DEFAULT_CONFIG) {
                    writer2.println(s);
                }
            }
            catch (Exception writer2) {
                // empty catch block
            }
            return;
        }
        try {
            Toml toml = new Toml().read(file);
            ClientConfigValues.render_ender_particles = toml.getBoolean("render_ender_particles");
            ClientConfigValues.experience_indicator = toml.getBoolean("experience_indicator");
            ClientConfigValues.render_table_item = toml.getBoolean("render_table_item");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

