/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.disenchanting_table.core.util;

public class ExperienceHelper {
    public static int totalPointsFromLevelAndProgress(int experienceLevel, float experienceProgress) {
        if (experienceLevel < 0 || experienceProgress < 0.0f) {
            return 0;
        }
        return ExperienceHelper.totalPointsFromLevel(experienceLevel) + ExperienceHelper.totalPointsFromProgress(experienceLevel, experienceProgress);
    }

    public static int totalPointsFromLevel(int experienceLevel) {
        if (experienceLevel < 0) {
            return 0;
        }
        if (experienceLevel <= 16) {
            return (int)(Math.pow(experienceLevel, 2.0) + (double)(6 * experienceLevel));
        }
        if (experienceLevel <= 31) {
            return (int)(2.5 * Math.pow(experienceLevel, 2.0) - 40.5 * (double)experienceLevel + 360.0);
        }
        return (int)(4.5 * Math.pow(experienceLevel, 2.0) - 162.5 * (double)experienceLevel + 2220.0);
    }

    public static int totalPointsFromProgress(int experienceLevel, float experienceProgress) {
        int pointsAtCurrentLevel = ExperienceHelper.totalPointsFromLevel(experienceLevel);
        int pointsAtNextLevel = ExperienceHelper.totalPointsFromLevel(experienceLevel + 1);
        int totalFromCurrentToNext = pointsAtNextLevel - pointsAtCurrentLevel;
        return (int)((float)totalFromCurrentToNext * experienceProgress);
    }
}

