/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.spells.eldritch;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.events.SpellSummonEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.discerning_the_eldritch.entity.mobs.GaolerEntity;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEPotionEffectRegistry;
import net.acetheeldritchking.discerning_the_eldritch.spells.DTESpellAnimations;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class ConjureGaolerSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"discerning_the_eldritch", (String)"conjure_gaoler");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ELDRITCH_RESOURCE).setMaxLevel(1).setCooldownSeconds(600.0).build();

    public ConjureGaolerSpell() {
        this.manaCostPerLevel = 100;
        this.baseSpellPower = 25;
        this.spellPowerPerLevel = 1;
        this.castTime = 100;
        this.baseManaCost = 500;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public boolean isEnabled() {
        return false;
    }

    public boolean canBeCraftedBy(Player player) {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public AnimationHolder getCastStartAnimation() {
        return DTESpellAnimations.ANIMATION_GAOLER_SUMMON;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.WARDEN_HEARTBEAT);
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public void onServerPreCast(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        double radius = 15.0;
        List entitiesNearby = level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(radius));
        for (LivingEntity targets : entitiesNearby) {
            targets.addEffect(new MobEffectInstance(MobEffects.DARKNESS, this.getCastTime(spellLevel), 1, false, false, false));
        }
        entity.addEffect(new MobEffectInstance(MobEffects.DARKNESS, this.getCastTime(spellLevel), 1, false, false, false));
        super.onServerPreCast(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int summonTimer = (int)(20.0f * (20.0f * this.getSpellPower(spellLevel, (Entity)entity)));
        this.spawnGaoler(entity.getX(), entity.getY(), entity.getZ(), entity, level, summonTimer, spellLevel);
        entity.addEffect(new MobEffectInstance(DTEPotionEffectRegistry.GAOLER_TIMER, summonTimer, 0, false, false, true));
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private void spawnGaoler(double x, double y, double z, LivingEntity caster, Level level, int timer, int spellLevel) {
        GaolerEntity gaoler = new GaolerEntity(level, caster, true);
        gaoler.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(gaoler.getOnPos()), MobSpawnType.MOB_SUMMONED, null);
        gaoler.addEffect(new MobEffectInstance(DTEPotionEffectRegistry.GAOLER_TIMER, timer, 0, false, false, true));
        gaoler.setPos(caster.getX(), caster.getY(), caster.getZ() - 2.0);
        gaoler.setYRot(caster.getYRot());
        gaoler.setOldPosAndRot();
        SpellSummonEvent event = (SpellSummonEvent)NeoForge.EVENT_BUS.post((Event)new SpellSummonEvent(caster, (LivingEntity)gaoler, this.spellId, spellLevel));
        level.addFreshEntity((Entity)event.getCreature());
    }
}

