/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.discerning_the_eldritch.entity.mobs;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.IAnimatedAttacker;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.goals.AttackAnimationData;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericCopyOwnerTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericFollowOwnerGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtTargetGoal;
import io.redspace.ironsspellbooks.util.OwnerHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.acetheeldritchking.discerning_the_eldritch.entity.mobs.GaolerAnimatedWarlockAttackGoal;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEEntityRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.DTEPotionEffectRegistry;
import net.acetheeldritchking.discerning_the_eldritch.registries.SpellRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GaolerEntity
extends AbstractSpellCastingMob
implements IMagicSummon,
GeoAnimatable,
IAnimatedAttacker {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected LivingEntity cachedSummoner;
    protected UUID summonerUUID;
    private int riseAnimationTime = 40;
    private static final EntityDataAccessor<Boolean> DATA_IS_PLAYING_RISE_ANIM = SynchedEntityData.defineId(GaolerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    RawAnimation animationToPlay = null;
    private final AnimationController<GaolerEntity> animationController = new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate);

    public GaolerEntity(EntityType<? extends AbstractSpellCastingMob> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 0;
        this.lookControl = this.createLookControl();
        this.moveControl = this.createMoveControl();
    }

    public GaolerEntity(Level level, LivingEntity owner, boolean playAnimation) {
        this((EntityType<? extends AbstractSpellCastingMob>)((EntityType)DTEEntityRegistry.GAOLER_ENTITY.get()), level);
        this.setSummoner(owner);
        if (playAnimation) {
            this.triggerRiseAnimation();
        }
    }

    protected LookControl createLookControl() {
        return new LookControl((Mob)this){

            protected float rotateTowards(float from, float to, float maxDelta) {
                return super.rotateTowards(from, to, maxDelta * 2.5f);
            }

            protected boolean resetXRotOnTick() {
                return GaolerEntity.this.getTarget() == null;
            }
        };
    }

    protected MoveControl createMoveControl() {
        return new MoveControl(this, (Mob)this){

            protected float rotlerp(float sourceAngle, float targetAngle, float maximumChange) {
                double z;
                double x = this.wantedX - this.mob.getX();
                if (x * x + (z = this.wantedZ - this.mob.getZ()) * z < 0.5) {
                    return sourceAngle;
                }
                return super.rotlerp(sourceAngle, targetAngle, maximumChange * 0.25f);
            }
        };
    }

    public void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new GaolerAnimatedWarlockAttackGoal(this, 1.0, 35, 45, 5.0f).setMoveset(List.of(new AttackAnimationData(20, "slam_1", new int[]{16}), new AttackAnimationData(30, "upper_cut", new int[]{0, 5, 15, 20, 30}))).setComboChance(0.8f).setMeleeAttackInverval(10, 25).setMeleeMovespeedModifier(1.5f));
        this.goalSelector.addGoal(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, this::getSummoner, (double)0.9f, 10.0f, 2.0f, false, 50.0f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new GenericOwnerHurtByTargetGoal((Mob)this, this::getSummoner));
        this.targetSelector.addGoal(2, (Goal)new GenericOwnerHurtTargetGoal((Mob)this, this::getSummoner));
        this.targetSelector.addGoal(3, (Goal)new GenericCopyOwnerTargetGoal((PathfinderMob)this, this::getSummoner));
        this.targetSelector.addGoal(4, (Goal)new GenericHurtByTargetGoal((PathfinderMob)this, entity -> entity == this.getSummoner()).setAlertOthers(new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 10.5).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.MAX_HEALTH, 350.0).add(Attributes.FOLLOW_RANGE, 45.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public LivingEntity getSummoner() {
        return OwnerHelper.getAndCacheOwner((Level)this.level(), (LivingEntity)this.cachedSummoner, (UUID)this.summonerUUID);
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.getUUID();
            this.cachedSummoner = owner;
        }
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (entityIn == this) {
            return true;
        }
        if (entityIn == this.getSummoner()) {
            return true;
        }
        if (this.getSummoner() != null && !entityIn.isAlliedTo((Team)this.getSummoner().getTeam())) {
            return false;
        }
        return this.getTeam() == null && entityIn.getTeam() == null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.WARDEN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WARDEN_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.WARDEN_STEP, 10.0f, 1.0f);
    }

    public void die(DamageSource pDamageSource) {
        this.onDeathHelper();
        super.die(pDamageSource);
    }

    public void onRemovedFromLevel() {
        this.onRemovedHelper((Entity)this, DTEPotionEffectRegistry.GAOLER_TIMER);
        super.onRemovedFromLevel();
    }

    public void onUnSummon() {
        if (!this.level().isClientSide) {
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.SCULK_SOUL, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            this.discard();
        }
    }

    public boolean doHurtTarget(Entity entity) {
        return Utils.doMeleeAttack((Mob)this, (Entity)entity, (DamageSource)SpellRegistries.CONJURE_GAOLER.get().getDamageSource((Entity)this, (Entity)this.getSummoner()));
    }

    public boolean canDisableShield() {
        return true;
    }

    public boolean dampensVibrations() {
        return true;
    }

    private int getHeartBeatDelay() {
        return 40 - Mth.floor((float)(Mth.clamp((float)20.0f, (float)0.0f, (float)1.0f) * 30.0f));
    }

    public void applyDarknessAround(ServerLevel level, Vec3 pos, @Nullable Entity source, int radius) {
        MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.DARKNESS, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround((ServerLevel)level, (Entity)source, (Vec3)pos, (double)radius, (MobEffectInstance)mobeffectinstance, (int)200);
        List entitiesNearby = level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)radius));
        for (LivingEntity targets : entitiesNearby) {
            targets.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 200, 1, false, false, false));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(this.animationController);
    }

    private PlayState predicate(AnimationState<GaolerEntity> event) {
        AnimationController controller = event.getController();
        if (!this.isPlayingRiseAnimation()) {
            if (this.animationToPlay != null) {
                controller.forceAnimationReset();
                controller.setAnimation(this.animationToPlay);
                this.animationToPlay = null;
            } else if (event.isMoving() && this.animationToPlay == null) {
                event.getController().setAnimation(RawAnimation.begin().then("walking", Animation.LoopType.LOOP));
            } else if (!event.isMoving() && this.animationToPlay == null) {
                event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            }
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("spawn"));
        }
        return PlayState.CONTINUE;
    }

    public void playAnimation(String animationId) {
        try {
            this.animationToPlay = RawAnimation.begin().thenPlay(animationId);
        }
        catch (Exception ignored) {
            IronsSpellbooks.LOGGER.error("Entity {} Failed to play animation: {}", (Object)this, (Object)animationId);
        }
    }

    public boolean isAnimating() {
        return this.animationController.getAnimationState() != AnimationController.State.STOPPED || super.isAnimating();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    private void clientDiggingParticles(LivingEntity livingEntity) {
        RandomSource randomSource = this.getRandom();
        BlockState blockState = this.getBlockStateOn();
        if (blockState.getRenderShape() != RenderShape.INVISIBLE) {
            for (int i = 0; i < 30; ++i) {
                double x = livingEntity.getX() + (double)Mth.randomBetween((RandomSource)randomSource, (float)-0.7f, (float)0.7f);
                double y = livingEntity.getY();
                double z = livingEntity.getZ() + (double)Mth.randomBetween((RandomSource)randomSource, (float)-0.7f, (float)0.7f);
                livingEntity.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), x, y, z, 0.0, 0.0, 0.0);
                livingEntity.playSound(SoundEvents.WARDEN_DIG, 10.0f, this.getVoicePitch());
            }
        }
    }

    public boolean isPlayingRiseAnimation() {
        return (Boolean)this.entityData.get(DATA_IS_PLAYING_RISE_ANIM);
    }

    public void triggerRiseAnimation() {
        this.entityData.set(DATA_IS_PLAYING_RISE_ANIM, (Object)true);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        ServerLevel serverLevel = (ServerLevel)this.level();
        if (this.tickCount % 120 == 0) {
            this.applyDarknessAround(serverLevel, this.position(), (Entity)this, 25);
        }
    }

    public void tick() {
        if (this.isPlayingRiseAnimation()) {
            if (this.level().isClientSide) {
                this.clientDiggingParticles((LivingEntity)this);
            }
            if (--this.riseAnimationTime < 0) {
                this.entityData.set(DATA_IS_PLAYING_RISE_ANIM, (Object)false);
                this.setXRot(0.0f);
                this.setOldPosAndRot();
            }
        } else {
            super.tick();
        }
        if (this.level().isClientSide() && this.tickCount % this.getHeartBeatDelay() == 0 && !this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.WARDEN_HEARTBEAT, this.getSoundSource(), 5.0f, this.getVoicePitch(), false);
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.summonerUUID = OwnerHelper.deserializeOwner((CompoundTag)pCompound);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        OwnerHelper.serializeOwner((CompoundTag)pCompound, (UUID)this.summonerUUID);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_PLAYING_RISE_ANIM, (Object)false);
    }
}

