/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.blocks;

import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.world.otherside.OthersideDimension;
import com.kyanite.deeperdarker.world.otherside.OthersideTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;

public class OthersidePortalBlock
extends Block
implements Portal {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    protected static final VoxelShape X_AXIS_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public OthersidePortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue(AXIS) == Direction.Axis.X) {
            return X_AXIS_AABB;
        }
        return Z_AXIS_AABB;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Direction.Axis facingAxis = direction.getAxis();
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        boolean flag = axis != facingAxis && facingAxis.isHorizontal();
        return !flag && !neighborState.is((Block)this) && !new OthersidePortalShape(level, pos, axis).isComplete() ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if ((double)random.nextFloat() < 7.0E-4) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)DDSounds.PORTAL_GROAN.get(), SoundSource.BLOCKS, 0.2f, random.nextFloat() * 0.2f + 0.9f, false);
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity pEntity) {
        if (pEntity.canUsePortal(false)) {
            pEntity.setAsInsidePortal((Portal)this, pos);
        }
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return switch (direction) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Z: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ItemStack.EMPTY;
    }

    public boolean spawnPortal(LevelAccessor worldIn, BlockPos pos) {
        OthersidePortalShape portal = this.isPortal(worldIn, pos);
        if (portal != null && !OthersidePortalBlock.trySpawningPortal(worldIn, pos, portal)) {
            portal.createPortalBlocks();
            return true;
        }
        return false;
    }

    public static boolean trySpawningPortal(LevelAccessor world, BlockPos pos, OthersidePortalShape portal) {
        return ((PortalSpawnEvent)NeoForge.EVENT_BUS.post((Event)new PortalSpawnEvent(world, pos, world.getBlockState(pos), portal))).isCanceled();
    }

    public OthersidePortalShape isPortal(LevelAccessor level, BlockPos pos) {
        OthersidePortalShape portalX = new OthersidePortalShape(level, pos, Direction.Axis.X);
        if (portalX.isValid() && portalX.numPortalBlocks == 0) {
            return portalX;
        }
        OthersidePortalShape portalZ = new OthersidePortalShape(level, pos, Direction.Axis.Z);
        return portalZ.isValid() && portalZ.numPortalBlocks == 0 ? portalZ : null;
    }

    @Nullable
    public DimensionTransition getPortalDestination(ServerLevel level, Entity pEntity, BlockPos pos) {
        ResourceKey destLevel = level.dimension() == Level.OVERWORLD ? OthersideDimension.OTHERSIDE_LEVEL : Level.OVERWORLD;
        ServerLevel destServerLevel = level.getServer().getLevel(destLevel);
        if (destServerLevel == null) {
            return null;
        }
        WorldBorder destBorder = destServerLevel.getWorldBorder();
        double scale = DimensionType.getTeleportationScale((DimensionType)level.dimensionType(), (DimensionType)destServerLevel.dimensionType());
        BlockPos destPos = destBorder.clampToBounds(pEntity.getX() * scale, pEntity.getY(), pEntity.getZ() * scale);
        return OthersideTeleporter.getExitPortal(destServerLevel, pEntity, pos, destPos, destBorder);
    }

    public static class OthersidePortalShape {
        public static final int MIN_WIDTH = 2;
        public static final int MIN_HEIGHT = 2;
        public static final int MAX_WIDTH = 21;
        public static final int MAX_HEIGHT = 21;
        private final LevelAccessor level;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private BlockPos bottomLeft;
        private int numPortalBlocks;
        private int height;
        private final int width;

        public OthersidePortalShape(LevelAccessor level, BlockPos bottomLeft, Direction.Axis axis) {
            this.level = level;
            this.axis = axis;
            this.rightDir = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
            this.bottomLeft = this.calculateBottomLeft(bottomLeft);
            if (this.bottomLeft == null) {
                this.bottomLeft = bottomLeft;
                this.width = 1;
                this.height = 1;
            } else {
                this.width = this.calculateWidth();
                if (this.width > 0) {
                    this.height = this.calculateHeight();
                }
            }
        }

        private BlockPos calculateBottomLeft(BlockPos pos) {
            int height = Math.max(this.level.getMinBuildHeight(), pos.getY() - 21);
            while (pos.getY() > height && OthersidePortalShape.isEmpty(this.level.getBlockState(pos.below()))) {
                pos = pos.below();
            }
            Direction direction = this.rightDir.getOpposite();
            int j = this.getFrameWidth(pos, direction) - 1;
            return j < 0 ? null : pos.relative(direction, j);
        }

        private int calculateHeight() {
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            int i = this.getFrameHeight(blockPos);
            return i >= 2 && i <= 21 && this.hasTopFrame(blockPos, i) ? i : 0;
        }

        private int calculateWidth() {
            int i = this.getFrameWidth(this.bottomLeft, this.rightDir);
            return i >= 2 && i <= 21 ? i : 0;
        }

        private int getFrameHeight(BlockPos.MutableBlockPos pos) {
            for (int i = 0; i < 21; ++i) {
                pos.set((Vec3i)this.bottomLeft).move(Direction.UP, i).move(this.rightDir, -1);
                if (!this.level.getBlockState((BlockPos)pos).is(Blocks.REINFORCED_DEEPSLATE)) {
                    return i;
                }
                pos.set((Vec3i)this.bottomLeft).move(Direction.UP, i).move(this.rightDir, this.width);
                if (!this.level.getBlockState((BlockPos)pos).is(Blocks.REINFORCED_DEEPSLATE)) {
                    return i;
                }
                for (int j = 0; j < this.width; ++j) {
                    pos.set((Vec3i)this.bottomLeft).move(Direction.UP, i).move(this.rightDir, j);
                    BlockState blockState = this.level.getBlockState((BlockPos)pos);
                    if (!OthersidePortalShape.isEmpty(blockState)) {
                        return i;
                    }
                    if (!blockState.is((Block)DDBlocks.OTHERSIDE_PORTAL.get())) continue;
                    ++this.numPortalBlocks;
                }
            }
            return 21;
        }

        private int getFrameWidth(BlockPos pos, Direction direction) {
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (int i = 0; i <= 21; ++i) {
                blockPos.set((Vec3i)pos).move(direction, i);
                BlockState blockState = this.level.getBlockState((BlockPos)blockPos);
                if (!OthersidePortalShape.isEmpty(blockState)) {
                    if (!blockState.is(Blocks.REINFORCED_DEEPSLATE)) break;
                    return i;
                }
                BlockState blockStateDown = this.level.getBlockState((BlockPos)blockPos.move(Direction.DOWN));
                if (!blockStateDown.is(Blocks.REINFORCED_DEEPSLATE)) break;
            }
            return 0;
        }

        private boolean hasTopFrame(BlockPos.MutableBlockPos pos, int n) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos.MutableBlockPos blockPos = pos.set((Vec3i)this.bottomLeft).move(Direction.UP, n).move(this.rightDir, i);
                if (this.level.getBlockState((BlockPos)blockPos).is(Blocks.REINFORCED_DEEPSLATE)) continue;
                return false;
            }
            return true;
        }

        public void createPortalBlocks() {
            BlockState blockstate = (BlockState)((OthersidePortalBlock)((Object)DDBlocks.OTHERSIDE_PORTAL.get())).defaultBlockState().setValue(AXIS, (Comparable)this.axis);
            BlockPos.betweenClosed((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.relative(Direction.UP, this.height - 1).relative(this.rightDir, this.width - 1)).forEach(blockPos -> this.level.setBlock(blockPos, blockstate, 18));
        }

        public boolean isComplete() {
            return this.isValid() && this.numPortalBlocks == this.width * this.height;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 2 && this.height <= 21;
        }

        private static boolean isEmpty(BlockState state) {
            return state.isAir() || state.is((Block)DDBlocks.OTHERSIDE_PORTAL.get());
        }
    }

    public static class PortalSpawnEvent
    extends BlockEvent
    implements ICancellableEvent {
        private final OthersidePortalShape size;

        public PortalSpawnEvent(LevelAccessor level, BlockPos pos, BlockState state, OthersidePortalShape size) {
            super(level, pos, state);
            this.size = size;
        }

        public OthersidePortalShape getSize() {
            return this.size;
        }
    }
}

