/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.client.model;

import com.kyanite.deeperdarker.content.entities.SculkSnapper;
import com.kyanite.deeperdarker.content.entities.animations.SculkSnapperAnimation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SculkSnapperModel
extends HierarchicalModel<SculkSnapper> {
    private final ModelPart root;
    private final ModelPart head;

    public SculkSnapperModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("root").getChild("body").getChild("head");
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition root = parts.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.75f, (float)-1.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 39).addBox(-3.0f, -1.5f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.5f, (float)1.5f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 13).addBox(-4.5f, -3.0f, -6.0f, 9.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(28, 3).addBox(-4.0f, -5.0f, -5.75f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(28, -5).addBox(4.25f, -5.0f, -5.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(28, -5).addBox(-4.25f, -5.0f, -5.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.5f, (float)-0.5f));
        head.addOrReplaceChild("tongue", CubeListBuilder.create().texOffs(-8, 13).addBox(-1.5f, 0.0f, -8.0f, 3.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.36f, (float)3.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -3.0f, -9.0f, 9.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 26).addBox(-4.5f, -3.0f, -9.0f, 9.0f, 3.0f, 10.0f, new CubeDeformation(0.3f)).texOffs(28, -8).addBox(4.0f, 0.0f, -8.5f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(28, 0).addBox(-4.0f, 0.0f, -8.5f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(28, -8).addBox(-4.0f, 0.0f, -8.5f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)3.0f));
        jaw.addOrReplaceChild("tendril", CubeListBuilder.create().texOffs(33, 37).addBox(0.0f, -6.0f, -3.0f, 0.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition legs = root.addOrReplaceChild("legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        legs.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-1.8f, -0.35f, -0.74f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.75f, (float)-3.4f, (float)-2.75f));
        legs.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-0.2f, -0.35f, -0.74f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.75f, (float)-3.4f, (float)-2.75f));
        legs.addOrReplaceChild("left_back_leg", CubeListBuilder.create().texOffs(0, 0).addBox(3.7f, -0.35f, -1.26f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.75f, (float)-3.4f, (float)1.75f));
        legs.addOrReplaceChild("right_back_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-5.7f, -0.35f, -1.26f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.75f, (float)-3.4f, (float)1.75f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)48, (int)48);
    }

    public void setupAnim(SculkSnapper entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(SculkSnapperAnimation.WALK, limbSwing, limbSwingAmount, 2.5f, 2.5f);
        this.animate(entity.idleState, SculkSnapperAnimation.IDLE, ageInTicks);
        this.animate(entity.attackState, SculkSnapperAnimation.BITE, ageInTicks);
        this.animate(entity.sitState, SculkSnapperAnimation.SIT, ageInTicks);
    }

    private void applyHeadRotation(float netHeadYaw, float headPitch) {
        netHeadYaw = Mth.clamp((float)netHeadYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.root.getChild("root").render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.root;
    }
}

