/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tracking;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.event.PlayerRingOfFire;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;

public class ImportantUsers {
    private static final String SOURCE = "https://raw.githubusercontent.com/CyclopsMC/Versions/master/data/users.txt";
    private static volatile boolean checked = false;

    public static void checkAll() {
        if (!checked) {
            checked = true;
            new Thread(() -> {
                HashSet uuids = Sets.newHashSet();
                try {
                    String[] lines;
                    URL url = new URL(SOURCE);
                    String data = IOUtils.toString((URL)url, (Charset)Charset.forName("UTF-8"));
                    for (String line : lines = data.split("\\r?\\n")) {
                        String[] segments = line.split(",");
                        if (segments.length < 1) continue;
                        try {
                            uuids.add(UUID.fromString(segments[0]));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException e) {
                    CyclopsCoreInstance.MOD.log(Level.WARN, "Could not get version important users: " + e.toString());
                }
                PlayerRingOfFire.ALLOW_RING.addAll(uuids);
            }).start();
        }
    }
}

