/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.cyclops.cyclopscore.config.ConfigurableTypeCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigRegistry;
import org.cyclops.cyclopscore.config.extendedconfig.IModelProviderConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemClientConfig;
import org.cyclops.cyclopscore.init.IModBase;

public class ItemConfigCommon<M extends IModBase>
extends ExtendedConfigRegistry<ItemConfigCommon<M>, Item, M>
implements IModelProviderConfig {
    public ItemConfigCommon(M mod, String namedId, Function<ItemConfigCommon<M>, ? extends Item> elementConstructor) {
        super(mod, namedId, elementConstructor);
    }

    @Override
    public String getModelName(ItemStack itemStack) {
        return this.getNamedId();
    }

    @Override
    public String getTranslationKey() {
        return "item." + this.getMod().getModId() + "." + this.getNamedId();
    }

    @Override
    public String getFullTranslationKey() {
        return this.getTranslationKey();
    }

    @Override
    public ConfigurableTypeCommon getConfigurableType() {
        return ConfigurableTypeCommon.ITEM;
    }

    public Collection<ItemStack> getDefaultCreativeTabEntriesPublic() {
        return this.getDefaultCreativeTabEntries();
    }

    protected Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Collections.singleton(new ItemStack((ItemLike)this.getInstance()));
    }

    @Override
    public Registry<? super Item> getRegistry() {
        return BuiltInRegistries.ITEM;
    }

    @Nullable
    public ItemClientConfig<M> getItemClientConfig() {
        if (this.getMod().getModHelpers().getMinecraftHelpers().isClientSide()) {
            return new ItemClientConfig(this);
        }
        return null;
    }
}

