/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.cyclops.cyclopscore.command.argument.ArgumentTypeConfigProperty;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.init.IModBase;

public class CommandConfig
implements Command<CommandSourceStack> {
    private final IModBase mod;
    private final boolean valueSet;

    public CommandConfig(IModBase mod, boolean valueSet) {
        this.mod = mod;
        this.valueSet = valueSet;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ConfigurablePropertyData property = (ConfigurablePropertyData)context.getArgument("property", ConfigurablePropertyData.class);
        if (!this.valueSet) {
            ((CommandSourceStack)context.getSource()).getPlayerOrException().sendSystemMessage((Component)Component.literal((String)property.getConfigProperty().get().toString()));
        } else {
            String value = (String)context.getArgument("value", String.class);
            Object newValue = this.mod.getModHelpers().getBaseHelpers().tryParse(value, property.getConfigProperty().get());
            if (newValue != null) {
                property.getConfigPropertyUpdater().accept(newValue);
                ((CommandSourceStack)context.getSource()).getPlayerOrException().sendSystemMessage((Component)Component.translatable((String)"chat.cyclopscore.command.updatedValue", (Object[])new Object[]{property.getName(), newValue.toString()}));
            } else {
                ((CommandSourceStack)context.getSource()).getPlayerOrException().sendSystemMessage((Component)Component.translatable((String)"chat.cyclopscore.command.invalidNewValue"));
                return 1;
            }
        }
        return 0;
    }

    public static LiteralArgumentBuilder<CommandSourceStack> make(IModBase mod) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"config").requires(commandSource -> commandSource.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"property", (ArgumentType)new ArgumentTypeConfigProperty(mod)).executes((Command)new CommandConfig(mod, false))).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.string()).executes((Command)new CommandConfig(mod, true))));
    }
}

