/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.capability;

import com.google.common.cache.Cache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import top.theillusivec4.curios.Curios;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.capability.CurioInventory;

public class CurioInventoryCapability
implements ICuriosItemHandler {
    final CurioInventory curioInventory;
    final LivingEntity livingEntity;

    public CurioInventoryCapability(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
        this.curioInventory = (CurioInventory)livingEntity.getData(CuriosRegistry.INVENTORY.get());
        if (this.curioInventory.markDeserialized) {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.curioInventory.init(this);
    }

    @Override
    public int getSlots() {
        int totalSlots = 0;
        for (ICurioStacksHandler stacks : this.curioInventory.asMap().values()) {
            totalSlots += stacks.getSlots();
        }
        return totalSlots;
    }

    @Override
    public int getVisibleSlots() {
        int totalSlots = 0;
        for (ICurioStacksHandler stacks : this.curioInventory.asMap().values()) {
            if (!stacks.isVisible()) continue;
            totalSlots += stacks.getSlots();
        }
        return totalSlots;
    }

    @Override
    public Optional<ICurioStacksHandler> getStacksHandler(String identifier) {
        return Optional.ofNullable(this.curioInventory.asMap().get(identifier));
    }

    @Override
    public IItemHandlerModifiable getEquippedCurios() {
        Map<String, ICurioStacksHandler> curios = this.getCurios();
        IItemHandlerModifiable[] itemHandlers = new IItemHandlerModifiable[curios.size()];
        int index = 0;
        for (ICurioStacksHandler stacksHandler : curios.values()) {
            if (index >= itemHandlers.length) continue;
            itemHandlers[index] = stacksHandler.getStacks();
            ++index;
        }
        return new CombinedInvWrapper(itemHandlers);
    }

    @Override
    public void setEquippedCurio(String identifier, int index, ItemStack stack) {
        IDynamicStackHandler stackHandler;
        Map<String, ICurioStacksHandler> curios = this.getCurios();
        ICurioStacksHandler stacksHandler = curios.get(identifier);
        if (stacksHandler != null && index < (stackHandler = stacksHandler.getStacks()).getSlots()) {
            stackHandler.setStackInSlot(index, stack);
        }
    }

    @Override
    public Optional<SlotResult> findFirstCurio(Item item) {
        return this.findFirstCurio(stack -> stack.getItem() == item, Curios.itemCacheKey(item.getDefaultInstance()));
    }

    @Override
    public Optional<SlotResult> findFirstCurio(Predicate<ItemStack> filter) {
        return this.findFirstCurio(filter, "");
    }

    @Override
    public Optional<SlotResult> findFirstCurio(Predicate<ItemStack> filter, String cacheKey) {
        return this.findFirstCurio(filter, false, cacheKey);
    }

    @Override
    public Optional<SlotResult> findFirstCurio(Predicate<ItemStack> filter, boolean includeInactive, String cacheKey) {
        Pair cached;
        long gameTime = this.livingEntity.level().getGameTime();
        Cache<String, Pair<Long, Optional<SlotResult>>> cache = this.curioInventory.firstCurioCache;
        if (!cacheKey.isEmpty() && (cached = (Pair)cache.getIfPresent((Object)cacheKey)) != null && (Long)cached.getFirst() == gameTime) {
            return (Optional)cached.getSecond();
        }
        Map<String, ICurioStacksHandler> curios = this.getCurios();
        for (String id : curios.keySet()) {
            ICurioStacksHandler stacksHandler = curios.get(id);
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            NonNullList<Boolean> activeStates = stacksHandler.getActiveStates();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack stack;
                if (!includeInactive && activeStates.size() > i && !((Boolean)activeStates.get(i)).booleanValue() || (stack = stackHandler.getStackInSlot(i)).isEmpty() || !filter.test(stack)) continue;
                NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                Optional<SlotResult> ret = Optional.of(new SlotResult(new SlotContext(id, this.livingEntity, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false), stack));
                cache.put((Object)cacheKey, (Object)Pair.of((Object)gameTime, ret));
                return ret;
            }
        }
        cache.put((Object)cacheKey, (Object)Pair.of((Object)gameTime, Optional.empty()));
        return Optional.empty();
    }

    @Override
    public List<SlotResult> findCurios(Item item) {
        return this.findCurios((ItemStack stack) -> stack.getItem() == item, false, Curios.itemCacheKey(item.getDefaultInstance()));
    }

    @Override
    public List<SlotResult> findCurios(Predicate<ItemStack> filter) {
        return this.findCurios(filter, false, "");
    }

    @Override
    public List<SlotResult> findCurios(Predicate<ItemStack> filter, boolean includeInactive, String cacheKey) {
        Pair cached;
        long gameTime = this.livingEntity.level().getGameTime();
        Cache<String, Pair<Long, List<SlotResult>>> cache = this.curioInventory.findCuriosCache;
        if (!cacheKey.isEmpty() && (cached = (Pair)cache.getIfPresent((Object)cacheKey)) != null && (Long)cached.getFirst() == gameTime) {
            return (List)cached.getSecond();
        }
        ArrayList<SlotResult> result = new ArrayList<SlotResult>();
        Map<String, ICurioStacksHandler> curios = this.getCurios();
        for (String id : curios.keySet()) {
            ICurioStacksHandler stacksHandler = curios.get(id);
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            NonNullList<Boolean> activeStates = stacksHandler.getActiveStates();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack stack;
                if (!includeInactive && activeStates.size() > i && !((Boolean)activeStates.get(i)).booleanValue() || (stack = stackHandler.getStackInSlot(i)).isEmpty() || !filter.test(stack)) continue;
                NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                result.add(new SlotResult(new SlotContext(id, this.livingEntity, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false), stack));
            }
        }
        cache.put((Object)cacheKey, (Object)Pair.of((Object)gameTime, result));
        return result;
    }

    @Override
    public List<SlotResult> findCurios(String ... identifiers) {
        return this.findCurios(false, identifiers);
    }

    @Override
    public List<SlotResult> findCurios(boolean includeInactive, String ... identifiers) {
        ArrayList<SlotResult> result = new ArrayList<SlotResult>();
        HashSet<String> ids = new HashSet<String>(List.of(identifiers));
        Map<String, ICurioStacksHandler> curios = this.getCurios();
        for (String id : curios.keySet()) {
            if (!ids.contains(id)) continue;
            ICurioStacksHandler stacksHandler = curios.get(id);
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            NonNullList<Boolean> activeStates = stacksHandler.getActiveStates();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack stack;
                if (!includeInactive && activeStates.size() > i && !((Boolean)activeStates.get(i)).booleanValue() || (stack = stackHandler.getStackInSlot(i)).isEmpty()) continue;
                NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                result.add(new SlotResult(new SlotContext(id, this.livingEntity, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false), stack));
            }
        }
        return result;
    }

    @Override
    public Optional<SlotResult> findCurio(String identifier, int index) {
        return this.findCurio(identifier, index, false);
    }

    @Override
    public Optional<SlotResult> findCurio(String identifier, int index, boolean includeInactive) {
        Map<String, ICurioStacksHandler> curios = this.getCurios();
        ICurioStacksHandler stacksHandler = curios.get(identifier);
        if (stacksHandler != null) {
            IDynamicStackHandler stackHandler = stacksHandler.getStacks();
            NonNullList<Boolean> activeStates = stacksHandler.getActiveStates();
            if (index < stackHandler.getSlots()) {
                if (!includeInactive && activeStates.size() > index && !((Boolean)activeStates.get(index)).booleanValue()) {
                    return Optional.empty();
                }
                ItemStack stack = stackHandler.getStackInSlot(index);
                if (!stack.isEmpty()) {
                    NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                    return Optional.of(new SlotResult(new SlotContext(identifier, this.livingEntity, index, false, renderStates.size() > index && (Boolean)renderStates.get(index) != false), stack));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public Map<String, ICurioStacksHandler> getCurios() {
        return Collections.unmodifiableMap(this.curioInventory.asMap());
    }

    @Override
    public void setCurios(Map<String, ICurioStacksHandler> curios) {
        this.curioInventory.replace(curios);
    }

    @Override
    public void growSlotType(String identifier, int amount) {
        if (amount > 0) {
            this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.grow(amount));
        }
    }

    @Override
    public void shrinkSlotType(String identifier, int amount) {
        if (amount > 0) {
            this.getStacksHandler(identifier).ifPresent(stackHandler -> stackHandler.shrink(amount));
        }
    }

    @Override
    @Nullable
    public LivingEntity getWearer() {
        return this.livingEntity;
    }

    @Override
    public void loseInvalidStack(ItemStack stack) {
        this.curioInventory.invalidStacks.add((Object)stack);
    }

    @Override
    public void handleInvalidStacks() {
        if (this.livingEntity != null && !this.curioInventory.invalidStacks.isEmpty()) {
            LivingEntity livingEntity = this.livingEntity;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.curioInventory.invalidStacks.forEach(drop -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop));
            } else {
                this.curioInventory.invalidStacks.forEach(drop -> {
                    ItemEntity ent = this.livingEntity.spawnAtLocation(drop, 1.0f);
                    RandomSource rand = this.livingEntity.getRandom();
                    if (ent != null) {
                        ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                    }
                });
            }
            this.curioInventory.invalidStacks = NonNullList.create();
        }
    }

    @Override
    public int getFortuneLevel(@Nullable LootContext lootContext) {
        int fortuneLevel = 0;
        for (Map.Entry<String, ICurioStacksHandler> entry : this.getCurios().entrySet()) {
            IDynamicStackHandler stacks = entry.getValue().getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                int index = i;
                fortuneLevel += CuriosApi.getCurio(stacks.getStackInSlot(i)).map(curio -> {
                    NonNullList<Boolean> renderStates = ((ICurioStacksHandler)entry.getValue()).getRenders();
                    return curio.getFortuneLevel(new SlotContext((String)entry.getKey(), this.livingEntity, index, false, renderStates.size() > index && (Boolean)renderStates.get(index) != false), lootContext);
                }).orElse(0).intValue();
            }
        }
        return fortuneLevel;
    }

    @Override
    public int getLootingLevel(@Nullable LootContext lootContext) {
        int lootingLevel = 0;
        for (Map.Entry<String, ICurioStacksHandler> entry : this.getCurios().entrySet()) {
            IDynamicStackHandler stacks = entry.getValue().getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                int index = i;
                lootingLevel += CuriosApi.getCurio(stacks.getStackInSlot(i)).map(curio -> {
                    NonNullList<Boolean> renderStates = ((ICurioStacksHandler)entry.getValue()).getRenders();
                    return curio.getLootingLevel(new SlotContext((String)entry.getKey(), this.livingEntity, index, false, renderStates.size() > index && (Boolean)renderStates.get(index) != false), lootContext);
                }).orElse(0).intValue();
            }
        }
        return lootingLevel;
    }

    @Override
    public ListTag saveInventory(boolean clear) {
        ListTag taglist = new ListTag();
        for (Map.Entry<String, ICurioStacksHandler> entry : this.curioInventory.asMap().entrySet()) {
            int i;
            CompoundTag tag = new CompoundTag();
            ICurioStacksHandler stacksHandler = entry.getValue();
            IDynamicStackHandler stacks = stacksHandler.getStacks();
            IDynamicStackHandler cosmetics = stacksHandler.getCosmeticStacks();
            tag.put("Stacks", (Tag)stacks.serializeNBT((HolderLookup.Provider)this.livingEntity.level().registryAccess()));
            tag.put("Cosmetics", (Tag)cosmetics.serializeNBT((HolderLookup.Provider)this.livingEntity.level().registryAccess()));
            tag.putString("Identifier", entry.getKey());
            taglist.add((Object)tag);
            if (!clear) continue;
            for (i = 0; i < stacks.getSlots(); ++i) {
                stacks.setStackInSlot(i, ItemStack.EMPTY);
            }
            for (i = 0; i < cosmetics.getSlots(); ++i) {
                cosmetics.setStackInSlot(i, ItemStack.EMPTY);
            }
        }
        return taglist;
    }

    @Override
    public void loadInventory(ListTag data) {
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                CompoundTag tag = data.getCompound(i);
                String identifier = tag.getString("Identifier");
                ICurioStacksHandler stacksHandler = this.curioInventory.asMap().get(identifier);
                if (stacksHandler == null) continue;
                CompoundTag stacksData = tag.getCompound("Stacks");
                ItemStackHandler loaded = new ItemStackHandler();
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                if (!stacksData.isEmpty()) {
                    loaded.deserializeNBT((HolderLookup.Provider)this.livingEntity.level().registryAccess(), stacksData);
                    this.loadStacks(stacksHandler, loaded, stacks);
                }
                if ((stacksData = tag.getCompound("Cosmetics")).isEmpty()) continue;
                loaded.deserializeNBT((HolderLookup.Provider)this.livingEntity.level().registryAccess(), stacksData);
                stacks = stacksHandler.getCosmeticStacks();
                this.loadStacks(stacksHandler, loaded, stacks);
            }
        }
    }

    @Override
    public Set<ICurioStacksHandler> getUpdatingInventories() {
        return this.curioInventory.updates;
    }

    @Override
    public void addTransientSlotModifier(String slot, ResourceLocation id, double amount, AttributeModifier.Operation operation) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        map.put((Object)slot, (Object)new AttributeModifier(id, amount, operation));
        this.addTransientSlotModifiers((Multimap<String, AttributeModifier>)map);
    }

    @Override
    public void addTransientSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String id = (String)entry.getKey();
            for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                ICurioStacksHandler stacksHandler = this.curioInventory.asMap().get(id);
                if (stacksHandler == null) continue;
                stacksHandler.addTransientModifier(attributeModifier);
            }
        }
    }

    @Override
    public void addPermanentSlotModifier(String slot, ResourceLocation id, double amount, AttributeModifier.Operation operation) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        map.put((Object)slot, (Object)new AttributeModifier(id, amount, operation));
        this.addPermanentSlotModifiers((Multimap<String, AttributeModifier>)map);
    }

    @Override
    public void addPermanentSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String id = (String)entry.getKey();
            for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                ICurioStacksHandler stacksHandler = this.curioInventory.asMap().get(id);
                if (stacksHandler == null) continue;
                stacksHandler.addPermanentModifier(attributeModifier);
            }
        }
    }

    @Override
    public void removeSlotModifier(String slot, ResourceLocation id) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        map.put((Object)slot, (Object)new AttributeModifier(id, 0.0, AttributeModifier.Operation.ADD_VALUE));
        this.removeSlotModifiers((Multimap<String, AttributeModifier>)map);
    }

    @Override
    public void removeSlotModifiers(Multimap<String, AttributeModifier> modifiers) {
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            String id = (String)entry.getKey();
            for (AttributeModifier attributeModifier : (Collection)entry.getValue()) {
                ICurioStacksHandler stacksHandler = this.curioInventory.asMap().get(id);
                if (stacksHandler == null) continue;
                stacksHandler.removeModifier(attributeModifier.id());
            }
        }
    }

    @Override
    public void clearSlotModifiers() {
        for (Map.Entry<String, ICurioStacksHandler> entry : this.curioInventory.asMap().entrySet()) {
            entry.getValue().clearModifiers();
        }
    }

    @Override
    public void clearCachedSlotModifiers() {
        ICurioStacksHandler stacksHandler;
        HashMultimap slots = HashMultimap.create();
        boolean flag = false;
        Map<String, ICurioStacksHandler> inv = this.curioInventory.asMap();
        for (Map.Entry<String, ICurioStacksHandler> entry : inv.entrySet()) {
            stacksHandler = entry.getValue();
            Set<AttributeModifier> modifiers = stacksHandler.getCachedModifiers();
            if (modifiers.isEmpty()) continue;
            flag = true;
            break;
        }
        if (flag) {
            for (Map.Entry<String, ICurioStacksHandler> entry : inv.entrySet()) {
                stacksHandler = entry.getValue();
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                String id = entry.getKey();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    ItemStack stack = stacks.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    SlotContext slotContext = new SlotContext(id, this.getWearer(), i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false);
                    Multimap<Holder<Attribute>, AttributeModifier> map = CuriosApi.getAttributeModifiers(slotContext, CuriosApi.getSlotId(slotContext), stack);
                    for (Holder attribute : map.keySet()) {
                        Object object = attribute.value();
                        if (!(object instanceof SlotAttribute)) continue;
                        SlotAttribute wrapper = (SlotAttribute)((Object)object);
                        slots.putAll((Object)wrapper.getIdentifier(), (Iterable)map.get((Object)attribute));
                    }
                }
            }
        }
        for (Map.Entry<String, ICurioStacksHandler> entry : slots.asMap().entrySet()) {
            String id = entry.getKey();
            ICurioStacksHandler stacksHandler2 = this.curioInventory.asMap().get(id);
            if (stacksHandler2 == null) continue;
            for (AttributeModifier attributeModifier : (Collection)((Object)entry.getValue())) {
                stacksHandler2.getCachedModifiers().remove(attributeModifier);
            }
            stacksHandler2.clearCachedModifiers();
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getModifiers() {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry<String, ICurioStacksHandler> entry : this.curioInventory.asMap().entrySet()) {
            result.putAll((Object)entry.getKey(), entry.getValue().getModifiers().values());
        }
        return result;
    }

    private void loadStacks(ICurioStacksHandler stacksHandler, ItemStackHandler loaded, IDynamicStackHandler stacks) {
        for (int j = 0; j < stacksHandler.getSlots() && j < loaded.getSlots(); ++j) {
            ItemStack stack = stacks.getStackInSlot(j);
            ItemStack loadedStack = loaded.getStackInSlot(j);
            if (stack.isEmpty()) {
                stacks.setStackInSlot(j, loadedStack);
                continue;
            }
            this.loseInvalidStack(stack);
        }
    }

    @Override
    public Tag writeTag() {
        return this.curioInventory.serializeNBT((HolderLookup.Provider)this.livingEntity.level().registryAccess());
    }

    @Override
    public void readTag(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)nbt;
            this.curioInventory.deserializeNBT((HolderLookup.Provider)this.livingEntity.level().registryAccess(), tag);
        }
    }
}

