/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.capability;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.CurioStacksHandler;

public class CurioInventory
implements INBTSerializable<CompoundTag> {
    final Map<String, ICurioStacksHandler> curios = new LinkedHashMap<String, ICurioStacksHandler>();
    ICuriosItemHandler curiosItemHandler;
    NonNullList<ItemStack> invalidStacks = NonNullList.create();
    Set<ICurioStacksHandler> updates = new HashSet<ICurioStacksHandler>();
    CompoundTag deserialized = new CompoundTag();
    boolean markDeserialized = false;
    final Cache<String, Pair<Long, Optional<SlotResult>>> firstCurioCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.SECONDS).build();
    final Cache<String, Pair<Long, List<SlotResult>>> findCuriosCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.SECONDS).build();

    public void init(ICuriosItemHandler curiosItemHandler) {
        this.curiosItemHandler = curiosItemHandler;
        this.curios.clear();
        LivingEntity livingEntity = curiosItemHandler.getWearer();
        if (!this.markDeserialized) {
            TreeSet<ISlotType> sorted = new TreeSet<ISlotType>(CuriosApi.getEntitySlots(livingEntity).values());
            for (ISlotType slotType2 : sorted) {
                this.curios.put(slotType2.getIdentifier(), new CurioStacksHandler(curiosItemHandler, slotType2.getIdentifier(), slotType2.getSize(), slotType2.useNativeGui(), slotType2.hasCosmetic(), slotType2.canToggleRendering(), slotType2.getDropRule()));
            }
        } else {
            this.markDeserialized = false;
            ListTag tagList = this.deserialized.getList("Curios", 10);
            LinkedHashMap curios = new LinkedHashMap();
            TreeMap<ISlotType, ICurioStacksHandler> sortedCurios = new TreeMap<ISlotType, ICurioStacksHandler>();
            TreeSet<ISlotType> sorted = new TreeSet<ISlotType>(CuriosApi.getEntitySlots(livingEntity).values());
            for (ISlotType slotType3 : sorted) {
                sortedCurios.put(slotType3, new CurioStacksHandler(curiosItemHandler, slotType3.getIdentifier(), slotType3.getSize(), slotType3.useNativeGui(), slotType3.hasCosmetic(), slotType3.canToggleRendering(), slotType3.getDropRule()));
            }
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag tag = tagList.getCompound(i);
                String identifier = tag.getString("Identifier");
                CurioStacksHandler prevStacksHandler = new CurioStacksHandler(curiosItemHandler, identifier);
                prevStacksHandler.deserializeNBT(tag.getCompound("StacksHandler"));
                Optional<ISlotType> optionalType = Optional.ofNullable(CuriosApi.getEntitySlots(livingEntity).get(identifier));
                optionalType.ifPresent(slotType -> {
                    int j;
                    int index;
                    CurioStacksHandler newStacksHandler = new CurioStacksHandler(curiosItemHandler, slotType.getIdentifier(), slotType.getSize(), slotType.useNativeGui(), slotType.hasCosmetic(), slotType.canToggleRendering(), slotType.getDropRule());
                    newStacksHandler.copyModifiers(prevStacksHandler);
                    for (index = 0; index < newStacksHandler.getSlots() && index < prevStacksHandler.getSlots(); ++index) {
                        ItemStack prevCosmetic;
                        ItemStack prevStack = prevStacksHandler.getStacks().getStackInSlot(index);
                        if (!prevStack.isEmpty()) {
                            if (newStacksHandler.getStacks().isItemValid(index, prevStack)) {
                                newStacksHandler.getStacks().setStackInSlot(index, prevStack);
                            } else {
                                this.curiosItemHandler.loseInvalidStack(prevStack);
                            }
                        }
                        if ((prevCosmetic = prevStacksHandler.getCosmeticStacks().getStackInSlot(index)).isEmpty()) continue;
                        if (newStacksHandler.getStacks().isItemValid(index, prevCosmetic)) {
                            newStacksHandler.getCosmeticStacks().setStackInSlot(index, prevStacksHandler.getCosmeticStacks().getStackInSlot(index));
                            continue;
                        }
                        this.curiosItemHandler.loseInvalidStack(prevCosmetic);
                    }
                    while (index < prevStacksHandler.getSlots()) {
                        this.curiosItemHandler.loseInvalidStack(prevStacksHandler.getStacks().getStackInSlot(index));
                        this.curiosItemHandler.loseInvalidStack(prevStacksHandler.getCosmeticStacks().getStackInSlot(index));
                        ++index;
                    }
                    sortedCurios.put((ISlotType)slotType, newStacksHandler);
                    for (j = 0; j < newStacksHandler.getRenders().size() && j < prevStacksHandler.getRenders().size(); ++j) {
                        newStacksHandler.getRenders().set(j, (Object)((Boolean)prevStacksHandler.getRenders().get(j)));
                    }
                    for (j = 0; j < newStacksHandler.getActiveStates().size() && j < prevStacksHandler.getActiveStates().size(); ++j) {
                        newStacksHandler.getActiveStates().set(j, (Object)((Boolean)prevStacksHandler.getActiveStates().get(j)));
                    }
                });
                if (!optionalType.isEmpty()) continue;
                IDynamicStackHandler stackHandler = prevStacksHandler.getStacks();
                IDynamicStackHandler cosmeticStackHandler = prevStacksHandler.getCosmeticStacks();
                for (int j = 0; j < stackHandler.getSlots(); ++j) {
                    ItemStack cosmeticStack;
                    ItemStack stack = stackHandler.getStackInSlot(j);
                    if (!stack.isEmpty()) {
                        this.curiosItemHandler.loseInvalidStack(stack);
                    }
                    if ((cosmeticStack = cosmeticStackHandler.getStackInSlot(j)).isEmpty()) continue;
                    this.curiosItemHandler.loseInvalidStack(cosmeticStack);
                }
            }
            sortedCurios.forEach((slotType, stacksHandler) -> curios.put(slotType.getIdentifier(), stacksHandler));
            this.curios.putAll(curios);
            this.deserialized = new CompoundTag();
        }
    }

    public Map<String, ICurioStacksHandler> asMap() {
        return this.curios;
    }

    public void replace(Map<String, ICurioStacksHandler> curios) {
        this.curios.clear();
        this.curios.putAll(curios);
    }

    public CompoundTag serializeNBT(@Nonnull HolderLookup.Provider provider) {
        if (!this.deserialized.isEmpty()) {
            return this.deserialized;
        }
        CompoundTag compound = new CompoundTag();
        ListTag taglist = new ListTag();
        this.curios.forEach((key, stacksHandler) -> {
            CompoundTag tag = new CompoundTag();
            tag.put("StacksHandler", (Tag)stacksHandler.serializeNBT());
            tag.putString("Identifier", key);
            taglist.add((Object)tag);
        });
        compound.put("Curios", (Tag)taglist);
        return compound;
    }

    public void deserializeNBT(@Nonnull HolderLookup.Provider provider, @Nonnull CompoundTag nbt) {
        this.deserialized = nbt;
        this.markDeserialized = true;
    }
}

