/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.datagen.assets;

import com.satherov.crystalix.content.CrystalixRegistry;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.model.data.ConnectingModelDataBuilder;
import com.supermartijn642.fusion.api.predicate.DefaultConnectionPredicates;
import com.supermartijn642.fusion.api.provider.FusionModelProvider;
import java.nio.file.Path;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CrystalixFusionModelProvider
extends FusionModelProvider {
    public CrystalixFusionModelProvider(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super("crystalix", new PackOutput(Path.of(packOutput.getOutputFolder().toAbsolutePath().toString(), "crystalix-fusion-overrides")), existingFileHelper);
    }

    protected void generate() {
        CrystalixRegistry.BLOCKS_MAP.forEach((color, set) -> set.forEach((type, block) -> {
            this.shadedBlock((DeferredHolder<Block, ? extends Block>)block, (DyeColor)color, (CrystalixRegistry.BlockTypes)((Object)((Object)type)));
            this.shadelessBlock((DeferredHolder<Block, ? extends Block>)block, (DyeColor)color, (CrystalixRegistry.BlockTypes)((Object)((Object)type)));
        }));
    }

    private void shadedBlock(DeferredHolder<Block, ? extends Block> block, DyeColor color, CrystalixRegistry.BlockTypes type) {
        this.addModel(ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)("block/" + type.getSerializedName() + "/" + block.getId().getPath())), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelData.builder().parent(ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)"block/block"))).texture("all", ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)("block/" + type.getSerializedName() + "/" + color.getName())))).connection(DefaultConnectionPredicates.isSameBlock()).build())));
    }

    private void shadelessBlock(DeferredHolder<Block, ? extends Block> block, DyeColor color, CrystalixRegistry.BlockTypes type) {
        this.addModel(ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)("block/" + type.getSerializedName() + "/" + block.getId().getPath() + "_no_shade")), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelData.builder().parent(ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)"block/no_shade_block"))).texture("all", ResourceLocation.fromNamespaceAndPath((String)"crystalix", (String)("block/" + type.getSerializedName() + "/" + color.getName())))).connection(DefaultConnectionPredicates.isSameBlock()).build())));
    }
}

