/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content.item;

import com.satherov.crystalix.CrystalixConfig;
import com.satherov.crystalix.content.CrystalixRegistry;
import com.satherov.crystalix.content.block.CrystalixGlass;
import com.satherov.crystalix.content.properties.BlockProperties;
import com.satherov.crystalix.content.properties.IProperty;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CrystalixWand
extends Item {
    public CrystalixWand(Item.Properties properties, boolean shadeless, boolean reinforced, BlockProperties.Light light, BlockProperties.Ghost ghost) {
        super(properties.stacksTo(1).component(CrystalixRegistry.SHADELESS, (Object)shadeless).component(CrystalixRegistry.REINFORCED, (Object)reinforced).component(CrystalixRegistry.LIGHT, (Object)light).component(CrystalixRegistry.GHOST, (Object)ghost));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)String.format("%s.wand.bulk", "crystalix")).withStyle(ChatFormatting.GRAY));
        Arrays.stream(new BlockProperties((ItemStack)stack).properties).toList().forEach(property -> tooltipComponents.add(property.toComponent()));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player != null && !level.isClientSide && !this.applyToBlock((LevelAccessor)level, blockpos = context.getClickedPos(), player)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public boolean applyToBlock(LevelAccessor accessor, BlockPos pos, Player player) {
        if (!(accessor.getBlockState(pos).getBlock() instanceof CrystalixGlass)) {
            return false;
        }
        ItemStack wand = player.getMainHandItem();
        Set<BlockPos> blocksToModify = player.isCrouching() ? this.getConnectedBlocks(accessor, pos, accessor.getBlockState(pos).getBlock(), CrystalixConfig.max_wand_edit) : Set.of(pos);
        for (BlockPos targetPos : blocksToModify) {
            BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)accessor.getBlockState(targetPos).setValue((Property)CrystalixGlass.SHADELESS, (Comparable)Objects.requireNonNull((Boolean)wand.get(CrystalixRegistry.SHADELESS)))).setValue((Property)CrystalixGlass.REINFORCED, (Comparable)Objects.requireNonNull((Boolean)wand.get(CrystalixRegistry.REINFORCED)))).setValue(CrystalixGlass.LIGHT, (Comparable)((Object)Objects.requireNonNull((BlockProperties.Light)((Object)wand.get(CrystalixRegistry.LIGHT)))))).setValue(CrystalixGlass.GHOST, (Comparable)((Object)Objects.requireNonNull((BlockProperties.Ghost)((Object)wand.get(CrystalixRegistry.GHOST)))));
            accessor.setBlock(targetPos, newState, 3);
        }
        return true;
    }

    public Set<BlockPos> getConnectedBlocks(LevelAccessor accessor, BlockPos start, Block targetBlock, int maxBlocks) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty() && visited.size() < maxBlocks) {
            BlockPos pos = (BlockPos)queue.poll();
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = pos.relative(direction);
                if (visited.contains(neighborPos) || !accessor.getBlockState(neighborPos).is(targetBlock)) continue;
                queue.add(neighborPos);
                visited.add(neighborPos);
            }
        }
        return visited;
    }

    public static void sendMessage(Player player, IProperty<?> property) {
        player.displayClientMessage(property.toComponent(), true);
    }
}

