/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.client.gui.widgets.StationDeparturesWidget;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.util.EDepartureBoardTrainFilter;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLScrollableWidgetContainer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;

public class StationDeparturesViewer
extends DLScrollableWidgetContainer {
    private final Screen parent;
    private final DLAbstractScrollBar<?> scrollBar;
    private int contentHeight = 0;

    public StationDeparturesViewer(Screen parent, int x, int y, int width, int height, DLAbstractScrollBar<?> scrollBar) {
        super(x, y, width, height);
        this.parent = parent;
        this.scrollBar = scrollBar;
        scrollBar.setAutoScrollerSize(true);
        scrollBar.setScreenSize(this.height());
        scrollBar.setMaxScroll(0);
        scrollBar.withOnValueChanged(sb -> this.setYScrollOffset(sb.getScrollValue()));
        scrollBar.setStepSize(10);
    }

    public Screen getParent() {
        return this.parent;
    }

    public void displayRoutes(String stationTagName, UserSettings settings) {
        this.clearWidgets();
        this.contentHeight = 0;
        if (stationTagName == null) {
            return;
        }
        DataAccessor.getFromServer((Object)new ModAccessorTypes.DepartureRoutesData(stationTagName, Minecraft.getInstance().player.getUUID()), ModAccessorTypes.GET_DEPARTURE_AND_ARRIVAL_ROUTES_AT, routesL -> {
            for (int i = 0; i < routesL.size(); ++i) {
                Pair route = (Pair)routesL.get(i);
                if (settings.searchTrainFilter.getValue() == EDepartureBoardTrainFilter.ARRIVAL_ONLY && !((Boolean)route.getFirst()).booleanValue() || settings.searchTrainFilter.getValue() == EDepartureBoardTrainFilter.DEPARTURE_ONLY && ((Boolean)route.getFirst()).booleanValue()) continue;
                StationDeparturesWidget widget = new StationDeparturesWidget(this.parent, this, this.x() + 10, this.y() + 5 + this.contentHeight, this.width() - 20, (ClientRoute)route.getSecond(), (Boolean)route.getFirst());
                this.addRenderableWidget((GuiEventListener)widget);
                this.contentHeight += widget.height() + 3;
            }
            this.contentHeight += 7;
            this.scrollBar.setMaxScroll(this.contentHeight);
        });
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.children().isEmpty()) {
            GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x() + this.width() / 2), (int)(this.y() + this.height() / 2), (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.empty_list"), (int)-2368549, (EAlignment)EAlignment.CENTER, (boolean)false);
        }
        GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)this.y(), (int)0, (int)this.width(), (int)10, (int)0x77000000, (int)0);
        GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)(this.y() + this.height() - 10), (int)0, (int)this.width(), (int)10, (int)0, (int)0x77000000);
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }
}

