/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import de.mrjulsen.crn.client.gui.widgets.ModCommandSuggestions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;

public class ModStationSuggestions
extends ModCommandSuggestions {
    private List<String> viableStations;
    private String previous = "<>";
    private Font font;
    private boolean active;
    private List<Suggestion> currentSuggestions;
    private int yOffset;

    public ModStationSuggestions(Minecraft pMinecraft, Screen pScreen, EditBox pInput, Font pFont, List<String> viableStations, int yOffset) {
        super(pMinecraft, pScreen, pInput, pFont, true, true, 0, 7, false, -298831824);
        this.font = pFont;
        this.viableStations = viableStations;
        this.yOffset = yOffset;
        this.currentSuggestions = new ArrayList<Suggestion>();
        this.active = false;
    }

    public void tick() {
        if (this.suggestions == null) {
            this.input.setSuggestion("");
        }
        if (this.active == this.input.isFocused()) {
            return;
        }
        this.active = this.input.isFocused();
        this.updateCommandInfo();
    }

    @Override
    public void updateCommandInfo() {
        String value = this.input.getValue();
        if (value.equals(this.previous)) {
            return;
        }
        if (!this.active) {
            this.suggestions = null;
            return;
        }
        this.previous = value;
        this.currentSuggestions = this.viableStations.stream().filter(ia -> !ia.equals(value) && ia.toLowerCase().startsWith(value.toLowerCase())).map(s -> new Suggestion(new StringRange(0, s.length()), s)).toList();
        this.showSuggestions(false);
    }

    @Override
    public void showSuggestions(boolean pNarrateFirstSuggestion) {
        if (this.currentSuggestions.isEmpty()) {
            this.suggestions = null;
            return;
        }
        int width = 0;
        for (Suggestion suggestion : this.currentSuggestions) {
            width = Math.max(width, this.font.width(suggestion.getText()));
        }
        int x = Mth.clamp((int)this.input.getScreenX(0), (int)0, (int)(this.input.getScreenX(0) + this.input.getInnerWidth() - width));
        this.suggestions = new ModCommandSuggestions.SuggestionsList(x, this.yOffset, width, this.currentSuggestions, false);
    }

    public EditBox getEditBox() {
        return this.input;
    }

    public void setYOffset(int offset) {
        this.yOffset = offset;
    }
}

