/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.util;

import io.github.cotrin8672.cel.content.storage.SharedFluidTank;
import io.github.cotrin8672.cel.content.storage.SharedItemStackHandler;
import io.github.cotrin8672.cel.model.StorageFrequency;
import io.github.cotrin8672.cel.network.UpdateSharedTankPacket;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/github/cotrin8672/cel/util/SharedStorageHandler;", "Lnet/minecraft/world/level/saveddata/SavedData;", "<init>", "()V", "sharedItemStorage", "", "Lio/github/cotrin8672/cel/model/StorageFrequency;", "Lio/github/cotrin8672/cel/content/storage/SharedItemStackHandler;", "sharedFluidStorage", "Lio/github/cotrin8672/cel/content/storage/SharedFluidTank;", "getOrCreateSharedItemStorage", "frequency", "getOrCreateSharedFluidStorage", "updateTankContentFromPacket", "", "packet", "Lio/github/cotrin8672/cel/network/UpdateSharedTankPacket;", "tick", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "load", "Companion", "createenderlink"})
@SourceDebugExtension(value={"SMAP\nSharedStorageHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedStorageHandler.kt\nio/github/cotrin8672/cel/util/SharedStorageHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1863#2,2:127\n1#3:129\n*S KotlinDebug\n*F\n+ 1 SharedStorageHandler.kt\nio/github/cotrin8672/cel/util/SharedStorageHandler\n*L\n45#1:127,2\n*E\n"})
public final class SharedStorageHandler
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<StorageFrequency, SharedItemStackHandler> sharedItemStorage = new LinkedHashMap();
    @NotNull
    private final Map<StorageFrequency, SharedFluidTank> sharedFluidStorage = new LinkedHashMap();
    @Nullable
    private static SharedStorageHandler instance;

    @NotNull
    public final SharedItemStackHandler getOrCreateSharedItemStorage(@NotNull StorageFrequency frequency) {
        Intrinsics.checkNotNullParameter((Object)frequency, (String)"frequency");
        SharedItemStackHandler sharedItemStackHandler = this.sharedItemStorage.computeIfAbsent(frequency, arg_0 -> SharedStorageHandler.getOrCreateSharedItemStorage$lambda$1(arg_0 -> SharedStorageHandler.getOrCreateSharedItemStorage$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sharedItemStackHandler), (String)"computeIfAbsent(...)");
        return sharedItemStackHandler;
    }

    @NotNull
    public final SharedFluidTank getOrCreateSharedFluidStorage(@NotNull StorageFrequency frequency) {
        Intrinsics.checkNotNullParameter((Object)frequency, (String)"frequency");
        SharedFluidTank sharedFluidTank = this.sharedFluidStorage.computeIfAbsent(frequency, arg_0 -> SharedStorageHandler.getOrCreateSharedFluidStorage$lambda$3(arg_0 -> SharedStorageHandler.getOrCreateSharedFluidStorage$lambda$2(this, frequency, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sharedFluidTank), (String)"computeIfAbsent(...)");
        return sharedFluidTank;
    }

    public final void updateTankContentFromPacket(@NotNull UpdateSharedTankPacket packet) {
        block0: {
            SharedFluidTank sharedFluidTank;
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            SharedFluidTank sharedFluidTank2 = this.sharedFluidStorage.get(packet.getStorageFrequency());
            if (sharedFluidTank2 == null) break block0;
            SharedFluidTank $this$updateTankContentFromPacket_u24lambda_u244 = sharedFluidTank = sharedFluidTank2;
            boolean bl = false;
            $this$updateTankContentFromPacket_u24lambda_u244.setFluid(packet.getFluidStack());
        }
    }

    public final void tick() {
        Iterable $this$forEach$iv = this.sharedFluidStorage.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SharedFluidTank it = (SharedFluidTank)((Object)element$iv);
            boolean bl = false;
            LerpedFloat lerpedFloat = it.getFluidLevel();
            if (lerpedFloat == null) continue;
            lerpedFloat.tickChaser();
        }
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        Set<StorageFrequency> vaultFrequencies = this.sharedItemStorage.keySet();
        ListTag listTag = new ListTag();
        for (StorageFrequency frequency : vaultFrequencies) {
            CompoundTag compoundTag;
            CompoundTag $this$save_u24lambda_u247 = compoundTag = new CompoundTag();
            boolean bl = false;
            $this$save_u24lambda_u247.put("StorageFrequency", frequency.saveOptional(registries));
            SharedItemStackHandler sharedItemStackHandler = this.sharedItemStorage.get(frequency);
            if (sharedItemStackHandler != null && (sharedItemStackHandler = sharedItemStackHandler.serializeNBT(registries)) != null) {
                SharedItemStackHandler it = sharedItemStackHandler;
                boolean bl2 = false;
                $this$save_u24lambda_u247.put("Inventory", (Tag)it);
            }
            CompoundTag pairTag = compoundTag;
            listTag.add((Object)pairTag);
        }
        tag.put("SharedVaultStorage", (Tag)listTag);
        Set<StorageFrequency> tankFrequencies = this.sharedFluidStorage.keySet();
        ListTag fluidListTag = new ListTag();
        for (StorageFrequency frequency : tankFrequencies) {
            CompoundTag compoundTag;
            CompoundTag $this$save_u24lambda_u249 = compoundTag = new CompoundTag();
            boolean bl = false;
            $this$save_u24lambda_u249.put("StorageFrequency", frequency.saveOptional(registries));
            SharedFluidTank sharedFluidTank = this.sharedFluidStorage.get(frequency);
            if (sharedFluidTank != null && (sharedFluidTank = sharedFluidTank.writeToNBT(registries, new CompoundTag())) != null) {
                SharedFluidTank it = sharedFluidTank;
                boolean bl3 = false;
                $this$save_u24lambda_u249.put("Tank", (Tag)it);
            }
            CompoundTag pairTag = compoundTag;
            fluidListTag.add((Object)pairTag);
        }
        tag.put("SharedFluidStorage", (Tag)fluidListTag);
        return tag;
    }

    @NotNull
    public final SharedStorageHandler load(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ListTag list = tag.contains("SharedStorage") ? tag.getList("SharedStorage", 10) : tag.getList("SharedVaultStorage", 10);
        Intrinsics.checkNotNull((Object)list);
        for (Tag item : (Iterable)list) {
            Object frequency;
            if (!(item instanceof CompoundTag)) continue;
            if (((CompoundTag)item).contains("Frequency", 10)) {
                SharedItemStackHandler sharedItemStackHandler;
                CompoundTag frequencyItemTag = ((CompoundTag)item).getCompound("Frequency");
                CompoundTag inventoryTag = ((CompoundTag)item).getCompound("Inventory");
                ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)frequencyItemTag);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"parseOptional(...)");
                frequency = StorageFrequency.Companion.of$default(StorageFrequency.Companion, itemStack, null, 2, null);
                SharedItemStackHandler $this$load_u24lambda_u2410 = sharedItemStackHandler = new SharedItemStackHandler(27, this);
                boolean bl = false;
                $this$load_u24lambda_u2410.deserializeNBT(registries, inventoryTag);
                SharedItemStackHandler inventory = sharedItemStackHandler;
                this.sharedItemStorage.put((StorageFrequency)frequency, inventory);
                continue;
            }
            if (!((CompoundTag)item).contains("StorageFrequency", 10)) continue;
            CompoundTag compoundTag = ((CompoundTag)item).getCompound("StorageFrequency");
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
            StorageFrequency storageFrequency = StorageFrequency.Companion.parseOptional(registries, compoundTag);
            Object $this$load_u24lambda_u2411 = frequency = new SharedItemStackHandler(27, this);
            boolean bl = false;
            $this$load_u24lambda_u2411.deserializeNBT(registries, ((CompoundTag)item).getCompound("Inventory"));
            Object inventory = frequency;
            this.sharedItemStorage.put(storageFrequency, (SharedItemStackHandler)((Object)inventory));
        }
        ListTag fluidList = tag.getList("SharedFluidStorage", 10);
        Intrinsics.checkNotNull((Object)fluidList);
        for (Tag item : (Iterable)fluidList) {
            SharedFluidTank sharedFluidTank;
            if (!(item instanceof CompoundTag)) continue;
            if (((CompoundTag)item).contains("Frequency", 10)) {
                SharedFluidTank $this$load_u24lambda_u2410;
                CompoundTag frequencyItemTag = ((CompoundTag)item).getCompound("Frequency");
                CompoundTag inventoryTag = ((CompoundTag)item).getCompound("Tank");
                ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)frequencyItemTag);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"parseOptional(...)");
                StorageFrequency frequency = StorageFrequency.Companion.of$default(StorageFrequency.Companion, itemStack, null, 2, null);
                SharedFluidTank $this$load_u24lambda_u2412 = $this$load_u24lambda_u2410 = new SharedFluidTank(10000, this, frequency);
                boolean bl = false;
                Intrinsics.checkNotNull((Object)inventoryTag);
                $this$load_u24lambda_u2412.readFromNBT(registries, inventoryTag);
                SharedFluidTank fluidTank = $this$load_u24lambda_u2410;
                this.sharedFluidStorage.put(frequency, fluidTank);
                continue;
            }
            if (!((CompoundTag)item).contains("StorageFrequency", 10)) continue;
            CompoundTag compoundTag = ((CompoundTag)item).getCompound("StorageFrequency");
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
            StorageFrequency storageFrequency = StorageFrequency.Companion.parseOptional(registries, compoundTag);
            SharedFluidTank $this$load_u24lambda_u2413 = sharedFluidTank = new SharedFluidTank(10000, this, storageFrequency);
            boolean bl = false;
            CompoundTag compoundTag2 = ((CompoundTag)item).getCompound("Tank");
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag2, (String)"getCompound(...)");
            $this$load_u24lambda_u2413.readFromNBT(registries, compoundTag2);
            SharedFluidTank fluidTank = sharedFluidTank;
            this.sharedFluidStorage.put(storageFrequency, fluidTank);
        }
        return this;
    }

    private static final SharedItemStackHandler getOrCreateSharedItemStorage$lambda$0(SharedStorageHandler this$0, StorageFrequency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SharedItemStackHandler(27, this$0);
    }

    private static final SharedItemStackHandler getOrCreateSharedItemStorage$lambda$1(Function1 $tmp0, Object p0) {
        return (SharedItemStackHandler)((Object)$tmp0.invoke(p0));
    }

    private static final SharedFluidTank getOrCreateSharedFluidStorage$lambda$2(SharedStorageHandler this$0, StorageFrequency $frequency, StorageFrequency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SharedFluidTank(10000, this$0, $frequency);
    }

    private static final SharedFluidTank getOrCreateSharedFluidStorage$lambda$3(Function1 $tmp0, Object p0) {
        return (SharedFluidTank)((Object)$tmp0.invoke(p0));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/github/cotrin8672/cel/util/SharedStorageHandler$Companion;", "", "<init>", "()V", "create", "Lio/github/cotrin8672/cel/util/SharedStorageHandler;", "load", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "instance", "getInstance", "()Lio/github/cotrin8672/cel/util/SharedStorageHandler;", "setInstance", "(Lio/github/cotrin8672/cel/util/SharedStorageHandler;)V", "createenderlink"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SharedStorageHandler create() {
            return new SharedStorageHandler();
        }

        @NotNull
        public final SharedStorageHandler load(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            return this.create().load(tag, registries);
        }

        @Nullable
        public final SharedStorageHandler getInstance() {
            return instance;
        }

        public final void setInstance(@Nullable SharedStorageHandler sharedStorageHandler) {
            instance = sharedStorageHandler;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

