/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.event;

import io.github.cotrin8672.cel.util.SharedStorageHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lio/github/cotrin8672/cel/event/CommonEvents;", "", "<init>", "()V", "onLevelLoad", "", "event", "Lnet/neoforged/neoforge/event/server/ServerStartingEvent;", "onLevelUnload", "Lnet/neoforged/neoforge/event/server/ServerStoppedEvent;", "onTickEvent", "Lnet/neoforged/neoforge/event/tick/LevelTickEvent$Pre;", "createenderlink"})
public final class CommonEvents {
    @NotNull
    public static final CommonEvents INSTANCE = new CommonEvents();

    private CommonEvents() {
    }

    @SubscribeEvent
    public final void onLevelLoad(@NotNull ServerStartingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ServerLevel level = event.getServer().overworld();
        SharedStorageHandler instance = (SharedStorageHandler)level.getDataStorage().computeIfAbsent(new SavedData.Factory(SharedStorageHandler.Companion::create, SharedStorageHandler.Companion::load), "ender_vault_storage");
        SharedStorageHandler.Companion.setInstance(instance);
    }

    @SubscribeEvent
    public final void onLevelUnload(@NotNull ServerStoppedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SharedStorageHandler.Companion.setInstance(null);
    }

    @SubscribeEvent
    public final void onTickEvent(@NotNull LevelTickEvent.Pre event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            SharedStorageHandler sharedStorageHandler = SharedStorageHandler.Companion.getInstance();
            if (sharedStorageHandler == null) break block0;
            sharedStorageHandler.tick();
        }
    }
}

