/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.content.storage;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorage;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageType;
import io.github.cotrin8672.cel.content.storage.SharedFluidTank;
import io.github.cotrin8672.cel.content.storage.SharedMountedFluidStorage;
import io.github.cotrin8672.cel.model.StorageFrequency;
import io.github.cotrin8672.cel.registry.CelMountedStorageTypes;
import io.github.cotrin8672.cel.util.SharedStorageHandler;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J0\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006&"}, d2={"Lio/github/cotrin8672/cel/content/storage/SharedMountedFluidStorage;", "Lcom/simibubi/create/api/contraption/storage/fluid/MountedFluidStorage;", "frequency", "Lio/github/cotrin8672/cel/model/StorageFrequency;", "<init>", "(Lio/github/cotrin8672/cel/model/StorageFrequency;)V", "sharedFluidTank", "Lio/github/cotrin8672/cel/content/storage/SharedFluidTank;", "getSharedFluidTank", "()Lio/github/cotrin8672/cel/content/storage/SharedFluidTank;", "sharedFluidTank$delegate", "Lkotlin/Lazy;", "getTanks", "", "getFluidInTank", "Lnet/neoforged/neoforge/fluids/FluidStack;", "tank", "getTankCapacity", "isFluidValid", "", "stack", "fill", "resource", "action", "Lnet/neoforged/neoforge/fluids/capability/IFluidHandler$FluidAction;", "drain", "maxDrain", "unmount", "", "level", "Lnet/minecraft/world/level/Level;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "pos", "Lnet/minecraft/core/BlockPos;", "be", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Companion", "createenderlink"})
public final class SharedMountedFluidStorage
extends MountedFluidStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StorageFrequency frequency;
    @NotNull
    private final Lazy sharedFluidTank$delegate;
    @NotNull
    private static final MapCodec<SharedMountedFluidStorage> CODEC;

    public SharedMountedFluidStorage(@NotNull StorageFrequency frequency) {
        Intrinsics.checkNotNullParameter((Object)frequency, (String)"frequency");
        super((MountedFluidStorageType)CelMountedStorageTypes.INSTANCE.getSHARED_FLUID().get());
        this.frequency = frequency;
        this.sharedFluidTank$delegate = LazyKt.lazy(() -> SharedMountedFluidStorage.sharedFluidTank_delegate$lambda$0(this));
    }

    private final SharedFluidTank getSharedFluidTank() {
        Lazy lazy = this.sharedFluidTank$delegate;
        return (SharedFluidTank)((Object)lazy.getValue());
    }

    public int getTanks() {
        return this.getSharedFluidTank().getTanks();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        FluidStack fluidStack = this.getSharedFluidTank().getFluidInTank(tank);
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getFluidInTank(...)");
        return fluidStack;
    }

    public int getTankCapacity(int tank) {
        return this.getSharedFluidTank().getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.getSharedFluidTank().isFluidValid(tank, stack);
    }

    public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return this.getSharedFluidTank().fill(resource, action);
    }

    @NotNull
    public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        FluidStack fluidStack = this.getSharedFluidTank().drain(resource, action);
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"drain(...)");
        return fluidStack;
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        FluidStack fluidStack = this.getSharedFluidTank().drain(maxDrain, action);
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"drain(...)");
        return fluidStack;
    }

    public void unmount(@Nullable Level level, @Nullable BlockState state, @Nullable BlockPos pos, @Nullable BlockEntity be) {
    }

    private static final SharedFluidTank sharedFluidTank_delegate$lambda$0(SharedMountedFluidStorage this$0) {
        SharedStorageHandler sharedStorageHandler = SharedStorageHandler.Companion.getInstance();
        Intrinsics.checkNotNull((Object)((Object)sharedStorageHandler));
        return sharedStorageHandler.getOrCreateSharedFluidStorage(this$0.frequency);
    }

    private static final SharedMountedFluidStorage CODEC$lambda$1(Function1 $tmp0, Object p0) {
        return (SharedMountedFluidStorage)((Object)$tmp0.invoke(p0));
    }

    private static final StorageFrequency CODEC$lambda$2(SharedMountedFluidStorage it) {
        return it.frequency;
    }

    private static final StorageFrequency CODEC$lambda$3(Function1 $tmp0, Object p0) {
        return (StorageFrequency)$tmp0.invoke(p0);
    }

    static {
        MapCodec mapCodec = StorageFrequency.Companion.getCODEC().xmap(arg_0 -> SharedMountedFluidStorage.CODEC$lambda$1(Companion.CODEC.1.INSTANCE, arg_0), arg_0 -> SharedMountedFluidStorage.CODEC$lambda$3(SharedMountedFluidStorage::CODEC$lambda$2, arg_0)).fieldOf("value");
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"fieldOf(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/github/cotrin8672/cel/content/storage/SharedMountedFluidStorage$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Lio/github/cotrin8672/cel/content/storage/SharedMountedFluidStorage;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "createenderlink"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<SharedMountedFluidStorage> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

