/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.content.storage;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import io.github.cotrin8672.cel.content.block.tank.EnderTankBlockEntity;
import io.github.cotrin8672.cel.model.StorageFrequency;
import io.github.cotrin8672.cel.network.UpdateSharedTankPacket;
import io.github.cotrin8672.cel.registry.CelBlocks;
import io.github.cotrin8672.cel.util.LinkCountManager;
import io.github.cotrin8672.cel.util.SharedStorageHandler;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u001aH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lio/github/cotrin8672/cel/content/storage/SharedFluidTank;", "Lnet/neoforged/neoforge/fluids/capability/templates/FluidTank;", "capacity", "", "handler", "Lio/github/cotrin8672/cel/util/SharedStorageHandler;", "storageFrequency", "Lio/github/cotrin8672/cel/model/StorageFrequency;", "<init>", "(ILio/github/cotrin8672/cel/util/SharedStorageHandler;Lio/github/cotrin8672/cel/model/StorageFrequency;)V", "fluidLevel", "Lnet/createmod/catnip/animation/LerpedFloat;", "getFluidLevel", "()Lnet/createmod/catnip/animation/LerpedFloat;", "setFluidLevel", "(Lnet/createmod/catnip/animation/LerpedFloat;)V", "forceFluidLevelUpdate", "", "getForceFluidLevelUpdate", "()Z", "setForceFluidLevelUpdate", "(Z)V", "onContentsChanged", "", "setFluid", "stack", "Lnet/neoforged/neoforge/fluids/FluidStack;", "readFromNBT", "lookupProvider", "Lnet/minecraft/core/HolderLookup$Provider;", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "writeToNBT", "getFillState", "", "onFluidStackChanged", "newFluidStack", "createenderlink"})
public final class SharedFluidTank
extends FluidTank {
    @Nullable
    private final SharedStorageHandler handler;
    @NotNull
    private final StorageFrequency storageFrequency;
    @Nullable
    private LerpedFloat fluidLevel;
    private boolean forceFluidLevelUpdate;

    public SharedFluidTank(int capacity, @Nullable SharedStorageHandler handler, @NotNull StorageFrequency storageFrequency) {
        Intrinsics.checkNotNullParameter((Object)storageFrequency, (String)"storageFrequency");
        super(capacity);
        this.handler = handler;
        this.storageFrequency = storageFrequency;
        this.forceFluidLevelUpdate = true;
    }

    @Nullable
    public final LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public final void setFluidLevel(@Nullable LerpedFloat lerpedFloat) {
        this.fluidLevel = lerpedFloat;
    }

    public final boolean getForceFluidLevelUpdate() {
        return this.forceFluidLevelUpdate;
    }

    public final void setForceFluidLevelUpdate(boolean bl) {
        this.forceFluidLevelUpdate = bl;
    }

    protected void onContentsChanged() {
        super.onContentsChanged();
        SharedStorageHandler sharedStorageHandler = this.handler;
        if (sharedStorageHandler != null) {
            sharedStorageHandler.setDirty();
        }
        FluidStack fluidStack = this.getFluid();
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getFluid(...)");
        this.onFluidStackChanged(fluidStack);
    }

    public void setFluid(@NotNull FluidStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        super.setFluid(stack);
        SharedStorageHandler sharedStorageHandler = this.handler;
        if (sharedStorageHandler != null) {
            sharedStorageHandler.setDirty();
        }
        this.onFluidStackChanged(stack);
    }

    @NotNull
    public FluidTank readFromNBT(@NotNull HolderLookup.Provider lookupProvider, @NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)lookupProvider, (String)"lookupProvider");
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        FluidTank tank = super.readFromNBT(lookupProvider, nbt);
        double fillState = this.getFillState();
        if (nbt.contains("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue(fillState);
        }
        LerpedFloat lerpedFloat = this.fluidLevel;
        if (lerpedFloat != null) {
            lerpedFloat.chase(fillState, 0.5, LerpedFloat.Chaser.EXP);
        }
        Intrinsics.checkNotNull((Object)tank);
        return tank;
    }

    @NotNull
    public CompoundTag writeToNBT(@NotNull HolderLookup.Provider lookupProvider, @NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)lookupProvider, (String)"lookupProvider");
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        CompoundTag tag = super.writeToNBT(lookupProvider, nbt);
        if (this.forceFluidLevelUpdate) {
            tag.putBoolean("ForceFluidLevel", true);
        }
        this.forceFluidLevelUpdate = false;
        Intrinsics.checkNotNull((Object)tag);
        return tag;
    }

    private final float getFillState() {
        return (float)this.getFluidAmount() / (float)this.capacity;
    }

    private final void onFluidStackChanged(FluidStack newFluidStack) {
        block4: {
            Level level;
            SmartBlockEntity anyBe;
            FluidType attributes = newFluidStack.getFluid().getFluidType();
            int luminosity = (int)((float)attributes.getLightLevel(newFluidStack) / 1.2f);
            boolean reversed = attributes.isLighterThanAir();
            int maxY = (int)(this.getFillState() * 1.0f + 1.0f);
            ResourceKey resourceKey = CelBlocks.INSTANCE.getENDER_TANK().getKey();
            Intrinsics.checkNotNull((Object)resourceKey);
            SmartBlockEntity smartBlockEntity = anyBe = (SmartBlockEntity)CollectionsKt.firstOrNull(LinkCountManager.INSTANCE.getLoadingBlockEntities((ResourceKey<Block>)resourceKey));
            Object object = level = smartBlockEntity != null ? smartBlockEntity.getLevel() : null;
            if (level instanceof ServerLevel && ((ServerLevel)level).getServer().isDedicatedServer()) {
                FluidStack fluidStack = this.getFluid();
                Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"getFluid(...)");
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new UpdateSharedTankPacket(this.storageFrequency, fluidStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            ResourceKey resourceKey2 = CelBlocks.INSTANCE.getENDER_TANK().getKey();
            Intrinsics.checkNotNull((Object)resourceKey2);
            for (SmartBlockEntity be : LinkCountManager.INSTANCE.getLoadingBlockEntities((ResourceKey<Block>)resourceKey2)) {
                boolean isBright;
                if (!be.hasLevel() || !(be instanceof EnderTankBlockEntity)) continue;
                boolean bl = reversed ? 1 <= maxY : (isBright = 0 < maxY);
                int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
                BlockPos pos = ((EnderTankBlockEntity)be).getBlockPos();
                Level level2 = ((EnderTankBlockEntity)be).getLevel();
                if (level2 != null) {
                    level2.updateNeighbourForOutputSignal(pos, ((EnderTankBlockEntity)be).getBlockState().getBlock());
                }
                if (luminosity == actualLuminosity) continue;
                ((EnderTankBlockEntity)be).setLuminosity(actualLuminosity);
                Level level3 = ((EnderTankBlockEntity)be).getLevel();
                Intrinsics.checkNotNull((Object)level3);
                if (level3.isClientSide) continue;
                be.setChanged();
                ((EnderTankBlockEntity)be).sendData();
            }
            if (this.fluidLevel == null) {
                float fillState = this.getFillState();
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)fillState);
            }
            LerpedFloat lerpedFloat = this.fluidLevel;
            if (lerpedFloat == null) break block4;
            lerpedFloat.chase((double)this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }
}

