/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.content.ponder;

import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import io.github.cotrin8672.cel.content.SharedStorageBehaviour;
import io.github.cotrin8672.cel.content.block.vault.EnderVaultBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.math.VecHelper;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lio/github/cotrin8672/cel/content/ponder/EnderVaultPonderScene;", "", "<init>", "()V", "sharing", "", "builder", "Lnet/createmod/ponder/api/scene/SceneBuilder;", "util", "Lnet/createmod/ponder/api/scene/SceneBuildingUtil;", "contraption", "createenderlink"})
public final class EnderVaultPonderScene {
    @NotNull
    public static final EnderVaultPonderScene INSTANCE = new EnderVaultPonderScene();

    private EnderVaultPonderScene() {
    }

    public final void sharing(@NotNull SceneBuilder builder, @NotNull SceneBuildingUtil util) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)util, (String)"util");
        BlockPos rightVault = util.grid().at(1, 1, 2);
        BlockPos leftVault = util.grid().at(3, 1, 2);
        BlockPos inputFunnel = util.grid().at(1, 2, 2);
        BlockPos outputFunnel = util.grid().at(3, 1, 1);
        CreateSceneBuilder $this$sharing_u24lambda_u242 = new CreateSceneBuilder(builder);
        boolean bl = false;
        $this$sharing_u24lambda_u242.title("ender_vault_sharing", "Sharing Items via the Ender Vault");
        $this$sharing_u24lambda_u242.configureBasePlate(0, 0, 5);
        $this$sharing_u24lambda_u242.world().showSection(util.select().layer(0), Direction.UP);
        $this$sharing_u24lambda_u242.idle(5);
        $this$sharing_u24lambda_u242.world().showSection(util.select().fromTo(rightVault, leftVault), Direction.DOWN);
        $this$sharing_u24lambda_u242.idle(20);
        $this$sharing_u24lambda_u242.overlay().showText(80).attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(rightVault)).text("The Ender Vault can share its contents like an Ender Chest");
        $this$sharing_u24lambda_u242.idle(100);
        Vec3 rightFrequencySlot = VecHelper.getCenterOf((Vec3i)((Vec3i)rightVault)).add(Vec3.atLowerCornerOf((Vec3i)Direction.NORTH.getNormal()).scale(0.5));
        $this$sharing_u24lambda_u242.overlay().showFilterSlotInput(rightFrequencySlot, Direction.NORTH, 70);
        Vec3 leftFrequencySlot = VecHelper.getCenterOf((Vec3i)((Vec3i)leftVault)).add(Vec3.atLowerCornerOf((Vec3i)Direction.NORTH.getNormal()).scale(0.5));
        $this$sharing_u24lambda_u242.overlay().showFilterSlotInput(leftFrequencySlot, Direction.NORTH, 70);
        $this$sharing_u24lambda_u242.idle(10);
        $this$sharing_u24lambda_u242.overlay().showText(60).attachKeyFrame().placeNearTarget().pointAt(rightFrequencySlot).text("The Ender Vault has a slot for setting its frequency");
        $this$sharing_u24lambda_u242.idle(80);
        ItemStack andesiteAlloy = AllItems.ANDESITE_ALLOY.asStack();
        $this$sharing_u24lambda_u242.overlay().showControls(rightFrequencySlot, Pointing.DOWN, 30).withItem(andesiteAlloy);
        $this$sharing_u24lambda_u242.overlay().showControls(leftFrequencySlot, Pointing.DOWN, 30).withItem(andesiteAlloy);
        $this$sharing_u24lambda_u242.world().modifyBlockEntity(rightVault, EnderVaultBlockEntity.class, arg_0 -> EnderVaultPonderScene.sharing$lambda$2$lambda$0(andesiteAlloy, arg_0));
        $this$sharing_u24lambda_u242.world().modifyBlockEntity(leftVault, EnderVaultBlockEntity.class, arg_0 -> EnderVaultPonderScene.sharing$lambda$2$lambda$1(andesiteAlloy, arg_0));
        $this$sharing_u24lambda_u242.idle(20);
        $this$sharing_u24lambda_u242.overlay().showText(60).attachKeyFrame().placeNearTarget().pointAt(rightFrequencySlot).text("Placing an item in the slot determines the frequency");
        $this$sharing_u24lambda_u242.idle(80);
        $this$sharing_u24lambda_u242.world().showSection(util.select().layer(2), Direction.DOWN);
        $this$sharing_u24lambda_u242.idle(10);
        ItemStack iron = new ItemStack((ItemLike)Items.IRON_INGOT);
        $this$sharing_u24lambda_u242.overlay().showControls(util.vector().topOf(inputFunnel), Pointing.DOWN, 20).withItem(iron);
        $this$sharing_u24lambda_u242.idle(40);
        ElementLink entity = $this$sharing_u24lambda_u242.world().createItemEntity(util.vector().topOf(inputFunnel), util.vector().of(0.0, 0.2, 0.0), iron);
        $this$sharing_u24lambda_u242.idle(10);
        $this$sharing_u24lambda_u242.world().modifyEntity(entity, Entity::discard);
        $this$sharing_u24lambda_u242.idle(20);
        $this$sharing_u24lambda_u242.world().showSection(util.select().position(outputFunnel), Direction.SOUTH);
        $this$sharing_u24lambda_u242.idle(10);
        $this$sharing_u24lambda_u242.world().createItemEntity(util.vector().topOf(outputFunnel.below()).add(0.0, 0.0, -0.2), util.vector().of(0.0, 0.0, 0.0), iron);
        $this$sharing_u24lambda_u242.world().flapFunnel(outputFunnel, true);
        $this$sharing_u24lambda_u242.idle(20);
        $this$sharing_u24lambda_u242.overlay().showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(rightVault)).text("Ender Vaults with the same frequency share their contents");
        $this$sharing_u24lambda_u242.idle(80);
        $this$sharing_u24lambda_u242.overlay().showControls(util.vector().centerOf(rightVault), Pointing.DOWN, 50).withItem(AllItems.GOGGLES.asStack());
        $this$sharing_u24lambda_u242.idle(7);
        $this$sharing_u24lambda_u242.overlay().showText(50).text("When wearing Engineers' Goggles, the player can see how many Ender Vaults are currently linked").attachKeyFrame().colored(PonderPalette.MEDIUM).pointAt(util.vector().centerOf(rightVault)).placeNearTarget();
        $this$sharing_u24lambda_u242.idle(70);
    }

    public final void contraption(@NotNull SceneBuilder builder, @NotNull SceneBuildingUtil util) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)util, (String)"util");
        BlockPos rightVault = util.grid().at(0, 2, 3);
        BlockPos funnel = util.grid().at(0, 2, 2);
        BlockPos base = util.grid().at(0, 1, 3);
        BlockPos cobbleStone = util.grid().at(2, 1, 1);
        BlockPos drill = util.grid().at(2, 1, 3);
        BlockPos leftVault = util.grid().at(2, 2, 4);
        BlockPos largeCogwheel = util.grid().at(3, 0, 5);
        BlockPos underCogwheel = util.grid().at(4, 1, 5);
        BlockPos topCogwheel = util.grid().at(4, 2, 5);
        Selection gantryShaftSection = util.select().fromTo(4, 2, 4, 4, 2, 2);
        BlockPos gantryCarriage = util.grid().at(3, 2, 4);
        CreateSceneBuilder $this$contraption_u24lambda_u243 = new CreateSceneBuilder(builder);
        boolean bl = false;
        $this$contraption_u24lambda_u243.title("ender_vault_contraption", "Using Ender Vaults in Contraptions");
        $this$contraption_u24lambda_u243.configureBasePlate(0, 0, 5);
        $this$contraption_u24lambda_u243.world().setKineticSpeed(util.select().position(largeCogwheel), 8.0f);
        $this$contraption_u24lambda_u243.world().setKineticSpeed(util.select().position(underCogwheel), -16.0f);
        $this$contraption_u24lambda_u243.world().setKineticSpeed(util.select().position(topCogwheel), 16.0f);
        $this$contraption_u24lambda_u243.world().setKineticSpeed(gantryShaftSection, 16.0f);
        $this$contraption_u24lambda_u243.world().showSection(util.select().layer(0), Direction.UP);
        $this$contraption_u24lambda_u243.idle(5);
        $this$contraption_u24lambda_u243.world().showSection(util.select().fromTo(underCogwheel, topCogwheel), Direction.DOWN);
        $this$contraption_u24lambda_u243.world().showSection(gantryShaftSection, Direction.DOWN);
        $this$contraption_u24lambda_u243.world().showSection(util.select().position(base), Direction.DOWN);
        $this$contraption_u24lambda_u243.idle(10);
        ElementLink carriageSection = $this$contraption_u24lambda_u243.world().showIndependentSection(util.select().fromTo(drill, gantryCarriage), Direction.EAST);
        $this$contraption_u24lambda_u243.idle(10);
        $this$contraption_u24lambda_u243.world().showSection(util.select().position(rightVault), Direction.DOWN);
        $this$contraption_u24lambda_u243.idle(20);
        $this$contraption_u24lambda_u243.overlay().showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(leftVault)).text("Ender Vaults can be integrated into contraptions");
        $this$contraption_u24lambda_u243.idle(80);
        $this$contraption_u24lambda_u243.world().showSection(util.select().position(funnel), Direction.SOUTH);
        $this$contraption_u24lambda_u243.idle(10);
        $this$contraption_u24lambda_u243.world().showSection(util.select().position(cobbleStone), Direction.DOWN);
        $this$contraption_u24lambda_u243.idle(20);
        $this$contraption_u24lambda_u243.world().setKineticSpeed(util.select().position(largeCogwheel), -8.0f);
        $this$contraption_u24lambda_u243.world().setKineticSpeed(util.select().position(underCogwheel), 16.0f);
        $this$contraption_u24lambda_u243.world().setKineticSpeed(util.select().position(topCogwheel), -16.0f);
        $this$contraption_u24lambda_u243.world().setKineticSpeed(gantryShaftSection, -16.0f);
        $this$contraption_u24lambda_u243.world().setKineticSpeed(util.select().position(drill), 16.0f);
        $this$contraption_u24lambda_u243.world().moveSection(carriageSection, util.vector().of(0.0, 0.0, -1.0), 40);
        $this$contraption_u24lambda_u243.idle(40);
        for (int i = 0; i < 10; ++i) {
            $this$contraption_u24lambda_u243.idle(5);
            $this$contraption_u24lambda_u243.world().incrementBlockBreakingProgress(cobbleStone);
        }
        $this$contraption_u24lambda_u243.world().createItemEntity(util.vector().topOf(funnel.below()).add(0.0, 0.0, -0.2), util.vector().of(0.0, 0.0, 0.0), new ItemStack((ItemLike)Items.COBBLESTONE));
        $this$contraption_u24lambda_u243.world().flapFunnel(funnel, true);
        $this$contraption_u24lambda_u243.world().moveSection(carriageSection, util.vector().of(0.0, 0.0, -1.0), 40);
        $this$contraption_u24lambda_u243.idle(20);
        $this$contraption_u24lambda_u243.overlay().showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(rightVault)).text("Vaults in a contraption also share contents with other vaults on the same frequency");
        $this$contraption_u24lambda_u243.idle(20);
        $this$contraption_u24lambda_u243.world().setKineticSpeed(util.select().position(drill), 0.0f);
        $this$contraption_u24lambda_u243.idle(60);
    }

    private static final void sharing$lambda$2$lambda$0(ItemStack $andesiteAlloy, EnderVaultBlockEntity it) {
        SharedStorageBehaviour sharedStorageBehaviour = (SharedStorageBehaviour)it.getBehaviour(SharedStorageBehaviour.Companion.getTYPE());
        Intrinsics.checkNotNull((Object)$andesiteAlloy);
        sharedStorageBehaviour.setFrequencyItem($andesiteAlloy);
    }

    private static final void sharing$lambda$2$lambda$1(ItemStack $andesiteAlloy, EnderVaultBlockEntity it) {
        SharedStorageBehaviour sharedStorageBehaviour = (SharedStorageBehaviour)it.getBehaviour(SharedStorageBehaviour.Companion.getTYPE());
        Intrinsics.checkNotNull((Object)$andesiteAlloy);
        sharedStorageBehaviour.setFrequencyItem($andesiteAlloy);
    }
}

