/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.content.block.tank;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import io.github.cotrin8672.cel.client.FrequencyRenderer;
import io.github.cotrin8672.cel.content.SharedStorageBehaviour;
import io.github.cotrin8672.cel.content.block.tank.EnderTankBlockEntity;
import io.github.cotrin8672.cel.content.storage.SharedFluidTank;
import io.github.cotrin8672.cel.util.SharedStorageHandler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.kotlinforforge.neoforge.forge.PoseStackUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lio/github/cotrin8672/cel/content/block/tank/EnderTankRenderer;", "Lcom/simibubi/create/foundation/blockEntity/renderer/SmartBlockEntityRenderer;", "Lio/github/cotrin8672/cel/content/block/tank/EnderTankBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "renderSafe", "", "blockEntity", "partialTicks", "", "ms", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "light", "", "overlay", "createenderlink"})
public final class EnderTankRenderer
extends SmartBlockEntityRenderer<EnderTankBlockEntity> {
    public EnderTankRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    protected void renderSafe(@NotNull EnderTankBlockEntity blockEntity, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Float f;
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.renderSafe((SmartBlockEntity)blockEntity, partialTicks, ms, buffer, light, overlay);
        FrequencyRenderer.INSTANCE.renderOnBlockEntity(blockEntity, partialTicks, ms, buffer, 0xF00000, overlay);
        float capHeight = 0.25f;
        float tankHullWidth = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = 1.0f - (float)2 * capHeight - minPuddleHeight;
        SharedStorageBehaviour behaviour = (SharedStorageBehaviour)blockEntity.getBehaviour(SharedStorageBehaviour.Companion.getTYPE());
        Object object = SharedStorageHandler.Companion.getInstance();
        if (object == null || (object = object.getOrCreateSharedFluidStorage(behaviour.getFrequency())) == null) {
            return;
        }
        SharedStorageHandler sharedFluidTank = object;
        if (!(blockEntity.getLevel() instanceof PonderLevel)) {
            LerpedFloat lerpedFloat = ((SharedFluidTank)((Object)sharedFluidTank)).getFluidLevel();
            f = lerpedFloat != null ? Float.valueOf(lerpedFloat.getValue(partialTicks)) : null;
        } else {
            SharedFluidTank sharedFluidTank2 = blockEntity.getFluidTank();
            Intrinsics.checkNotNull((Object)((Object)sharedFluidTank2));
            float f2 = sharedFluidTank2.getFluidAmount();
            SharedFluidTank sharedFluidTank3 = blockEntity.getFluidTank();
            Intrinsics.checkNotNull((Object)((Object)sharedFluidTank3));
            f = Float.valueOf(f2 / (float)sharedFluidTank3.getCapacity());
        }
        if (f == null) {
            return;
        }
        float level = f.floatValue();
        if (level <= 0.0f && !(blockEntity.getLevel() instanceof PonderLevel)) {
            return;
        }
        float clampedLevel = Mth.clamp((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        SharedFluidTank sharedFluidTank4 = blockEntity.getFluidTank();
        if (sharedFluidTank4 == null) {
            return;
        }
        SharedFluidTank tank = sharedFluidTank4;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        float xMin = tankHullWidth;
        float xMax = 1.0f - tankHullWidth;
        float yMin = capHeight + minPuddleHeight;
        float yMax = yMin + clampedLevel;
        float zMin = tankHullWidth;
        float zMax = 1.0f - tankHullWidth;
        PoseStackUtilKt.use((PoseStack)ms, () -> EnderTankRenderer.renderSafe$lambda$0(fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, buffer, ms, light));
    }

    private static final Unit renderSafe$lambda$0(FluidStack $fluidStack, float $xMin, float $yMin, float $zMin, float $xMax, float $yMax, float $zMax, MultiBufferSource $buffer, PoseStack $ms, int $light) {
        NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)$fluidStack, $xMin, $yMin, $zMin, $xMax, $yMax, $zMax, $buffer, $ms, $light, false, true);
        return Unit.INSTANCE;
    }
}

