/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.content;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.cotrin8672.cel.model.ProfileKey;
import io.github.cotrin8672.cel.model.StorageFrequency;
import io.github.cotrin8672.cel.network.SyncFullLinkPacket;
import io.github.cotrin8672.cel.registry.CelDataComponents;
import io.github.cotrin8672.cel.registry.CelItems;
import io.github.cotrin8672.cel.util.BlockEntityExtensionKt;
import io.github.cotrin8672.cel.util.CelLang;
import io.github.cotrin8672.cel.util.LinkCountManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 A2\u00020\u00012\u00020\u0002:\u0001AB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\u0006\u0010\u001b\u001a\u00020\nJ\u001c\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u0014H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010*\u001a\u00020\u00142\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020.H\u0016J,\u00101\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010,2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u00105\u001a\u00020#H\u0016J\b\u00106\u001a\u00020#H\u0016J\b\u00107\u001a\u00020\u000eH\u0016J\u001c\u00108\u001a\u00020\u000e2\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:2\u0006\u0010<\u001a\u00020\u0014J$\u0010=\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010>\u001a\u0004\u0018\u00010%2\u0006\u0010?\u001a\u00020\u0014H\u0016J\b\u0010@\u001a\u00020%H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lio/github/cotrin8672/cel/content/SharedStorageBehaviour;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueSettingsBehaviour;", "be", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "slotPositioning", "Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueBoxTransform;", "<init>", "(Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueBoxTransform;)V", "storageFrequency", "Lio/github/cotrin8672/cel/model/StorageFrequency;", "getType", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "write", "", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "clientPacket", "", "read", "testHit", "hit", "Lnet/minecraft/world/phys/Vec3;", "isActive", "getSlotPositioning", "getFrequency", "createBoard", "Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueSettingsBoard;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "formatValue", "Lnet/minecraft/network/chat/MutableComponent;", "value", "Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueSettingsBehaviour$ValueSettings;", "acceptsValueSettings", "getRenderDistance", "", "setStorageFrequency", "setFrequencyItem", "face", "Lnet/minecraft/core/Direction;", "stack", "Lnet/minecraft/world/item/ItemStack;", "canShortInteract", "toApply", "onShortInteract", "hand", "Lnet/minecraft/world/InteractionHand;", "side", "getLabel", "getTip", "destroy", "addToGoggleTooltip", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "isPlayerSneaking", "setValueSettings", "valueSetting", "ctrlDown", "getValueSettings", "Companion", "createenderlink"})
@SourceDebugExtension(value={"SMAP\nSharedStorageBehaviour.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedStorageBehaviour.kt\nio/github/cotrin8672/cel/content/SharedStorageBehaviour\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1#2:257\n*E\n"})
public class SharedStorageBehaviour
extends BlockEntityBehaviour
implements ValueSettingsBehaviour {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ValueBoxTransform slotPositioning;
    @NotNull
    private StorageFrequency storageFrequency;
    @NotNull
    private static final BehaviourType<SharedStorageBehaviour> TYPE = new BehaviourType();

    public SharedStorageBehaviour(@NotNull SmartBlockEntity be, @NotNull ValueBoxTransform slotPositioning) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)slotPositioning, (String)"slotPositioning");
        super(be);
        this.slotPositioning = slotPositioning;
        this.storageFrequency = StorageFrequency.Companion.getEMPTY();
    }

    @NotNull
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void write(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        nbt.put("StorageFrequency", this.getFrequency().saveOptional(registries));
        super.write(nbt, registries, clientPacket);
    }

    public void read(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries, boolean clientPacket) {
        StorageFrequency storageFrequency;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        if (nbt.contains("Frequency", 10)) {
            ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("Frequency"));
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"parseOptional(...)");
            storageFrequency = StorageFrequency.Companion.of$default(StorageFrequency.Companion, itemStack, null, 2, null);
        } else {
            CompoundTag compoundTag = nbt.getCompound("StorageFrequency");
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getCompound(...)");
            storageFrequency = StorageFrequency.Companion.parseOptional(registries, compoundTag);
        }
        this.storageFrequency = storageFrequency;
        super.read(nbt, registries, clientPacket);
    }

    public boolean testHit(@NotNull Vec3 hit) {
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        BlockState state = this.blockEntity.getBlockState();
        Vec3 localHit = hit.subtract(Vec3.atLowerCornerOf((Vec3i)((Vec3i)this.blockEntity.getBlockPos())));
        return this.slotPositioning.testHit((LevelAccessor)this.getWorld(), this.getPos(), state, localHit);
    }

    public boolean isActive() {
        return true;
    }

    @NotNull
    public ValueBoxTransform getSlotPositioning() {
        return this.slotPositioning;
    }

    @NotNull
    public final StorageFrequency getFrequency() {
        return this.storageFrequency;
    }

    @NotNull
    public ValueSettingsBoard createBoard(@Nullable Player player, @Nullable BlockHitResult hitResult) {
        ItemStack frequency = this.getFrequency().getStack();
        Integer maxAmount = frequency.getItem() instanceof FilterItem ? Integer.valueOf(64) : (Integer)frequency.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64);
        Component component = (Component)CreateLang.translateDirect((String)"logistics.filter.extracted_amount", (Object[])new Object[0]);
        Intrinsics.checkNotNull((Object)maxAmount);
        String[] stringArray = new String[]{"up_to", "exactly"};
        return new ValueSettingsBoard(component, maxAmount.intValue(), 16, CreateLang.translatedOptions((String)"logistics.filter", (String[])stringArray), new ValueSettingsFormatter(this::formatValue));
    }

    private final MutableComponent formatValue(ValueSettingsBehaviour.ValueSettings value) {
        if (value.row() == 0) {
            Integer n = (Integer)this.getFrequency().getStack().getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)64);
            if (n != null && value.value() == n.intValue()) {
                return CreateLang.translateDirect((String)"logistics.filter.any_amount_short", (Object[])new Object[0]);
            }
        }
        return Component.literal((String)((value.row() == 0 ? "\u2264" : "=") + Math.max(1.0, (double)value.value())));
    }

    public boolean acceptsValueSettings() {
        return false;
    }

    public float getRenderDistance() {
        return AllConfigs.client().filterItemRenderDistance.getF();
    }

    public final void setStorageFrequency(@NotNull StorageFrequency storageFrequency) {
        Intrinsics.checkNotNullParameter((Object)storageFrequency, (String)"storageFrequency");
        this.storageFrequency = storageFrequency;
        this.blockEntity.setChanged();
        this.blockEntity.sendData();
    }

    public boolean setFrequencyItem(@Nullable Direction face, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.setFrequencyItem(stack);
    }

    public boolean setFrequencyItem(@NotNull ItemStack stack) {
        StorageFrequency storageFrequency;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ItemStack filter = stack.copy();
        if (filter.is((Holder)CelItems.INSTANCE.getSCOPE_FILTER())) {
            storageFrequency = (StorageFrequency)stack.get(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY());
            if (storageFrequency == null) {
                Intrinsics.checkNotNull((Object)filter);
                storageFrequency = StorageFrequency.Companion.of$default(StorageFrequency.Companion, filter, null, 2, null);
            }
        } else {
            Intrinsics.checkNotNull((Object)filter);
            storageFrequency = StorageFrequency.Companion.of$default(StorageFrequency.Companion, filter, null, 2, null);
        }
        this.storageFrequency = storageFrequency;
        this.blockEntity.setChanged();
        this.blockEntity.sendData();
        if (this.blockEntity.getLevel() instanceof ServerLevel) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncFullLinkPacket(LinkCountManager.INSTANCE.getLinkedList()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return true;
    }

    public boolean canShortInteract(@NotNull ItemStack toApply) {
        Intrinsics.checkNotNullParameter((Object)toApply, (String)"toApply");
        if (AllItems.WRENCH.isIn(toApply)) {
            return false;
        }
        return !AllBlocks.MECHANICAL_ARM.isIn(toApply);
    }

    public void onShortInteract(@NotNull Player player, @NotNull InteractionHand hand, @Nullable Direction side, @Nullable BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Level level = this.getWorld();
        BlockPos pos = this.getPos();
        ItemStack itemInHand = player.getItemInHand(hand);
        ItemStack toApply = itemInHand.copy();
        Intrinsics.checkNotNull((Object)toApply);
        if (!this.canShortInteract(toApply)) {
            return;
        }
        if (level.isClientSide()) {
            return;
        }
        if (this.storageFrequency.isPersonalScope() && !player.isCreative()) {
            ItemStack itemStack;
            ItemStack $this$onShortInteract_u24lambda_u240 = itemStack = CelItems.INSTANCE.getSCOPE_FILTER().asStack();
            boolean bl = false;
            $this$onShortInteract_u24lambda_u240.set(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY(), (Object)this.storageFrequency);
            ItemStack scopeFilter = itemStack;
            player.getInventory().placeItemBackInInventory(scopeFilter);
        }
        if (toApply.is((Holder)CelItems.INSTANCE.getSCOPE_FILTER()) && !player.isCreative() && toApply.get(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY()) != null) {
            if (itemInHand.getCount() == 1) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            } else {
                itemInHand.shrink(1);
            }
        }
        if (!this.setFrequencyItem(side, toApply)) {
            AllSoundEvents.DENY.playOnServer(player.level(), (Vec3i)player.blockPosition(), 1.0f, 1.0f);
        }
        level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.25f, 0.1f);
    }

    @NotNull
    public MutableComponent getLabel() {
        MutableComponent mutableComponent = CelLang.INSTANCE.translate("tooltip.frequency.frequency", new Object[0]).component();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"component(...)");
        return mutableComponent;
    }

    @NotNull
    public MutableComponent getTip() {
        MutableComponent mutableComponent = CelLang.INSTANCE.translate(this.storageFrequency.getStack().isEmpty() && this.storageFrequency.isGlobalScope() ? "tooltip.frequency.click_to_set" : "tooltip.frequency.click_to_replace", new Object[0]).component();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"component(...)");
        return mutableComponent;
    }

    public void destroy() {
        if (this.storageFrequency.isPersonalScope()) {
            ItemStack itemStack;
            Vec3 pos = VecHelper.getCenterOf((Vec3i)((Vec3i)this.getPos()));
            Level world = this.getWorld();
            ItemStack $this$destroy_u24lambda_u241 = itemStack = CelItems.INSTANCE.getSCOPE_FILTER().asStack();
            boolean bl = false;
            $this$destroy_u24lambda_u241.set(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY(), (Object)this.storageFrequency);
            ItemStack stack = itemStack;
            world.addFreshEntity((Entity)new ItemEntity(world, pos.x, pos.y, pos.z, stack));
        }
        super.destroy();
    }

    public final void addToGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        int n;
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        ItemStack frequencyItem = this.getFrequency().getStack();
        ProfileKey frequencyOwner = this.getFrequency().getProfileKey();
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        Intrinsics.checkNotNullExpressionValue((Object)smartBlockEntity, (String)"blockEntity");
        ResourceKey<Block> resourceKey = BlockEntityExtensionKt.getBlockKey((BlockEntity)smartBlockEntity);
        if (resourceKey != null) {
            ResourceKey<Block> it = resourceKey;
            boolean bl = false;
            n = LinkCountManager.INSTANCE.getLinkedCount(it, this.getFrequency());
        } else {
            n = 0;
        }
        int count = n;
        CelLang.INSTANCE.translate("gui.goggles.storage_stat", new Object[0]).forGoggles(tooltip);
        CelLang.INSTANCE.translate("gui.goggles.frequency_scope", new Object[0]).add(this.getFrequency().isGlobalScope() ? CelLang.INSTANCE.translate("gui.goggles.scope_global", new Object[0]).component() : Component.literal((String)frequencyOwner.name())).style(ChatFormatting.YELLOW).forGoggles(tooltip);
        CelLang.INSTANCE.translate("gui.goggles.frequency_item", new Object[0]).add(CelLang.INSTANCE.itemName(frequencyItem)).style(ChatFormatting.GREEN).forGoggles(tooltip);
        CelLang.INSTANCE.translate("gui.goggles.same_frequency_count", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CelLang.INSTANCE.number(count).space().translate((double)count > 1.0 ? "gui.goggles.block.plural" : "gui.goggles.block.singular", new Object[0]).style(ChatFormatting.AQUA).space().add(CelLang.INSTANCE.translate("gui.goggles.at_current_loading", new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
    }

    public void setValueSettings(@Nullable Player player, @Nullable ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlDown) {
    }

    @NotNull
    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        return new ValueSettingsBehaviour.ValueSettings(0, 0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/github/cotrin8672/cel/content/SharedStorageBehaviour$Companion;", "", "<init>", "()V", "TYPE", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "Lio/github/cotrin8672/cel/content/SharedStorageBehaviour;", "getTYPE", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/BehaviourType;", "createenderlink"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BehaviourType<SharedStorageBehaviour> getTYPE() {
            return TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

