/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.util;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.cotrin8672.cem.mixin.KineticBlockEntityMixin;
import io.github.cotrin8672.cem.mixin.SmartBlockEntityMixin;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u0007*\u00020\u00022\u0016\u0010\b\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00070\n0\t\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\f*\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\f*\u00020\u000f\u001a\n\u0010\u0011\u001a\u00020\f*\u00020\u0012\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"nonNullLevel", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "getNonNullLevel", "(Lnet/minecraft/world/level/block/entity/BlockEntity;)Lnet/minecraft/world/level/Level;", "holderLookup", "Lnet/minecraft/core/HolderLookup;", "T", "registryKey", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/core/Registry;", "smartBlockEntityTick", "", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "kineticBlockEntityTick", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "validateKinetics", "basinOperatingBlockEntityTick", "Lcom/simibubi/create/content/kinetics/mixer/MechanicalMixerBlockEntity;", "createenchantablemachinery"})
public final class BlockEntityExtensionKt {
    @NotNull
    public static final Level getNonNullLevel(@NotNull BlockEntity $this$nonNullLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$nonNullLevel, (String)"<this>");
        Level level = $this$nonNullLevel.getLevel();
        if (level == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return level;
    }

    @NotNull
    public static final <T> HolderLookup<T> holderLookup(@NotNull BlockEntity $this$holderLookup, @NotNull ResourceKey<? extends Registry<? extends T>> registryKey) {
        Intrinsics.checkNotNullParameter((Object)$this$holderLookup, (String)"<this>");
        Intrinsics.checkNotNullParameter(registryKey, (String)"registryKey");
        Level level = $this$holderLookup.getLevel();
        if (level == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        HolderLookup holderLookup = level.holderLookup(registryKey);
        Intrinsics.checkNotNullExpressionValue((Object)holderLookup, (String)"holderLookup(...)");
        return holderLookup;
    }

    public static final void smartBlockEntityTick(@NotNull SmartBlockEntity $this$smartBlockEntityTick) {
        Intrinsics.checkNotNullParameter((Object)$this$smartBlockEntityTick, (String)"<this>");
        if (!((SmartBlockEntityMixin)$this$smartBlockEntityTick).getInitialized() && $this$smartBlockEntityTick.hasLevel()) {
            $this$smartBlockEntityTick.initialize();
            ((SmartBlockEntityMixin)$this$smartBlockEntityTick).setInitialized(true);
        }
        int n = ((SmartBlockEntityMixin)$this$smartBlockEntityTick).getLazyTickCounter();
        ((SmartBlockEntityMixin)$this$smartBlockEntityTick).setLazyTickCounter(n + -1);
        if (n <= 0) {
            ((SmartBlockEntityMixin)$this$smartBlockEntityTick).setLazyTickCounter(((SmartBlockEntityMixin)$this$smartBlockEntityTick).getLazyTickRate());
            $this$smartBlockEntityTick.lazyTick();
        }
        $this$smartBlockEntityTick.forEachBehaviour(BlockEntityBehaviour::tick);
    }

    public static final void kineticBlockEntityTick(@NotNull KineticBlockEntity $this$kineticBlockEntityTick) {
        Intrinsics.checkNotNullParameter((Object)$this$kineticBlockEntityTick, (String)"<this>");
        if (!BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)$this$kineticBlockEntityTick)).isClientSide && $this$kineticBlockEntityTick.needsSpeedUpdate()) {
            $this$kineticBlockEntityTick.attachKinetics();
        }
        BlockEntityExtensionKt.smartBlockEntityTick((SmartBlockEntity)$this$kineticBlockEntityTick);
        ((KineticBlockEntityMixin)$this$kineticBlockEntityTick).getEffects().tick();
        $this$kineticBlockEntityTick.preventSpeedUpdate = 0;
        if (BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)$this$kineticBlockEntityTick)).isClientSide) {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> BlockEntityExtensionKt.kineticBlockEntityTick$lambda$0($this$kineticBlockEntityTick));
            return;
        }
        int n = ((KineticBlockEntityMixin)$this$kineticBlockEntityTick).getValidationCountdown();
        ((KineticBlockEntityMixin)$this$kineticBlockEntityTick).setValidationCountdown(n + -1);
        if (n <= 0) {
            ((KineticBlockEntityMixin)$this$kineticBlockEntityTick).setValidationCountdown(((Number)AllConfigs.server().kinetics.kineticValidationFrequency.get()).intValue());
            BlockEntityExtensionKt.validateKinetics($this$kineticBlockEntityTick);
        }
        if ($this$kineticBlockEntityTick.getFlickerScore() > 0) {
            ((KineticBlockEntityMixin)$this$kineticBlockEntityTick).setFlickerTally($this$kineticBlockEntityTick.getFlickerScore() - 1);
        }
        if ($this$kineticBlockEntityTick.networkDirty) {
            if ($this$kineticBlockEntityTick.hasNetwork()) {
                $this$kineticBlockEntityTick.getOrCreateNetwork().updateNetwork();
            }
            $this$kineticBlockEntityTick.networkDirty = false;
        }
    }

    public static final void validateKinetics(@NotNull KineticBlockEntity $this$validateKinetics) {
        Intrinsics.checkNotNullParameter((Object)$this$validateKinetics, (String)"<this>");
        if ($this$validateKinetics.hasSource()) {
            KineticBlockEntity sourceBE;
            if (!$this$validateKinetics.hasNetwork()) {
                $this$validateKinetics.removeSource();
                return;
            }
            if ($this$validateKinetics.source == null) {
                return;
            }
            if (!BlockEntityExtensionKt.getNonNullLevel((BlockEntity)$this$validateKinetics).isLoaded($this$validateKinetics.source)) {
                return;
            }
            BlockEntity blockEntity = BlockEntityExtensionKt.getNonNullLevel((BlockEntity)$this$validateKinetics).getBlockEntity($this$validateKinetics.source);
            KineticBlockEntity kineticBlockEntity = sourceBE = blockEntity instanceof KineticBlockEntity ? (KineticBlockEntity)blockEntity : null;
            if (sourceBE == null || sourceBE.getSpeed() == 0.0f) {
                $this$validateKinetics.removeSource();
                $this$validateKinetics.detachKinetics();
                return;
            }
            return;
        }
        if (!($this$validateKinetics.getSpeed() == 0.0f) && $this$validateKinetics.getGeneratedSpeed() == 0.0f) {
            $this$validateKinetics.setSpeed(0.0f);
        }
    }

    public static final void basinOperatingBlockEntityTick(@NotNull MechanicalMixerBlockEntity $this$basinOperatingBlockEntityTick) {
        Intrinsics.checkNotNullParameter((Object)$this$basinOperatingBlockEntityTick, (String)"<this>");
        if ($this$basinOperatingBlockEntityTick.basinRemoved) {
            $this$basinOperatingBlockEntityTick.basinRemoved = false;
            if (!$this$basinOperatingBlockEntityTick.running) {
                return;
            }
            $this$basinOperatingBlockEntityTick.runningTicks = 40;
            $this$basinOperatingBlockEntityTick.running = false;
            $this$basinOperatingBlockEntityTick.sendData();
            return;
        }
        BlockEntityExtensionKt.kineticBlockEntityTick((KineticBlockEntity)$this$basinOperatingBlockEntityTick);
    }

    private static final Runnable kineticBlockEntityTick$lambda$0(KineticBlockEntity $this_kineticBlockEntityTick) {
        return () -> ((KineticBlockEntity)$this_kineticBlockEntityTick).tickAudio();
    }
}

