/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.saw;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import io.github.cotrin8672.cem.client.CustomRenderType;
import io.github.cotrin8672.cem.config.CemConfig;
import io.github.cotrin8672.cem.content.block.saw.EnchantableSawBlockEntity;
import io.github.cotrin8672.cem.registry.PartialModelRegistration;
import io.github.cotrin8672.cem.util.BlockEntityExtensionKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.kotlinforforge.neoforge.forge.PoseStackUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\fH\u0002J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0014J(\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J8\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/cotrin8672/cem/content/block/saw/EnchantableSawRenderer;", "Lcom/simibubi/create/foundation/blockEntity/renderer/SafeBlockEntityRenderer;", "Lio/github/cotrin8672/cem/content/block/saw/EnchantableSawBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "getRotatedModel", "Lnet/createmod/catnip/render/SuperByteBuffer;", "be", "getRenderedBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "renderSafe", "", "partialTicks", "", "ms", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "light", "", "overlay", "renderBlade", "renderShaft", "renderItems", "Companion", "createenchantablemachinery"})
public final class EnchantableSawRenderer
extends SafeBlockEntityRenderer<EnchantableSawBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockEntityRendererProvider.Context context;
    @NotNull
    private static final RandomSource RANDOM;

    public EnchantableSawRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    private final SuperByteBuffer getRotatedModel(EnchantableSawBlockEntity be) {
        BlockState state = be.getBlockState();
        if (((Direction)state.getValue((Property)BlockStateProperties.FACING)).getAxis().isHorizontal()) {
            SuperByteBuffer superByteBuffer = CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state.rotate((LevelAccessor)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)be), be.getBlockPos(), Rotation.CLOCKWISE_180));
            Intrinsics.checkNotNullExpressionValue((Object)superByteBuffer, (String)"partialFacing(...)");
            return superByteBuffer;
        }
        SuperByteBuffer superByteBuffer = CachedBuffers.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)this.getRenderedBlockState((KineticBlockEntity)be));
        Intrinsics.checkNotNullExpressionValue((Object)superByteBuffer, (String)"block(...)");
        return superByteBuffer;
    }

    private final BlockState getRenderedBlockState(KineticBlockEntity be) {
        BlockState blockState = KineticBlockEntityRenderer.shaft((Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be));
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"shaft(...)");
        return blockState;
    }

    protected void renderSafe(@NotNull EnchantableSawBlockEntity be, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.renderBlade(be, ms, buffer, light);
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)((SmartBlockEntity)be), (float)partialTicks, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
        PoseStackUtilKt.use((PoseStack)ms, () -> EnchantableSawRenderer.renderSafe$lambda$0(buffer, ms, this, be));
        if (!VisualizationManager.supportsVisualization((LevelAccessor)((LevelAccessor)be.getLevel()))) {
            this.renderShaft(be, ms, buffer, light);
        }
    }

    private final void renderBlade(EnchantableSawBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light) {
        BlockState blockState = be.getBlockState();
        PartialModel partial = null;
        float speed = be.getSpeed();
        boolean rotate = false;
        if (SawBlock.isHorizontal((BlockState)blockState)) {
            partial = speed > 0.0f ? AllPartialModels.SAW_BLADE_HORIZONTAL_ACTIVE : (speed < 0.0f ? AllPartialModels.SAW_BLADE_HORIZONTAL_REVERSED : AllPartialModels.SAW_BLADE_HORIZONTAL_INACTIVE);
        } else {
            PartialModel partialModel = be.getSpeed() > 0.0f ? AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE : (partial = speed < 0.0f ? AllPartialModels.SAW_BLADE_VERTICAL_REVERSED : AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE);
            if (((Boolean)blockState.getValue((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
                rotate = true;
            }
        }
        PartialModel enchantedBlade = PartialModelRegistration.getENCHANTABLE_SAW_BLADE();
        SuperByteBuffer superBuffer = CachedBuffers.partialFacing((PartialModel)partial, (BlockState)blockState);
        SuperByteBuffer enchantedSuperBuffer = CachedBuffers.partialFacing((PartialModel)enchantedBlade, (BlockState)blockState);
        if (rotate) {
            superBuffer.rotateCentered(AngleHelper.rad((double)90.0), Direction.UP);
            enchantedSuperBuffer.rotateCentered(AngleHelper.rad((double)90.0), Direction.UP);
        }
        superBuffer.color(0xFFFFFF).light(light).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
        SheetedDecalTextureGenerator consumer = new SheetedDecalTextureGenerator(buffer.getBuffer(CustomRenderType.Companion.getGLINT()), ms.last(), 0.007125f);
        enchantedSuperBuffer.color(0xFFFFFF).light(light).renderInto(ms, (VertexConsumer)consumer);
    }

    private final void renderShaft(EnchantableSawBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light) {
        KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)((KineticBlockEntity)be), (SuperByteBuffer)this.getRotatedModel(be), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(RenderType.solid()), (int)light);
    }

    private final void renderItems(EnchantableSawBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean processingMode;
        boolean bl = processingMode = be.getBlockState().getValue((Property)SawBlock.FACING) == Direction.UP;
        if (processingMode && !be.inventory.isEmpty()) {
            boolean alongZ = (Boolean)be.getBlockState().getValue((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
            PoseStackUtilKt.use((PoseStack)ms, () -> EnchantableSawRenderer.renderItems$lambda$1(be, partialTicks, alongZ, ms, light, overlay, buffer));
        }
    }

    private static final Unit renderSafe$lambda$0(MultiBufferSource $buffer, PoseStack $ms, EnchantableSawRenderer this$0, EnchantableSawBlockEntity $be) {
        if (((Boolean)CemConfig.Companion.getCONFIG().getRenderGlint().get()).booleanValue()) {
            SheetedDecalTextureGenerator consumer = new SheetedDecalTextureGenerator($buffer.getBuffer(CustomRenderType.Companion.getGLINT()), $ms.last(), 0.007125f);
            this$0.context.getBlockRenderDispatcher().renderBatched($be.getBlockState(), $be.getBlockPos(), (BlockAndTintGetter)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)$be), $ms, (VertexConsumer)consumer, true, RANDOM);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderItems$lambda$1(EnchantableSawBlockEntity $be, float $partialTicks, boolean $alongZ, PoseStack $ms, int $light, int $overlay, MultiBufferSource $buffer) {
        boolean moving = !($be.inventory.recipeDuration == 0.0f);
        float offset = moving ? $be.inventory.remainingTime / $be.inventory.recipeDuration : 0.0f;
        float processingSpeed = Mth.clamp((float)(Math.abs($be.getSpeed()) / (float)32), (float)1.0f, (float)128.0f);
        if (moving) {
            offset = Mth.clamp((float)(offset + (-$partialTicks + 0.5f) * processingSpeed / $be.inventory.recipeDuration), (float)0.125f, (float)1.0f);
            if (!$be.inventory.appliedRecipe) {
                offset += 1.0f;
            }
            offset /= 2.0f;
        }
        if ($be.getSpeed() == 0.0f) {
            offset = 0.5f;
        }
        if ($be.getSpeed() < 0.0f ^ $alongZ) {
            offset = 1.0f - offset;
        }
        int n = $be.inventory.getSlots();
        for (int i = 0; i < n; ++i) {
            ItemStack stack = $be.inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            BakedModel modelWithOverrides = itemRenderer.getModel(stack, $be.getLevel(), null, 0);
            boolean blockItem = modelWithOverrides.isGui3d();
            $ms.translate($alongZ ? (double)offset : 0.5, (double)(blockItem ? 0.925f : 0.8125f), $alongZ ? 0.5 : (double)offset);
            $ms.scale(0.5f, 0.5f, 0.5f);
            if ($alongZ) {
                $ms.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
            $ms.mulPose(Axis.XP.rotationDegrees(90.0f));
            itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, $light, $overlay, $ms, $buffer, $be.getLevel(), 0);
            break;
        }
        return Unit.INSTANCE;
    }

    static {
        RandomSource randomSource = RandomSource.create();
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"create(...)");
        RANDOM = randomSource;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/cotrin8672/cem/content/block/saw/EnchantableSawRenderer$Companion;", "", "<init>", "()V", "RANDOM", "Lnet/minecraft/util/RandomSource;", "renderInContraption", "", "context", "Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;", "renderWorld", "Lcom/simibubi/create/foundation/virtualWorld/VirtualRenderWorld;", "matrices", "Lcom/simibubi/create/content/contraptions/render/ContraptionMatrices;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "createenchantablemachinery"})
    public static final class Companion {
        private Companion() {
        }

        public final void renderInContraption(@NotNull MovementContext context, @NotNull VirtualRenderWorld renderWorld, @NotNull ContraptionMatrices matrices, @NotNull MultiBufferSource buffer) {
            boolean shouldAnimate;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)renderWorld, (String)"renderWorld");
            Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            BlockState state = context.state;
            Direction facing = (Direction)state.getValue((Property)SawBlock.FACING);
            Vec3 facingVec = (Vec3)context.rotation.apply(Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)SawBlock.FACING)).getNormal()));
            Direction closestToFacing = Direction.getNearest((double)facingVec.x, (double)facingVec.y, (double)facingVec.z);
            boolean horizontal = closestToFacing.getAxis().isHorizontal();
            boolean backwards = VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)facing.getOpposite());
            boolean moving = !(context.getAnimationSpeed() == 0.0f);
            boolean bl = shouldAnimate = context.contraption.stalled && horizontal || !context.contraption.stalled && !backwards && moving;
            SuperByteBuffer superBuffer = SawBlock.isHorizontal((BlockState)state) ? (shouldAnimate ? CachedBuffers.partial((PartialModel)AllPartialModels.SAW_BLADE_HORIZONTAL_ACTIVE, (BlockState)state) : CachedBuffers.partial((PartialModel)AllPartialModels.SAW_BLADE_HORIZONTAL_INACTIVE, (BlockState)state)) : (shouldAnimate ? CachedBuffers.partial((PartialModel)AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE, (BlockState)state) : CachedBuffers.partial((PartialModel)AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE, (BlockState)state));
            SuperByteBuffer enchantedSuperBuffer = CachedBuffers.partial((PartialModel)PartialModelRegistration.getENCHANTABLE_SAW_BLADE(), (BlockState)state);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)superBuffer.transform(matrices.getModel())).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing))).rotateXDegrees(AngleHelper.verticalAngle((Direction)facing));
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)enchantedSuperBuffer.transform(matrices.getModel())).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing))).rotateXDegrees(AngleHelper.verticalAngle((Direction)facing));
            if (!SawBlock.isHorizontal((BlockState)state)) {
                superBuffer.rotateZDegrees((Boolean)state.getValue((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) != false ? 90.0f : 0.0f);
                enchantedSuperBuffer.rotateZDegrees((Boolean)state.getValue((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) != false ? 90.0f : 0.0f);
            }
            ((SuperByteBuffer)superBuffer.uncenter()).light(LevelRenderer.getLightColor((BlockAndTintGetter)((BlockAndTintGetter)renderWorld), (BlockPos)context.localPos)).useLevelLight((BlockAndTintGetter)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), buffer.getBuffer(RenderType.cutoutMipped()));
            SheetedDecalTextureGenerator consumer = new SheetedDecalTextureGenerator(buffer.getBuffer(CustomRenderType.Companion.getGLINT()), matrices.getModel().last(), 0.007125f);
            ((SuperByteBuffer)enchantedSuperBuffer.uncenter()).light(LevelRenderer.getLightColor((BlockAndTintGetter)((BlockAndTintGetter)renderWorld), (BlockPos)context.localPos)).useLevelLight((BlockAndTintGetter)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), (VertexConsumer)consumer);
            if (!VisualizationManager.supportsVisualization((LevelAccessor)((LevelAccessor)context.world)) && ((Boolean)CemConfig.Companion.getCONFIG().getRenderGlint().get()).booleanValue()) {
                PoseStack poseStack = matrices.getModelViewProjection();
                Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"getModelViewProjection(...)");
                PoseStackUtilKt.use((PoseStack)poseStack, () -> Companion.renderInContraption$lambda$0(matrices, context, consumer));
            }
        }

        private static final Unit renderInContraption$lambda$0(ContraptionMatrices $matrices, MovementContext $context, SheetedDecalTextureGenerator $consumer) {
            TransformStack.of((PoseStack)$matrices.getModelViewProjection()).translate((Vec3i)$context.localPos);
            Minecraft.getInstance().getBlockRenderer().renderBatched($context.state, $context.localPos, (BlockAndTintGetter)$context.world, $matrices.getModelViewProjection(), (VertexConsumer)$consumer, true, RANDOM);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

