/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.saw;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.content.kinetics.saw.TreeCutter;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.cotrin8672.cem.content.block.EnchantableBlockEntity;
import io.github.cotrin8672.cem.content.block.EnchantableBlockEntityDelegate;
import io.github.cotrin8672.cem.mixin.SawBlockEntityMixin;
import io.github.cotrin8672.cem.registry.BlockEntityRegistration;
import io.github.cotrin8672.cem.util.AbstractBlockBreakQueueExtensionKt;
import io.github.cotrin8672.cem.util.BlockEntityExtensionKt;
import io.github.cotrin8672.cem.util.EnchantedItemFactory;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0001?B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0016J\u001a\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030%0$0#H\u0002J\u001e\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020'H\u0016J \u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020'H\u0014J \u00102\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020'H\u0016J\u0017\u00103\u001a\u00020\u00102\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0096\u0001J\t\u00107\u001a\u000208H\u0096\u0001J\u0019\u00109\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u000200H\u0096\u0001J\u0011\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u000208H\u0096\u0001J\u0019\u0010>\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020.2\u0006\u0010;\u001a\u000200H\u0096\u0001R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006@"}, d2={"Lio/github/cotrin8672/cem/content/block/saw/EnchantableSawBlockEntity;", "Lcom/simibubi/create/content/kinetics/saw/SawBlockEntity;", "Lio/github/cotrin8672/cem/content/block/EnchantableBlockEntity;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "filtering", "Lcom/simibubi/create/foundation/blockEntity/behaviour/filtering/FilteringBehaviour;", "getFiltering", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/filtering/FilteringBehaviour;", "value", "", "recipeIndex", "getRecipeIndex", "()I", "setRecipeIndex", "(I)V", "cuttingRecipesKey", "", "getCuttingRecipesKey", "()Ljava/lang/Object;", "getBreakSpeed", "", "onBlockBroken", "", "stateToBreak", "start", "inserted", "Lnet/minecraft/world/item/ItemStack;", "getRecipes", "", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "Lnet/minecraft/world/item/crafting/Recipe;", "addToGoggleTooltip", "", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "isPlayerSneaking", "read", "compound", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "clientPacket", "write", "getEnchantmentLevel", "enchantment", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/enchantment/Enchantment;", "getEnchantments", "Lnet/minecraft/world/item/enchantment/ItemEnchantments;", "readEnchantments", "tag", "provider", "setEnchantment", "enchantments", "writeEnchantments", "Companion", "createenchantablemachinery"})
public final class EnchantableSawBlockEntity
extends SawBlockEntity
implements EnchantableBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ EnchantableBlockEntityDelegate $$delegate_0;

    public EnchantableSawBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.$$delegate_0 = new EnchantableBlockEntityDelegate();
    }

    private final FilteringBehaviour getFiltering() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SawBlockEntityMixin");
        FilteringBehaviour filteringBehaviour = ((SawBlockEntityMixin)((Object)this)).getFiltering();
        Intrinsics.checkNotNullExpressionValue((Object)filteringBehaviour, (String)"getFiltering(...)");
        return filteringBehaviour;
    }

    private final int getRecipeIndex() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SawBlockEntityMixin");
        return ((SawBlockEntityMixin)((Object)this)).getRecipeIndex();
    }

    private final void setRecipeIndex(int value) {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SawBlockEntityMixin");
        ((SawBlockEntityMixin)((Object)this)).setRecipeIndex(value);
    }

    private final Object getCuttingRecipesKey() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type io.github.cotrin8672.cem.mixin.SawBlockEntityMixin");
        Object object = ((SawBlockEntityMixin)((Object)this)).getCuttingRecipesKey();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCuttingRecipesKey(...)");
        return object;
    }

    protected float getBreakSpeed() {
        BlockEntity blockEntity = (BlockEntity)this;
        ResourceKey resourceKey = Registries.ENCHANTMENT;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"ENCHANTMENT");
        Holder.Reference efficiency = BlockEntityExtensionKt.holderLookup(blockEntity, resourceKey).getOrThrow(Enchantments.EFFICIENCY);
        Intrinsics.checkNotNull((Object)efficiency);
        int efficiencyLevel = this.getEnchantmentLevel((Holder<Enchantment>)((Holder)efficiency));
        return super.getBreakSpeed() * (float)(efficiencyLevel + 1);
    }

    public void onBlockBroken(@NotNull BlockState stateToBreak) {
        Intrinsics.checkNotNullParameter((Object)stateToBreak, (String)"stateToBreak");
        Optional optional = TreeCutter.findDynamicTree((Block)stateToBreak.getBlock(), (BlockPos)this.breakingPos);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findDynamicTree(...)");
        Optional dynamicTree = optional;
        if (dynamicTree.isPresent()) {
            Object t = dynamicTree.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            AbstractBlockBreakQueueExtensionKt.destroyBlocks((AbstractBlockBreakQueue)t, BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), EnchantedItemFactory.INSTANCE.getPickaxeItemStack(this.getEnchantments()), (Function2<? super BlockPos, ? super ItemStack, Unit>)((Function2)new Function2<BlockPos, ItemStack, Unit>((Object)this){

                public final void invoke(BlockPos p0, ItemStack p1) {
                    ((EnchantableSawBlockEntity)this.receiver).dropItemFromCutTree(p0, p1);
                }
            }));
            return;
        }
        Vec3 vec = VecHelper.offsetRandomly((Vec3)VecHelper.getCenterOf((Vec3i)((Vec3i)this.breakingPos)), (RandomSource)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)this)).random, (float)0.125f);
        BlockHelper.destroyBlock((Level)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), (BlockPos)this.breakingPos, (float)1.0f, arg_0 -> EnchantableSawBlockEntity.onBlockBroken$lambda$0(this, vec, arg_0));
        TreeCutter.Tree tree = TreeCutter.findTree((BlockGetter)((BlockGetter)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this)), (BlockPos)this.breakingPos, (BlockState)stateToBreak);
        Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"findTree(...)");
        AbstractBlockBreakQueue abstractBlockBreakQueue = (AbstractBlockBreakQueue)tree;
        Level level = BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this);
        ItemEnchantments itemEnchantments = (ItemEnchantments)this.components().get(DataComponents.ENCHANTMENTS);
        if (itemEnchantments == null) {
            itemEnchantments = ItemEnchantments.EMPTY;
        }
        ItemEnchantments itemEnchantments2 = itemEnchantments;
        Intrinsics.checkNotNull((Object)itemEnchantments2);
        AbstractBlockBreakQueueExtensionKt.destroyBlocks(abstractBlockBreakQueue, level, EnchantedItemFactory.INSTANCE.getPickaxeItemStack(itemEnchantments2), (Function2<? super BlockPos, ? super ItemStack, Unit>)((Function2)new Function2<BlockPos, ItemStack, Unit>((Object)this){

            public final void invoke(BlockPos p0, ItemStack p1) {
                ((EnchantableSawBlockEntity)this.receiver).dropItemFromCutTree(p0, p1);
            }
        }));
    }

    public void start(@NotNull ItemStack inserted) {
        Recipe recipe;
        Intrinsics.checkNotNullParameter((Object)inserted, (String)"inserted");
        if (!this.canProcess()) {
            return;
        }
        if (this.inventory.isEmpty()) {
            return;
        }
        if (BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)this)).isClientSide && !this.isVirtual()) {
            return;
        }
        List<RecipeHolder<Recipe<?>>> recipes = this.getRecipes();
        boolean valid = !((Collection)recipes).isEmpty();
        BlockEntity blockEntity = (BlockEntity)this;
        ResourceKey resourceKey = Registries.ENCHANTMENT;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"ENCHANTMENT");
        Holder.Reference efficiency = BlockEntityExtensionKt.holderLookup(blockEntity, resourceKey).getOrThrow(Enchantments.EFFICIENCY);
        Intrinsics.checkNotNull((Object)efficiency);
        int efficiencyLevel = this.getEnchantmentLevel((Holder<Enchantment>)((Holder)efficiency));
        float efficiencyLevelModifier = Math.max(0.1f, 1.0f - (float)efficiencyLevel * 0.1f);
        float time = (float)50 * efficiencyLevelModifier;
        if (recipes.isEmpty()) {
            this.inventory.remainingTime = this.inventory.recipeDuration = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        if (valid) {
            int n = this.getRecipeIndex();
            this.setRecipeIndex(n + 1);
            if (this.getRecipeIndex() >= recipes.size()) {
                this.setRecipeIndex(0);
            }
        }
        if ((recipe = recipes.get(this.getRecipeIndex()).value()) instanceof CuttingRecipe) {
            time = (float)((CuttingRecipe)recipe).getProcessingDuration() * efficiencyLevelModifier;
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = time * Math.max(1.0f, (float)inserted.getCount() / 5.0f);
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    private final List<RecipeHolder<? extends Recipe<?>>> getRecipes() {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), (ItemStack)this.inventory.getStackInSlot(0), (RecipeType)AllRecipeTypes.CUTTING.getType(), CuttingRecipe.class);
        if (assemblyRecipe.isPresent() && this.getFiltering().test(((CuttingRecipe)((RecipeHolder)assemblyRecipe.get()).value()).getResultItem((HolderLookup.Provider)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this).registryAccess()))) {
            ImmutableList immutableList = ImmutableList.of(assemblyRecipe.get());
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
            return (List)immutableList;
        }
        RecipeType[] recipeTypeArray = new RecipeType[]{AllRecipeTypes.CUTTING.getType(), (Boolean)AllConfigs.server().recipes.allowStonecuttingOnSaw.get() != false ? RecipeType.STONECUTTING : null};
        Predicate types = RecipeConditions.isOfType((RecipeType[])recipeTypeArray);
        List startedSearch = RecipeFinder.get((Object)this.getCuttingRecipesKey(), (Level)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this), (Predicate)types);
        List<RecipeHolder<? extends Recipe<?>>> list = startedSearch.stream().filter(RecipeConditions.outputMatchesFilter((FilteringBehaviour)this.getFiltering())).filter(RecipeConditions.firstIngredientMatches((ItemStack)this.inventory.getStackInSlot(0))).filter(arg_0 -> EnchantableSawBlockEntity.getRecipes$lambda$2(EnchantableSawBlockEntity::getRecipes$lambda$1, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    public boolean addToGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.getEnchantments().entrySet().isEmpty()) {
            return false;
        }
        for (Object2IntMap.Entry instance : this.getEnchantments().entrySet()) {
            CreateLang.text((String)Strings.repeat((char)' ', (int)0)).add(Enchantment.getFullname((Holder)((Holder)instance.getKey()), (int)instance.getIntValue())).forGoggles(tooltip);
        }
        return true;
    }

    protected void read(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider registries, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        this.readEnchantments(compound, registries);
        super.read(compound, registries, clientPacket);
    }

    public void write(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider registries, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        this.writeEnchantments(compound, registries);
        super.write(compound, registries, clientPacket);
    }

    @Override
    @NotNull
    public ItemEnchantments getEnchantments() {
        return this.$$delegate_0.getEnchantments();
    }

    @Override
    public void setEnchantment(@NotNull ItemEnchantments enchantments) {
        Intrinsics.checkNotNullParameter((Object)enchantments, (String)"enchantments");
        this.$$delegate_0.setEnchantment(enchantments);
    }

    @Override
    public int getEnchantmentLevel(@NotNull Holder<Enchantment> enchantment) {
        Intrinsics.checkNotNullParameter(enchantment, (String)"enchantment");
        return this.$$delegate_0.getEnchantmentLevel(enchantment);
    }

    @Override
    public void readEnchantments(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.$$delegate_0.readEnchantments(tag, provider);
    }

    @Override
    public void writeEnchantments(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.$$delegate_0.writeEnchantments(tag, provider);
    }

    private static final void onBlockBroken$lambda$0(EnchantableSawBlockEntity this$0, Vec3 $vec, ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.isEmpty()) {
            return;
        }
        if (!BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this$0).getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            return;
        }
        if (BlockEntityExtensionKt.getNonNullLevel((BlockEntity)((BlockEntity)this$0)).restoringBlockSnapshots) {
            return;
        }
        ItemEntity itementity = new ItemEntity(BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this$0), $vec.x, $vec.y, $vec.z, stack);
        itementity.setDefaultPickUpDelay();
        itementity.setDeltaMovement(Vec3.ZERO);
        BlockEntityExtensionKt.getNonNullLevel((BlockEntity)this$0).addFreshEntity((Entity)itementity);
    }

    private static final boolean getRecipes$lambda$1(RecipeHolder r) {
        return !AllRecipeTypes.shouldIgnoreInAutomation((RecipeHolder)r);
    }

    private static final boolean getRecipes$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/github/cotrin8672/cem/content/block/saw/EnchantableSawBlockEntity$Companion;", "", "<init>", "()V", "registerCapabilities", "", "event", "Lnet/neoforged/neoforge/capabilities/RegisterCapabilitiesEvent;", "createenchantablemachinery"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerCapabilities(@NotNull RegisterCapabilitiesEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityRegistration.INSTANCE.getENCHANTABLE_MECHANICAL_SAW().get(), (arg_0, arg_1) -> Companion.registerCapabilities$lambda$1(Companion::registerCapabilities$lambda$0, arg_0, arg_1));
        }

        private static final IItemHandler registerCapabilities$lambda$0(SawBlockEntity be, Direction context) {
            Intrinsics.checkNotNullParameter((Object)be, (String)"be");
            if (context != Direction.DOWN) {
                return (IItemHandler)be.inventory;
            }
            return null;
        }

        private static final IItemHandler registerCapabilities$lambda$1(Function2 $tmp0, Object p0, Direction p1) {
            return (IItemHandler)$tmp0.invoke(p0, (Object)p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

