/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.energy.WireType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LocalNode {
    public static final String NODES = "nodes";
    public static final String ID = "id";
    public static final String OTHER = "other";
    public static final String TYPE = "type";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String Z = "z";
    private final BlockEntity entity;
    private final int index;
    private final int otherIndex;
    private final WireType type;
    private Vec3i relativePos;
    private boolean invalid = false;

    public LocalNode(BlockEntity entity, int index, int other, WireType type, BlockPos position) {
        this.entity = entity;
        this.index = index;
        this.otherIndex = other;
        this.type = type;
        this.relativePos = position.subtract((Vec3i)entity.getBlockPos());
    }

    public LocalNode(BlockEntity entity, CompoundTag tag) {
        this.entity = entity;
        this.index = tag.getInt(ID);
        this.otherIndex = tag.getInt(OTHER);
        this.type = WireType.fromIndex(tag.getInt(TYPE));
        this.relativePos = new Vec3i(tag.getInt(X), tag.getInt(Y), tag.getInt(Z));
    }

    public void write(CompoundTag tag) {
        tag.putInt(ID, this.index);
        tag.putInt(OTHER, this.otherIndex);
        tag.putInt(TYPE, this.type.getIndex());
        tag.putInt(X, this.relativePos.getX());
        tag.putInt(Y, this.relativePos.getY());
        tag.putInt(Z, this.relativePos.getZ());
    }

    public void updateRelative(NodeRotation rotation) {
        this.relativePos = rotation.updateRelative(this.relativePos);
    }

    public int getIndex() {
        return this.index;
    }

    public int getOtherIndex() {
        return this.otherIndex;
    }

    public WireType getType() {
        return this.type;
    }

    public Vec3i getRelativePos() {
        return this.relativePos;
    }

    public BlockPos getPos() {
        return this.entity.getBlockPos().offset(this.relativePos);
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void invalid() {
        this.invalid = true;
    }
}

