/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.datagen.RecipeProvider;

import com.mrh0.createaddition.datagen.RecipeBuilders.CARollingRecipeBuilder;
import com.mrh0.createaddition.index.CAItems;
import com.mrh0.createaddition.index.CARecipes;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.recipe.ProcessingRecipeGen;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CARollingRecipeProvider
extends ProcessingRecipeGen {
    public static final IRecipeTypeInfo recipeType = new IRecipeTypeInfo(){

        public ResourceLocation getId() {
            return CARecipes.ROLLING.getId();
        }

        public <T extends RecipeSerializer<?>> T getSerializer() {
            return (T)((RecipeSerializer)CARecipes.ROLLING.get());
        }

        public <V extends RecipeInput, R extends Recipe<V>> RecipeType<R> getType() {
            return CARecipes.ROLLING_TYPE.get();
        }
    };
    private final HolderLookup.Provider provider;

    public CARollingRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
        try {
            this.provider = registries.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void metalRolling(@NotNull RecipeOutput output, Item rod, Item wire, String metal) {
        CARollingRecipeBuilder.rolling(rod, 2).require((TagKey<Item>)AllTags.commonItemTag((String)("ingots/" + metal))).save(output, metal + "_ingot");
        CARollingRecipeBuilder.rolling(wire, 2).require((TagKey<Item>)AllTags.commonItemTag((String)("plates/" + metal))).save(output, metal + "_plate");
    }

    protected void buildRecipes(@NotNull RecipeOutput output) {
        this.metalRolling(output, (Item)CAItems.COPPER_ROD.get(), (Item)CAItems.COPPER_WIRE.get(), "copper");
        this.metalRolling(output, (Item)CAItems.ELECTRUM_ROD.get(), (Item)CAItems.ELECTRUM_WIRE.get(), "electrum");
        this.metalRolling(output, (Item)CAItems.GOLD_ROD.get(), (Item)CAItems.GOLD_WIRE.get(), "gold");
        this.metalRolling(output, (Item)CAItems.IRON_ROD.get(), (Item)CAItems.IRON_WIRE.get(), "iron");
        CARollingRecipeBuilder.rolling((Item)CAItems.BRASS_ROD.get(), 2).require((TagKey<Item>)AllTags.commonItemTag((String)"ingots/brass")).save(output, "brass_ingot");
        CARollingRecipeBuilder.rolling(CAItems.STRAW).require((ItemLike)Items.BAMBOO).save(output);
    }

    protected IRecipeTypeInfo getRecipeType() {
        return recipeType;
    }
}

