/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader;

import com.hlysine.create_power_loader.CPLBlockEntityTypes;
import com.hlysine.create_power_loader.CPLBlocks;
import com.hlysine.create_power_loader.CPLCommands;
import com.hlysine.create_power_loader.CPLCreativeTabs;
import com.hlysine.create_power_loader.CPLDatagen;
import com.hlysine.create_power_loader.CPLRecipes;
import com.hlysine.create_power_loader.CPLTags;
import com.hlysine.create_power_loader.compat.Mods;
import com.hlysine.create_power_loader.config.CPLConfigs;
import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;

@Mod(value="create_power_loader")
public class CreatePowerLoader {
    public static final String MODID = "create_power_loader";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static IEventBus modEventBus;
    private static final CreateRegistrate REGISTRATE;

    public CreatePowerLoader(IEventBus modBus, ModContainer container) {
        modEventBus = modBus;
        IEventBus neoforgeBus = NeoForge.EVENT_BUS;
        REGISTRATE.registerEventListeners(modBus);
        modEventBus.addListener(this::commonSetup);
        neoforgeBus.addListener(this::registerCommands);
        REGISTRATE.setCreativeTab(CPLCreativeTabs.MAIN);
        CPLTags.register();
        CPLBlocks.register();
        CPLBlockEntityTypes.register();
        CPLCreativeTabs.register(modEventBus);
        ChunkLoadManager.register(modEventBus);
        CPLConfigs.register(container);
        modEventBus.addListener(EventPriority.LOWEST, CPLDatagen::gatherData);
        neoforgeBus.addListener(ChunkLoadManager::onServerWorldTick);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> Mods.JEI.executeIfInstalled(() -> CPLRecipes::register));
    }

    private void registerCommands(RegisterCommandsEvent event) {
        CPLCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static CreateRegistrate getRegistrate() {
        return REGISTRATE;
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    static {
        REGISTRATE = CreateRegistrate.create((String)MODID);
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

