/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.portable_stock_ticker;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.AddressEditBox;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelScreen;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.CraftableBigItemStack;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.ScreenWithStencils;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import de.theidler.create_mobile_packages.compat.Mods;
import de.theidler.create_mobile_packages.compat.jei.CMPJEI;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.ClientScreenStorage;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.HiddenCategoriesPacket;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.PortableStockTicker;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.PortableStockTickerMenu;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.SendPackage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.TextureSheetSegment;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.lwjgl.glfw.GLFW;

public class PortableStockTickerScreen
extends AbstractSimiContainerScreen<PortableStockTickerMenu>
implements ScreenWithStencils {
    private static final AllGuiTextures NUMBERS = AllGuiTextures.NUMBERS;
    private static final AllGuiTextures HEADER = AllGuiTextures.STOCK_KEEPER_REQUEST_HEADER;
    private static final AllGuiTextures BODY = AllGuiTextures.STOCK_KEEPER_REQUEST_BODY;
    private static final AllGuiTextures FOOTER = AllGuiTextures.STOCK_KEEPER_REQUEST_FOOTER;
    public LerpedFloat itemScroll;
    final int rows = 9;
    final int cols = 9;
    final int rowHeight = 20;
    final int colWidth = 20;
    final Couple<Integer> noneHovered = Couple.create((Object)-1, (Object)-1);
    int itemsX;
    int itemsY;
    int orderY;
    int windowWidth;
    int windowHeight;
    public EditBox searchBox;
    public AddressEditBox addressBox;
    int emptyTicks = 0;
    int successTicks = 0;
    Inventory playerInventory;
    public List<List<BigItemStack>> currentItemSource;
    public List<List<BigItemStack>> displayedItems = new ArrayList<List<BigItemStack>>();
    public List<CategoryEntry> categories;
    public List<BigItemStack> itemsToOrder = new ArrayList<BigItemStack>();
    public List<CraftableBigItemStack> recipesToOrder = new ArrayList<CraftableBigItemStack>();
    private boolean scrollHandleActive;
    private InventorySummary forcedEntries;
    private Set<Integer> hiddenCategories;
    public boolean refreshSearchNextTick;
    public boolean moveToTopNextTick;
    private boolean canRequestCraftingPackage = false;

    public PortableStockTickerScreen(PortableStockTickerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.categories = new ArrayList<CategoryEntry>();
        this.itemScroll = LerpedFloat.linear().startWithValue(0.0);
        menu.screenReference = this;
        this.forcedEntries = new InventorySummary();
        this.playerInventory = playerInventory;
        this.hiddenCategories = new HashSet<Integer>(menu.portableStockTicker.hiddenCategoriesByPlayer.getOrDefault(menu.player.getUUID(), List.of()));
    }

    protected void containerTick() {
        boolean allEmpty;
        super.containerTick();
        this.addressBox.tick();
        ClientScreenStorage.tick(((PortableStockTickerMenu)this.menu).portableStockTicker.getFrequency());
        if (this.forcedEntries != null && !this.forcedEntries.isEmpty()) {
            InventorySummary summary = new InventorySummary();
            for (List<BigItemStack> stackList : this.displayedItems) {
                for (BigItemStack stack : stackList) {
                    summary.add(stack);
                }
            }
            for (BigItemStack stack : this.forcedEntries.getStacks()) {
                int limitedAmount = -stack.count - 1;
                int actualAmount = summary.getCountOf(stack.stack);
                if (actualAmount > limitedAmount) continue;
                this.forcedEntries.erase(stack.stack);
            }
        }
        this.emptyTicks = (allEmpty = this.displayedItems.isEmpty()) ? ++this.emptyTicks : 0;
        this.successTicks = this.successTicks > 0 && this.itemsToOrder.isEmpty() ? ++this.successTicks : 0;
        List<List<BigItemStack>> clientStockSnapshot = this.convertToCategoryList(this.removeEmptyStacks(ClientScreenStorage.stacks));
        if (clientStockSnapshot != this.currentItemSource) {
            this.currentItemSource = clientStockSnapshot;
            this.refreshSearchResults(false);
        }
        if (this.refreshSearchNextTick) {
            this.refreshSearchNextTick = false;
            this.refreshSearchResults(this.moveToTopNextTick);
        }
        this.itemScroll.tickChaser();
        if (Math.abs(this.itemScroll.getValue() - this.itemScroll.getChaseTarget()) < 0.0625f) {
            this.itemScroll.setValue((double)this.itemScroll.getChaseTarget());
        }
    }

    private List<BigItemStack> removeEmptyStacks(List<BigItemStack> stacks) {
        stacks.removeIf(bigStack -> bigStack.stack.isEmpty() || bigStack.count <= 0);
        return stacks;
    }

    private List<List<BigItemStack>> convertToCategoryList(List<BigItemStack> stacks) {
        ArrayList<BigItemStack> stacksCopy = new ArrayList<BigItemStack>(stacks);
        ArrayList<List<BigItemStack>> output = new ArrayList<List<BigItemStack>>();
        for (ItemStack filter : ((PortableStockTickerMenu)this.menu).portableStockTicker.categories) {
            ArrayList<BigItemStack> inCategory = new ArrayList<BigItemStack>();
            if (!filter.isEmpty()) {
                FilterItemStack filterItemStack = FilterItemStack.of((ItemStack)filter);
                Iterator iterator = stacksCopy.iterator();
                while (iterator.hasNext()) {
                    BigItemStack bigStack = (BigItemStack)iterator.next();
                    if (!filterItemStack.test(this.playerInventory.player.level(), bigStack.stack)) continue;
                    inCategory.add(bigStack);
                    iterator.remove();
                }
            }
            output.add(inCategory);
        }
        ArrayList<BigItemStack> unsorted = new ArrayList<BigItemStack>(stacksCopy);
        output.add(unsorted);
        return output;
    }

    private void refreshSearchResults(boolean scrollBackUp) {
        if (scrollBackUp) {
            this.itemScroll.startWithValue(0.0);
        }
        this.categories = new ArrayList<CategoryEntry>();
        for (int i = 0; i < ((PortableStockTickerMenu)this.menu).portableStockTicker.categories.size(); ++i) {
            ItemStack stack = ((PortableStockTickerMenu)this.menu).portableStockTicker.categories.get(i);
            CategoryEntry entry = new CategoryEntry(i, stack.isEmpty() ? "" : stack.getHoverName().getString(), 0);
            entry.hidden = this.hiddenCategories.contains(i);
            this.categories.add(entry);
        }
        CategoryEntry unsorted = new CategoryEntry(-1, CreateLang.translate((String)"gui.stock_keeper.unsorted_category", (Object[])new Object[0]).string(), 0);
        unsorted.hidden = this.hiddenCategories.contains(-1);
        this.categories.add(unsorted);
        String valueWithPrefix = this.searchBox.getValue();
        boolean anyItemsInCategory = false;
        if (valueWithPrefix.isBlank() && this.currentItemSource != null) {
            this.displayedItems = new ArrayList<List<BigItemStack>>(this.currentItemSource);
            int categoryY = 0;
            for (int categoryIndex = 0; categoryIndex < this.currentItemSource.size(); ++categoryIndex) {
                this.categories.get((int)categoryIndex).y = categoryY;
                List<BigItemStack> displayedItemsInCategory = this.displayedItems.get(categoryIndex);
                if (displayedItemsInCategory.isEmpty()) continue;
                if (categoryIndex < this.currentItemSource.size() - 1) {
                    anyItemsInCategory = true;
                }
                categoryY += 20;
                if (this.categories.get((int)categoryIndex).hidden) continue;
                categoryY = (int)((double)categoryY + Math.ceil((float)displayedItemsInCategory.size() / 9.0f) * 20.0);
            }
            if (!anyItemsInCategory) {
                this.categories.clear();
            }
            this.updateCraftableAmounts();
            return;
        }
        boolean modSearch = false;
        boolean tagSearch = false;
        modSearch = valueWithPrefix.startsWith("@");
        if (modSearch || (tagSearch = valueWithPrefix.startsWith("#"))) {
            valueWithPrefix = valueWithPrefix.substring(1);
        }
        String value = valueWithPrefix.toLowerCase(Locale.ROOT);
        if (this.currentItemSource == null) {
            return;
        }
        this.displayedItems = new ArrayList<List<BigItemStack>>();
        this.currentItemSource.forEach($ -> this.displayedItems.add(new ArrayList()));
        int categoryY = 0;
        for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
            List<BigItemStack> category = this.currentItemSource.get(categoryIndex);
            this.categories.get((int)categoryIndex).y = categoryY;
            if (this.displayedItems.size() <= categoryIndex) break;
            List<BigItemStack> displayedItemsInCategory = this.displayedItems.get(categoryIndex);
            for (BigItemStack entry : category) {
                ItemStack stack = entry.stack;
                if (modSearch) {
                    if (!BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace().contains(value)) continue;
                    displayedItemsInCategory.add(entry);
                    continue;
                }
                if (tagSearch) {
                    if (!stack.getTags().anyMatch(key -> key.location().toString().contains(value))) continue;
                    displayedItemsInCategory.add(entry);
                    continue;
                }
                if (!stack.getHoverName().getString().toLowerCase(Locale.ROOT).contains(value) && !BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath().contains(value)) continue;
                displayedItemsInCategory.add(entry);
            }
            if (displayedItemsInCategory.isEmpty()) continue;
            if (categoryIndex < this.currentItemSource.size() - 1) {
                anyItemsInCategory = true;
            }
            categoryY += 20;
            if (this.categories.get((int)categoryIndex).hidden) continue;
            categoryY = (int)((double)categoryY + Math.ceil((float)displayedItemsInCategory.size() / 9.0f) * 20.0);
        }
        if (!anyItemsInCategory) {
            this.categories.clear();
        }
        this.updateCraftableAmounts();
    }

    protected void init() {
        int appropriateHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight() - 10;
        appropriateHeight -= Mth.positiveModulo((int)(appropriateHeight - HEADER.getHeight() - FOOTER.getHeight()), (int)BODY.getHeight());
        appropriateHeight = Math.min(appropriateHeight, HEADER.getHeight() + FOOTER.getHeight() + BODY.getHeight() * 17);
        this.windowWidth = 226;
        this.windowHeight = appropriateHeight;
        this.setWindowSize(226, this.windowHeight);
        super.init();
        this.clearWidgets();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.itemsX = x + (this.windowWidth - 180) / 2 + 1;
        this.itemsY = y + 33;
        this.orderY = y + this.windowHeight - 72;
        MutableComponent searchLabel = CreateLang.translateDirect((String)"gui.stock_keeper.search_items", (Object[])new Object[0]);
        this.searchBox = new EditBox((Font)new NoShadowFontWrapper(this.font), x + 71, y + 22, 100, 9, (Component)searchLabel);
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(false);
        this.searchBox.setTextColor(4861233);
        this.addWidget((GuiEventListener)this.searchBox);
        boolean initial = this.addressBox == null;
        String previouslyUsedAddress = initial ? ((PortableStockTickerMenu)this.menu).portableStockTicker.previouslyUsedAddress : this.addressBox.getValue();
        this.addressBox = new AddressEditBox((Screen)this, (Font)new NoShadowFontWrapper(this.font), x + 27, y + this.windowHeight - 36, 92, 10, true);
        this.addressBox.setTextColor(7424576);
        this.addressBox.setValue(previouslyUsedAddress);
        this.addRenderableWidget((GuiEventListener)this.addressBox);
        ClientScreenStorage.manualUpdate(((PortableStockTickerMenu)this.menu).portableStockTicker.getFrequency());
        if (initial) {
            this.playUiSound(SoundEvents.WOOD_HIT, 0.5f, 1.5f);
            this.playUiSound(SoundEvents.BOOK_PAGE_TURN, 1.0f, 1.0f);
            this.syncJEI();
        }
    }

    private Couple<Integer> getHoveredSlot(int x, int y) {
        if (++x < this.itemsX || x >= this.itemsX + 180) {
            return this.noneHovered;
        }
        if (y >= this.orderY && y < this.orderY + 20) {
            int col = (x - this.itemsX) / 20;
            if (this.itemsToOrder.size() <= col || col < 0) {
                return this.noneHovered;
            }
            return Couple.create((Object)-1, (Object)col);
        }
        if (y >= this.orderY - 31 && y < this.orderY - 31 + 20) {
            int jeiX = this.getGuiLeft() + (this.windowWidth - 20 * this.recipesToOrder.size()) / 2 + 1;
            int col = Mth.floorDiv((int)(x - jeiX), (int)20);
            if (this.recipesToOrder.size() > col && col >= 0) {
                return Couple.create((Object)-2, (Object)col);
            }
        }
        if (y < this.getGuiTop() + 16 || y > this.getGuiTop() + this.windowHeight - 80) {
            return this.noneHovered;
        }
        if (!this.itemScroll.settled()) {
            return this.noneHovered;
        }
        int localY = y - this.itemsY;
        for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
            int col;
            CategoryEntry entry;
            CategoryEntry categoryEntry = entry = this.categories.isEmpty() ? new CategoryEntry(0, "", 0) : this.categories.get(categoryIndex);
            if (entry.hidden) continue;
            int row = Mth.floor((float)((float)(localY - (this.categories.isEmpty() ? 4 : 20) - entry.y) / 20.0f + this.itemScroll.getChaseTarget()));
            int slot = row * 9 + (col = (x - this.itemsX) / 20);
            if (slot < 0) {
                return this.noneHovered;
            }
            if (this.displayedItems.get(categoryIndex).size() <= slot) continue;
            return Couple.create((Object)categoryIndex, (Object)slot);
        }
        return this.noneHovered;
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float partialTicks, int mouseX, int mouseY) {
        boolean allEmpty;
        boolean justSent;
        PortableStockTicker pst;
        if (this != this.minecraft.screen) {
            return;
        }
        PoseStack ms = pGuiGraphics.pose();
        float currentScroll = this.itemScroll.getValue(partialTicks);
        Couple<Integer> hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        HEADER.render(pGuiGraphics, x - 15, y);
        y += HEADER.getHeight();
        for (int i = 0; i < (this.windowHeight - HEADER.getHeight() - FOOTER.getHeight()) / BODY.getHeight(); ++i) {
            BODY.render(pGuiGraphics, x - 15, y);
            y += BODY.getHeight();
        }
        FOOTER.render(pGuiGraphics, x - 15, y);
        y = this.getGuiTop();
        if (this.addressBox.getValue().isBlank() && !this.addressBox.isFocused()) {
            pGuiGraphics.drawString(Minecraft.getInstance().font, (Component)CreateLang.translate((String)"gui.stock_keeper.package_adress", (Object[])new Object[0]).style(ChatFormatting.ITALIC).component(), this.addressBox.getX(), this.addressBox.getY(), -3294040, false);
        }
        ms.pushPose();
        ms.translate((float)(x - 50), (float)(y + this.windowHeight - 70), -100.0f);
        ms.scale(3.5f, 3.5f, 3.5f);
        ItemStack pstStack = PortableStockTicker.find(this.playerInventory);
        PortableStockTicker portableStockTicker = pst = pstStack != null ? (PortableStockTicker)pstStack.getItem() : null;
        if (pst != null) {
            GuiGameElement.of((ItemLike)pst).render(pGuiGraphics);
        }
        ms.popPose();
        for (int index = 0; index < 9 && this.itemsToOrder.size() > index; ++index) {
            BigItemStack entry = this.itemsToOrder.get(index);
            boolean isStackHovered = index == (Integer)hoveredSlot.getSecond() && (Integer)hoveredSlot.getFirst() == -1;
            ms.pushPose();
            ms.translate((float)(this.itemsX + index * 20), (float)this.orderY, 0.0f);
            this.renderItemEntry(pGuiGraphics, 1.0f, entry, isStackHovered, true);
            ms.popPose();
        }
        if (this.itemsToOrder.size() > 9) {
            pGuiGraphics.drawString(this.font, (Component)Component.literal((String)("[+" + (this.itemsToOrder.size() - 9) + "]")), x + this.windowWidth - 40, this.orderY + 21, 16316652);
        }
        boolean bl = justSent = this.itemsToOrder.isEmpty() && this.successTicks > 0;
        if (this.isConfirmHovered(mouseX, mouseY) && !justSent) {
            AllGuiTextures.STOCK_KEEPER_REQUEST_SEND_HOVER.render(pGuiGraphics, x + this.windowWidth - 81, y + this.windowHeight - 41);
        }
        MutableComponent headerTitle = Component.translatable((String)"item.create_mobile_packages.portable_stock_ticker.screen_title");
        pGuiGraphics.drawString(this.font, (Component)headerTitle, x + this.windowWidth / 2 - this.font.width((FormattedText)headerTitle) / 2, y + 4, 7424576, false);
        MutableComponent component = CreateLang.translate((String)"gui.stock_keeper.send", (Object[])new Object[0]).component();
        if (justSent) {
            float alpha = Mth.clamp((float)(((float)this.successTicks + partialTicks - 5.0f) / 5.0f), (float)0.0f, (float)1.0f);
            ms.pushPose();
            ms.translate(alpha * alpha * 50.0f, 0.0f, 0.0f);
            if (this.successTicks < 10) {
                pGuiGraphics.drawString(this.font, (Component)component, x + this.windowWidth - 42 - this.font.width((FormattedText)component) / 2, y + this.windowHeight - 35, new Color(0x252525).setAlpha(1.0f - alpha * alpha).getRGB(), false);
            }
            ms.popPose();
        } else {
            pGuiGraphics.drawString(this.font, (Component)component, x + this.windowWidth - 42 - this.font.width((FormattedText)component) / 2, y + this.windowHeight - 35, 0x252525, false);
        }
        if (justSent) {
            MutableComponent msg = CreateLang.translateDirect((String)"gui.stock_keeper.request_sent", (Object[])new Object[0]);
            float alpha = Mth.clamp((float)(((float)this.successTicks + partialTicks - 10.0f) / 5.0f), (float)0.0f, (float)1.0f);
            int msgX = x + this.windowWidth / 2 - (this.font.width((FormattedText)msg) + 10) / 2;
            int msgY = this.orderY + 5;
            if (alpha > 0.0f) {
                int c3 = new Color(9198923).setAlpha(alpha).getRGB();
                int w = this.font.width((FormattedText)msg) + 14;
                AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_L.render(pGuiGraphics, msgX - 8, msgY - 4);
                UIRenderHelper.drawStretched((GuiGraphics)pGuiGraphics, (int)msgX, (int)(msgY - 4), (int)w, (int)16, (int)0, (TextureSheetSegment)AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_M);
                AllGuiTextures.STOCK_KEEPER_REQUEST_BANNER_R.render(pGuiGraphics, msgX + this.font.width((FormattedText)msg) + 10, msgY - 4);
                pGuiGraphics.drawString(this.font, (Component)msg, msgX + 5, msgY, c3, false);
            }
        }
        int itemWindowX = x + 21;
        int itemWindowX2 = itemWindowX + 184;
        int itemWindowY = y + 17;
        int itemWindowY2 = y + this.windowHeight - 80;
        UIRenderHelper.swapAndBlitColor((RenderTarget)this.minecraft.getMainRenderTarget(), (RenderTarget)UIRenderHelper.framebuffer);
        this.startStencil(pGuiGraphics, itemWindowX - 5, itemWindowY, itemWindowX2 - itemWindowX + 10, itemWindowY2 - itemWindowY);
        ms.pushPose();
        ms.translate(0.0f, -currentScroll * 20.0f, 0.0f);
        for (int sliceY = -2; sliceY < this.getMaxScroll() * 20 + this.windowHeight - 72; sliceY += AllGuiTextures.STOCK_KEEPER_REQUEST_BG.getHeight()) {
            if ((float)sliceY - currentScroll * 20.0f < -20.0f || (float)sliceY - currentScroll * 20.0f > (float)(this.windowHeight - 72)) continue;
            AllGuiTextures.STOCK_KEEPER_REQUEST_BG.render(pGuiGraphics, x + 22, y + sliceY + 18);
        }
        AllGuiTextures.STOCK_KEEPER_REQUEST_SEARCH.render(pGuiGraphics, x + 42, this.searchBox.getY() - 5);
        this.searchBox.render(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (this.searchBox.getValue().isBlank() && !this.searchBox.isFocused()) {
            pGuiGraphics.drawString(this.font, this.searchBox.getMessage(), x + this.windowWidth / 2 - this.font.width((FormattedText)this.searchBox.getMessage()) / 2, this.searchBox.getY(), -11915983, false);
        }
        if (allEmpty = this.displayedItems.isEmpty()) {
            Component msg = this.getTroubleshootingMessage();
            float alpha = Mth.clamp((float)(((float)this.emptyTicks - 10.0f) / 5.0f), (float)0.0f, (float)1.0f);
            if (alpha > 0.0f) {
                List split = this.font.split((FormattedText)msg, 160);
                for (int i = 0; i < split.size(); ++i) {
                    FormattedCharSequence sequence = (FormattedCharSequence)split.get(i);
                    int lineWidth = this.font.width(sequence);
                    int n = x + this.windowWidth / 2 - lineWidth / 2 + 1;
                    Objects.requireNonNull(this.font);
                    pGuiGraphics.drawString(this.font, sequence, n, this.itemsY + 20 + 1 + i * (9 + 1), new Color(4861233).setAlpha(alpha).getRGB(), false);
                    int n2 = x + this.windowWidth / 2 - lineWidth / 2;
                    Objects.requireNonNull(this.font);
                    pGuiGraphics.drawString(this.font, sequence, n2, this.itemsY + 20 + i * (9 + 1), new Color(16316652).setAlpha(alpha).getRGB(), false);
                }
            }
        }
        block4: for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
            int categoryY;
            List<BigItemStack> category = this.displayedItems.get(categoryIndex);
            CategoryEntry categoryEntry = this.categories.isEmpty() ? null : this.categories.get(categoryIndex);
            int n = categoryY = this.categories.isEmpty() ? 0 : categoryEntry.y;
            if (category.isEmpty()) continue;
            if (!this.categories.isEmpty()) {
                (categoryEntry.hidden ? AllGuiTextures.STOCK_KEEPER_CATEGORY_HIDDEN : AllGuiTextures.STOCK_KEEPER_CATEGORY_SHOWN).render(pGuiGraphics, this.itemsX, this.itemsY + categoryY + 6);
                pGuiGraphics.drawString(this.font, categoryEntry.name, this.itemsX + 10, this.itemsY + categoryY + 8, 4861233, false);
                pGuiGraphics.drawString(this.font, categoryEntry.name, this.itemsX + 9, this.itemsY + categoryY + 7, 16316652, false);
                if (categoryEntry.hidden) continue;
            }
            for (int index = 0; index < category.size(); ++index) {
                int pY = this.itemsY + categoryY + (this.categories.isEmpty() ? 4 : 20) + index / 9 * 20;
                float cullY = (float)pY - currentScroll * 20.0f;
                if (cullY < (float)y) continue;
                if (cullY > (float)(y + this.windowHeight - 72)) continue block4;
                boolean isStackHovered = index == (Integer)hoveredSlot.getSecond() && categoryIndex == (Integer)hoveredSlot.getFirst();
                BigItemStack entry = category.get(index);
                ms.pushPose();
                ms.translate((float)(this.itemsX + index % 9 * 20), (float)pY, 0.0f);
                this.renderItemEntry(pGuiGraphics, 1.0f, entry, isStackHovered, false);
                ms.popPose();
            }
        }
        ms.popPose();
        this.endStencil();
        int windowH = this.windowHeight - 92;
        int totalH = this.getMaxScroll() * 20 + windowH;
        int barSize = Math.max(5, Mth.floor((float)((float)windowH / (float)totalH * (float)(windowH - 2))));
        if (barSize < windowH - 2) {
            int barX = this.itemsX + 180;
            int barY = y + 15;
            ms.pushPose();
            ms.translate(0.0f, currentScroll * 20.0f / (float)totalH * (float)(windowH - 2), 0.0f);
            AllGuiTextures pad = AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_PAD;
            pGuiGraphics.blit(pad.location, barX, barY, pad.getWidth(), barSize, (float)pad.getStartX(), (float)pad.getStartY(), pad.getWidth(), pad.getHeight(), 256, 256);
            AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_TOP.render(pGuiGraphics, barX, barY);
            if (barSize > 16) {
                AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_MID.render(pGuiGraphics, barX, barY + barSize / 2 - 4);
            }
            AllGuiTextures.STOCK_KEEPER_REQUEST_SCROLL_BOT.render(pGuiGraphics, barX, barY + barSize - 5);
            ms.popPose();
        }
        if (this.recipesToOrder.size() > 0) {
            int jeiX = x + (this.windowWidth - 20 * this.recipesToOrder.size()) / 2 + 1;
            int jeiY = this.orderY - 31;
            ms.pushPose();
            ms.translate((float)jeiX, (float)jeiY, 200.0f);
            int xoffset = -3;
            AllGuiTextures.STOCK_KEEPER_REQUEST_BLUEPRINT_LEFT.render(pGuiGraphics, xoffset, -3);
            xoffset += 10;
            for (int i = 0; i <= (this.recipesToOrder.size() - 1) * 5; ++i) {
                AllGuiTextures.STOCK_KEEPER_REQUEST_BLUEPRINT_MIDDLE.render(pGuiGraphics, xoffset, -3);
                xoffset += 4;
            }
            AllGuiTextures.STOCK_KEEPER_REQUEST_BLUEPRINT_RIGHT.render(pGuiGraphics, xoffset, -3);
            for (int index = 0; index < this.recipesToOrder.size(); ++index) {
                CraftableBigItemStack craftableBigItemStack = this.recipesToOrder.get(index);
                boolean isStackHovered = index == (Integer)hoveredSlot.getSecond() && -2 == (Integer)hoveredSlot.getFirst();
                ms.pushPose();
                ms.translate((float)(index * 20), 0.0f, 0.0f);
                this.renderItemEntry(pGuiGraphics, 1.0f, (BigItemStack)craftableBigItemStack, isStackHovered, true);
                ms.popPose();
            }
            ms.popPose();
        }
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)this.minecraft.getMainRenderTarget());
    }

    private int getMaxScroll() {
        int visibleHeight = this.windowHeight - 84;
        int totalRows = 2;
        for (int i = 0; i < this.displayedItems.size(); ++i) {
            List<BigItemStack> list = this.displayedItems.get(i);
            if (list.isEmpty()) continue;
            ++totalRows;
            if (this.categories.size() > i && this.categories.get((int)i).hidden) continue;
            totalRows = (int)((double)totalRows + Math.ceil((float)list.size() / 9.0f));
        }
        int maxScroll = Math.max(0, (totalRows * 20 - visibleHeight + 50) / 20);
        return maxScroll;
    }

    private void renderItemEntry(GuiGraphics graphics, float scale, BigItemStack entry, boolean isStackHovered, boolean isRenderingOrders) {
        int customCount = entry.count;
        if (!isRenderingOrders) {
            BigItemStack order = this.getOrderForItem(entry.stack);
            if (entry.count < 1000000000) {
                int forcedCount = this.forcedEntries.getCountOf(entry.stack);
                if (forcedCount != 0) {
                    customCount = Math.min(customCount, -forcedCount - 1);
                }
                if (order != null) {
                    customCount -= order.count;
                }
                customCount = Math.max(0, customCount);
            }
            AllGuiTextures.STOCK_KEEPER_REQUEST_SLOT.render(graphics, 0, 0);
        }
        boolean craftable = entry instanceof CraftableBigItemStack;
        PoseStack ms = graphics.pose();
        ms.pushPose();
        float scaleFromHover = 1.0f;
        if (isStackHovered) {
            scaleFromHover += 0.075f;
        }
        ms.translate(1.0, 1.0, 0.0);
        ms.translate(9.0, 9.0, 0.0);
        ms.scale(scale, scale, scale);
        ms.scale(scaleFromHover, scaleFromHover, scaleFromHover);
        ms.translate(-9.0, -9.0, 0.0);
        if (customCount != 0 || craftable) {
            GuiGameElement.of((ItemStack)entry.stack).render(graphics);
        }
        ms.popPose();
        ms.pushPose();
        ms.translate(0.0f, 0.0f, 190.0f);
        if (customCount != 0 || craftable) {
            graphics.renderItemDecorations(this.font, entry.stack, 1, 1, "");
        }
        ms.translate(0.0f, 0.0f, 10.0f);
        if (customCount > 1 || craftable) {
            this.drawItemCount(graphics, entry.count, customCount);
        }
        ms.popPose();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawItemCount(GuiGraphics graphics, int count, int customCount) {
        Object text;
        count = customCount;
        Object object = count >= 1000000 ? count / 1000000 + "m" : (count >= 10000 ? count / 1000 + "k" : (count >= 1000 ? (float)(count * 10 / 1000) / 10.0f + "k" : (text = count >= 100 ? "" + count : " " + count)));
        if (count >= 1000000000) {
            text = "+";
        }
        if (((String)text).isBlank()) {
            return;
        }
        int x = (int)Math.floor((double)(-((String)text).length()) * 2.5);
        char[] cArray = ((String)text).toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (true) {
            block11: {
                if (n2 >= n) {
                    return;
                }
                char c = cArray[n2];
                int index = c - 48;
                int xOffset = index * 6;
                int spriteWidth = NUMBERS.getWidth();
                switch (c) {
                    case ' ': {
                        x += 4;
                        break block11;
                    }
                    case '.': {
                        spriteWidth = 3;
                        xOffset = 60;
                        break;
                    }
                    case 'k': {
                        xOffset = 64;
                        break;
                    }
                    case 'm': {
                        spriteWidth = 7;
                        xOffset = 70;
                        break;
                    }
                    case '+': {
                        spriteWidth = 9;
                        xOffset = 84;
                    }
                }
                RenderSystem.enableBlend();
                graphics.blit(PortableStockTickerScreen.NUMBERS.location, 14 + x, 10, 0, (float)(NUMBERS.getStartX() + xOffset), (float)NUMBERS.getStartY(), spriteWidth, NUMBERS.getHeight(), 256, 256);
                x += spriteWidth - 1;
            }
            ++n2;
        }
    }

    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        Couple<Integer> hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        if (hoveredSlot != this.noneHovered) {
            BigItemStack entry;
            boolean orderHovered;
            int slot = (Integer)hoveredSlot.getSecond();
            boolean recipeHovered = (Integer)hoveredSlot.getFirst() == -2;
            boolean bl = orderHovered = (Integer)hoveredSlot.getFirst() == -1;
            BigItemStack bigItemStack = recipeHovered ? (BigItemStack)this.recipesToOrder.get(slot) : (entry = orderHovered ? this.itemsToOrder.get(slot) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get(slot));
            if (recipeHovered) {
                ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>(entry.stack.getTooltipLines(Item.TooltipContext.of((Level)this.minecraft.level), (Player)this.minecraft.player, (TooltipFlag)TooltipFlag.NORMAL));
                if (lines.size() > 0) {
                    lines.set(0, CreateLang.translateDirect((String)"gui.stock_keeper.craft", (Object[])new Object[]{((Component)lines.get(0)).copy()}));
                }
                graphics.renderComponentTooltip(this.font, lines, mouseX, mouseY);
            } else {
                graphics.renderTooltip(this.font, entry.stack, mouseX, mouseY);
            }
        }
        if (this.addressBox.getValue().isBlank() && !this.addressBox.isFocused() && this.addressBox.isHovered()) {
            graphics.renderComponentTooltip(this.font, List.of(CreateLang.translate((String)"gui.factory_panel.restocker_address", (Object[])new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate((String)"gui.schedule.lmb_edit", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
        }
    }

    @Nullable
    private BigItemStack getOrderForItem(ItemStack stack) {
        for (BigItemStack entry : this.itemsToOrder) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)entry.stack)) continue;
            return entry;
        }
        return null;
    }

    private boolean isConfirmHovered(int mouseX, int mouseY) {
        int confirmX = this.getGuiLeft() + 143;
        int confirmY = this.getGuiTop() + this.windowHeight - 39;
        int confirmW = 78;
        int confirmH = 18;
        if (mouseX < confirmX || mouseX >= confirmX + confirmW) {
            return false;
        }
        return mouseY >= confirmY && mouseY < confirmY + confirmH;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        int transfer;
        boolean recipeClicked;
        boolean rmb;
        boolean lmb = pButton == 0;
        boolean bl = rmb = pButton == 1;
        if (rmb && this.searchBox.isMouseOver(pMouseX, pMouseY)) {
            this.searchBox.setValue("");
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
            this.searchBox.setFocused(true);
            this.syncJEI();
            return true;
        }
        if (this.addressBox.isFocused()) {
            if (this.addressBox.isHovered()) {
                return this.addressBox.mouseClicked(pMouseX, pMouseY, pButton);
            }
            this.addressBox.setFocused(false);
        }
        if (this.searchBox.isFocused()) {
            if (this.searchBox.isHovered()) {
                return this.searchBox.mouseClicked(pMouseX, pMouseY, pButton);
            }
            this.searchBox.setFocused(false);
        }
        int barX = this.itemsX + 180 - 1;
        if (this.getMaxScroll() > 0 && lmb && pMouseX > (double)barX && pMouseX <= (double)(barX + 8) && pMouseY > (double)(this.getGuiTop() + 15) && pMouseY < (double)(this.getGuiTop() + this.windowHeight - 82)) {
            this.scrollHandleActive = true;
            if (this.minecraft.isWindowActive()) {
                GLFW.glfwSetInputMode((long)this.minecraft.getWindow().getWindow(), (int)208897, (int)212994);
            }
            return true;
        }
        Couple<Integer> hoveredSlot = this.getHoveredSlot((int)pMouseX, (int)pMouseY);
        if (lmb && this.isConfirmHovered((int)pMouseX, (int)pMouseY)) {
            this.sendIt();
            this.playUiSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
            return true;
        }
        int localY = (int)(pMouseY - (double)this.itemsY);
        if (this.itemScroll.settled() && lmb && !this.categories.isEmpty() && pMouseX >= (double)this.itemsX && pMouseX < (double)(this.itemsX + 180) && pMouseY >= (double)(this.getGuiTop() + 16) && pMouseY <= (double)(this.getGuiTop() + this.windowHeight - 80)) {
            for (int categoryIndex = 0; categoryIndex < this.displayedItems.size(); ++categoryIndex) {
                int indexOf;
                CategoryEntry entry = this.categories.get(categoryIndex);
                if (Mth.floor((float)((float)(localY - entry.y) / 20.0f + this.itemScroll.getChaseTarget())) != 0 || this.displayedItems.get(categoryIndex).isEmpty() || (indexOf = entry.targetBECategory) >= ((PortableStockTickerMenu)this.menu).portableStockTicker.categories.size()) continue;
                if (!entry.hidden) {
                    this.hiddenCategories.add(indexOf);
                    this.playUiSound(SoundEvents.ITEM_FRAME_ROTATE_ITEM, 1.0f, 1.5f);
                } else {
                    this.hiddenCategories.remove(indexOf);
                    this.playUiSound(SoundEvents.ITEM_FRAME_ROTATE_ITEM, 1.0f, 0.675f);
                }
                this.refreshSearchNextTick = true;
                this.moveToTopNextTick = false;
                return true;
            }
        }
        if (hoveredSlot == this.noneHovered || !lmb && !rmb) {
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }
        boolean orderClicked = (Integer)hoveredSlot.getFirst() == -1;
        boolean bl2 = recipeClicked = (Integer)hoveredSlot.getFirst() == -2;
        BigItemStack entry = recipeClicked ? (BigItemStack)this.recipesToOrder.get((Integer)hoveredSlot.getSecond()) : (orderClicked ? this.itemsToOrder.get((Integer)hoveredSlot.getSecond()) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get((Integer)hoveredSlot.getSecond()));
        ItemStack itemStack = entry.stack;
        int n = PortableStockTickerScreen.hasShiftDown() ? itemStack.getMaxStackSize() : (transfer = PortableStockTickerScreen.hasControlDown() ? 10 : 1);
        if (recipeClicked && entry instanceof CraftableBigItemStack) {
            CraftableBigItemStack cbis = (CraftableBigItemStack)entry;
            if (rmb && cbis.count == 0) {
                this.recipesToOrder.remove(cbis);
                return true;
            }
            this.requestCraftable(cbis, rmb ? -transfer : transfer);
            return true;
        }
        BigItemStack existingOrder = this.getOrderForItem(entry.stack);
        if (existingOrder == null) {
            if (this.itemsToOrder.size() >= 9 || rmb) {
                return true;
            }
            existingOrder = new BigItemStack(itemStack.copyWithCount(1), 0);
            this.itemsToOrder.add(existingOrder);
            this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.2f);
            this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 0.8f);
        }
        int current = existingOrder.count;
        if (rmb || orderClicked) {
            existingOrder.count = current - transfer;
            if (existingOrder.count <= 0) {
                this.itemsToOrder.remove(existingOrder);
                this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.8f);
                this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 1.8f);
            }
            return true;
        }
        existingOrder.count = current + Math.min(transfer, entry.count - current);
        return true;
    }

    public void requestCraftable(CraftableBigItemStack cbis, int requestedDifference) {
        boolean takeOrdersAway;
        boolean bl = takeOrdersAway = requestedDifference < 0;
        if (takeOrdersAway) {
            requestedDifference = Math.max(-cbis.count, requestedDifference);
        }
        if (requestedDifference == 0) {
            return;
        }
        InventorySummary availableItems = new InventorySummary();
        for (List<BigItemStack> list : this.displayedItems) {
            for (BigItemStack stack2 : list) {
                availableItems.add(stack2);
            }
        }
        Function<ItemStack, Integer> countModifier = stack -> {
            BigItemStack ordered = this.getOrderForItem((ItemStack)stack);
            return ordered == null ? 0 : -ordered.count;
        };
        if (takeOrdersAway) {
            availableItems = new InventorySummary();
            for (BigItemStack ordered : this.itemsToOrder) {
                availableItems.add(ordered.stack, ordered.count);
            }
            countModifier = stack -> 0;
        }
        Pair<Integer, List<List<BigItemStack>>> pair = this.maxCraftable(cbis, availableItems, countModifier, takeOrdersAway ? -1 : 9 - this.itemsToOrder.size());
        int outputCount = cbis.getOutputCount(this.playerInventory.player.level());
        int adjustToRecipeAmount = Mth.ceil((float)((float)Math.abs(requestedDifference) / (float)outputCount)) * outputCount;
        int maxCraftable = Math.min(adjustToRecipeAmount, (Integer)pair.getFirst());
        if (maxCraftable == 0) {
            return;
        }
        cbis.count = cbis.count + (takeOrdersAway ? -maxCraftable : maxCraftable);
        List validEntriesByIngredient = (List)pair.getSecond();
        block3: for (List list : validEntriesByIngredient) {
            int remaining = maxCraftable / outputCount;
            for (BigItemStack entry : list) {
                if (remaining <= 0) continue block3;
                int toTransfer = Math.min(remaining, entry.count);
                BigItemStack order = this.getOrderForItem(entry.stack);
                if (takeOrdersAway) {
                    if (order != null) {
                        order.count -= toTransfer;
                        if (order.count == 0) {
                            this.itemsToOrder.remove(order);
                        }
                    }
                } else {
                    if (order == null) {
                        order = new BigItemStack(entry.stack.copyWithCount(1), 0);
                        this.itemsToOrder.add(order);
                    }
                    order.count += toTransfer;
                }
                remaining -= entry.count;
            }
        }
        this.updateCraftableAmounts();
    }

    private void updateCraftableAmounts() {
        InventorySummary usedItems = new InventorySummary();
        InventorySummary availableItems = new InventorySummary();
        for (BigItemStack ordered : this.itemsToOrder) {
            availableItems.add(ordered.stack, ordered.count);
        }
        for (CraftableBigItemStack cbis : this.recipesToOrder) {
            Pair<Integer, List<List<BigItemStack>>> craftingResult = this.maxCraftable(cbis, availableItems, stack -> -usedItems.getCountOf(stack), -1);
            int maxCraftable = (Integer)craftingResult.getFirst();
            List validEntriesByIngredient = (List)craftingResult.getSecond();
            int outputCount = cbis.getOutputCount(this.playerInventory.player.level());
            cbis.count = Math.min(cbis.count, maxCraftable);
            block2: for (List list : validEntriesByIngredient) {
                int remaining = cbis.count / outputCount;
                for (BigItemStack entry : list) {
                    if (remaining <= 0) continue block2;
                    usedItems.add(entry.stack, Math.min(remaining, entry.count));
                    remaining -= entry.count;
                }
            }
        }
        this.canRequestCraftingPackage = false;
        for (BigItemStack ordered : this.itemsToOrder) {
            if (usedItems.getCountOf(ordered.stack) == ordered.count) continue;
            return;
        }
        this.canRequestCraftingPackage = true;
    }

    private Pair<Integer, List<List<BigItemStack>>> maxCraftable(CraftableBigItemStack cbis, InventorySummary summary, Function<ItemStack, Integer> countModifier, int newTypeLimit) {
        List ingredients = cbis.getIngredients();
        ArrayList<List<BigItemStack>> validEntriesByIngredient = new ArrayList<List<BigItemStack>>();
        ArrayList<ItemStack> visited = new ArrayList<ItemStack>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            ArrayList<BigItemStack> arrayList = new ArrayList<BigItemStack>();
            for (List list : summary.getItemMap().values()) {
                block2: for (BigItemStack entry2 : list) {
                    if (!ingredient.test(entry2.stack)) continue;
                    BigItemStack asBis = new BigItemStack(entry2.stack, summary.getCountOf(entry2.stack) + countModifier.apply(entry2.stack));
                    if (asBis.count > 0) {
                        arrayList.add(asBis);
                    }
                    for (ItemStack visitedStack : visited) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)visitedStack, (ItemStack)entry2.stack)) continue;
                        visitedStack.grow(1);
                        continue block2;
                    }
                    visited.add(entry2.stack.copyWithCount(1));
                }
            }
            if (arrayList.isEmpty()) {
                return Pair.of((Object)0, List.of());
            }
            Collections.sort(arrayList, (bis1, bis2) -> -Integer.compare(summary.getCountOf(bis1.stack), summary.getCountOf(bis2.stack)));
            validEntriesByIngredient.add(arrayList);
        }
        if (newTypeLimit != -1) {
            int toRemove = (int)validEntriesByIngredient.stream().flatMap(l -> l.stream()).filter(entry -> this.getOrderForItem(entry.stack) == null).distinct().count() - newTypeLimit;
            for (int i = 0; i < toRemove; ++i) {
                this.removeLeastEssentialItemStack(validEntriesByIngredient);
            }
        }
        for (ItemStack visitedItem : visited) {
            for (List list : validEntriesByIngredient) {
                for (BigItemStack entry3 : list) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)entry3.stack, (ItemStack)visitedItem)) continue;
                    entry3.count /= visitedItem.getCount();
                }
            }
        }
        int minCount = Integer.MAX_VALUE;
        for (List list : validEntriesByIngredient) {
            int n = 0;
            for (BigItemStack entry2 : list) {
                n += entry2.count;
            }
            minCount = Math.min(n, minCount);
        }
        if (minCount == 0) {
            return Pair.of((Object)0, List.of());
        }
        int outputCount = cbis.getOutputCount(this.playerInventory.player.level());
        return Pair.of((Object)(minCount * outputCount), validEntriesByIngredient);
    }

    private void removeLeastEssentialItemStack(List<List<BigItemStack>> validIngredients) {
        List<BigItemStack> longest = null;
        int most = 0;
        for (List<BigItemStack> list : validIngredients) {
            int count = (int)list.stream().filter(entry -> this.getOrderForItem(entry.stack) == null).count();
            if (longest != null && count <= most) continue;
            longest = list;
            most = count;
        }
        if (longest == null || longest.isEmpty()) {
            return;
        }
        BigItemStack chosen = null;
        for (int i = 0; i < longest.size(); ++i) {
            BigItemStack entry2 = longest.get(longest.size() - 1 - i);
            if (this.getOrderForItem(entry2.stack) != null) continue;
            chosen = entry2;
            break;
        }
        for (List<BigItemStack> list : validIngredients) {
            list.remove(chosen);
        }
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 && this.scrollHandleActive) {
            this.scrollHandleActive = false;
            if (this.minecraft.isWindowActive()) {
                GLFW.glfwSetInputMode((long)this.minecraft.getWindow().getWindow(), (int)208897, (int)212993);
            }
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean noHover;
        if (this.addressBox.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        Couple<Integer> hoveredSlot = this.getHoveredSlot((int)mouseX, (int)mouseY);
        boolean bl = noHover = hoveredSlot == this.noneHovered;
        if (noHover || (Integer)hoveredSlot.getFirst() >= 0 && !PortableStockTickerScreen.hasShiftDown() && this.getMaxScroll() != 0) {
            int maxScroll = this.getMaxScroll();
            int direction = (int)(Math.ceil(Math.abs(scrollY)) * -Math.signum(scrollY));
            float newTarget = Mth.clamp((int)Math.round(this.itemScroll.getChaseTarget() + (float)direction), (int)0, (int)maxScroll);
            this.itemScroll.chase((double)newTarget, 0.5, LerpedFloat.Chaser.EXP);
            return true;
        }
        try {
            BigItemStack existingOrder;
            boolean recipeClicked;
            boolean orderClicked = (Integer)hoveredSlot.getFirst() == -1;
            boolean bl2 = recipeClicked = (Integer)hoveredSlot.getFirst() == -2;
            BigItemStack entry = recipeClicked ? (BigItemStack)this.recipesToOrder.get((Integer)hoveredSlot.getSecond()) : (orderClicked ? this.itemsToOrder.get((Integer)hoveredSlot.getSecond()) : this.displayedItems.get((Integer)hoveredSlot.getFirst()).get((Integer)hoveredSlot.getSecond()));
            boolean remove = scrollY < 0.0;
            int transfer = Mth.ceil((double)Math.abs(scrollY)) * (PortableStockTickerScreen.hasControlDown() ? 10 : 1);
            BigItemStack bigItemStack = existingOrder = orderClicked ? entry : this.getOrderForItem(entry.stack);
            if (existingOrder == null) {
                if (this.itemsToOrder.size() >= 9 || remove) {
                    return true;
                }
                existingOrder = new BigItemStack(entry.stack.copyWithCount(1), 0);
                this.itemsToOrder.add(existingOrder);
                this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.2f);
                this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 0.8f);
            }
            int current = existingOrder.count;
            if (remove) {
                existingOrder.count = current - transfer;
                if (existingOrder.count <= 0) {
                    this.itemsToOrder.remove(existingOrder);
                    this.playUiSound(SoundEvents.WOOL_STEP, 0.75f, 1.8f);
                    this.playUiSound(SoundEvents.BAMBOO_WOOD_STEP, 0.75f, 1.8f);
                } else if (existingOrder.count != current) {
                    this.playUiSound(AllSoundEvents.SCROLL_VALUE.getMainEvent(), 0.25f, 1.2f);
                }
                return true;
            }
            InventorySummary summary = new InventorySummary();
            for (List<BigItemStack> stackList : this.displayedItems) {
                for (BigItemStack stack : stackList) {
                    summary.add(stack);
                }
            }
            existingOrder.count = current + Math.min(transfer, summary.getCountOf(entry.stack) - current);
            if (existingOrder.count != current && current != 0) {
                this.playUiSound(AllSoundEvents.SCROLL_VALUE.getMainEvent(), 0.25f, 1.2f);
            }
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton != 0 || !this.scrollHandleActive) {
            return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        Window window = this.minecraft.getWindow();
        double scaleX = (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
        double scaleY = (double)window.getGuiScaledHeight() / (double)window.getScreenHeight();
        int windowH = this.windowHeight - 92;
        int totalH = this.getMaxScroll() * 20 + windowH;
        int barSize = Math.max(5, Mth.floor((float)((float)windowH / (float)totalH * (float)(windowH - 2))));
        int minY = this.getGuiTop() + 15 + barSize / 2;
        int maxY = this.getGuiTop() + 15 + windowH - barSize / 2;
        if (barSize >= windowH - 2) {
            return true;
        }
        int barX = this.itemsX + 180;
        double target = (pMouseY - (double)this.getGuiTop() - 15.0 - (double)barSize / 2.0) * (double)totalH / (double)(windowH - 2) / 20.0;
        this.itemScroll.chase(Mth.clamp((double)target, (double)0.0, (double)this.getMaxScroll()), 0.8, LerpedFloat.Chaser.EXP);
        if (this.minecraft.isWindowActive()) {
            double forceX = (double)(barX + 2) / scaleX;
            double forceY = Mth.clamp((double)pMouseY, (double)minY, (double)maxY) / scaleY;
            GLFW.glfwSetCursorPos((long)window.getWindow(), (double)forceX, (double)forceY);
        }
        return true;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (this.addressBox.isFocused() && this.addressBox.charTyped(pCodePoint, pModifiers)) {
            return true;
        }
        String s = this.searchBox.getValue();
        if (!this.searchBox.charTyped(pCodePoint, pModifiers)) {
            return false;
        }
        if (!Objects.equals(s, this.searchBox.getValue())) {
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
            this.syncJEI();
        }
        return true;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 257 && this.searchBox.isFocused()) {
            this.searchBox.setFocused(false);
            return true;
        }
        if (pKeyCode == 257 && PortableStockTickerScreen.hasShiftDown()) {
            this.sendIt();
            return true;
        }
        if (this.addressBox.isFocused() && this.addressBox.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        String s = this.searchBox.getValue();
        if (!this.searchBox.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return this.searchBox.isFocused() && this.searchBox.isVisible() && pKeyCode != 256 || super.keyPressed(pKeyCode, pScanCode, pModifiers);
        }
        if (!Objects.equals(s, this.searchBox.getValue())) {
            this.refreshSearchNextTick = true;
            this.moveToTopNextTick = true;
            this.syncJEI();
        }
        return true;
    }

    private void sendIt() {
        if (this.itemsToOrder.isEmpty()) {
            return;
        }
        this.forcedEntries = new InventorySummary();
        InventorySummary summary = new InventorySummary();
        for (List<BigItemStack> stackList : this.displayedItems) {
            for (BigItemStack stack : stackList) {
                summary.add(stack);
            }
        }
        for (BigItemStack toOrder : this.itemsToOrder) {
            int countOf = summary.getCountOf(toOrder.stack);
            if (countOf == 1000000000) continue;
            this.forcedEntries.add(toOrder.stack.copy(), -1 - Math.max(0, countOf - toOrder.count));
        }
        PackageOrderWithCrafts order = PackageOrderWithCrafts.simple(this.itemsToOrder);
        if (this.canRequestCraftingPackage && !this.itemsToOrder.isEmpty() && !this.recipesToOrder.isEmpty()) {
            ArrayList<PackageOrderWithCrafts.CraftingEntry> craftList = new ArrayList<PackageOrderWithCrafts.CraftingEntry>();
            for (CraftableBigItemStack cbis : this.recipesToOrder) {
                Recipe recipe = cbis.recipe;
                if (!(recipe instanceof CraftingRecipe)) continue;
                CraftingRecipe cr = (CraftingRecipe)recipe;
                PackageOrder pattern = new PackageOrder(FactoryPanelScreen.convertRecipeToPackageOrderContext((CraftingRecipe)cr, this.itemsToOrder));
                int count = cbis.count / cbis.getOutputCount(this.playerInventory.player.level());
                craftList.add(new PackageOrderWithCrafts.CraftingEntry(pattern, count));
            }
            order = new PackageOrderWithCrafts(order.orderedStacks(), craftList);
        }
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new SendPackage(order, this.addressBox.getValue()));
        ((PortableStockTickerMenu)this.menu).portableStockTicker.previouslyUsedAddress = this.addressBox.getValue();
        this.itemsToOrder = new ArrayList<BigItemStack>();
        this.recipesToOrder = new ArrayList<CraftableBigItemStack>();
        this.successTicks = 1;
        ClientScreenStorage.manualUpdate(((PortableStockTickerMenu)this.menu).portableStockTicker.getFrequency());
    }

    private Component getTroubleshootingMessage() {
        if (this.currentItemSource == null) {
            return CreateLang.translate((String)"gui.stock_keeper.checking_stocks", (Object[])new Object[0]).component();
        }
        if (this.currentItemSource.isEmpty()) {
            return CreateLang.translate((String)"gui.stock_keeper.inventories_empty", (Object[])new Object[0]).component();
        }
        return CreateLang.translate((String)"gui.stock_keeper.no_search_results", (Object[])new Object[0]).component();
    }

    private void syncJEI() {
        if (Mods.JEI.isLoaded() && ((Boolean)AllConfigs.client().syncJeiSearch.get()).booleanValue()) {
            CMPJEI.runtime.getIngredientFilter().setFilterText(this.searchBox.getValue());
        }
    }

    public void removed() {
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new HiddenCategoriesPacket(new ArrayList<Integer>(this.hiddenCategories)));
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new SendPackage(PackageOrderWithCrafts.empty(), this.addressBox.getValue()));
        super.removed();
    }

    public static class CategoryEntry {
        boolean hidden;
        String name;
        int y;
        int targetBECategory;

        public CategoryEntry(int targetBECategory, String name, int y) {
            this.targetBECategory = targetBECategory;
            this.name = name;
            this.hidden = false;
            this.y = y;
        }
    }
}

