/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.entities.robo_entity;

import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.box.PackageItem;
import de.theidler.create_mobile_packages.CreateMobilePackages;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlockEntity;
import de.theidler.create_mobile_packages.blocks.bee_port.DronePortTracker;
import de.theidler.create_mobile_packages.entities.robo_entity.RoboEntityState;
import de.theidler.create_mobile_packages.entities.robo_entity.states.AdjustRotationToTarget;
import de.theidler.create_mobile_packages.entities.robo_entity.states.LandingDescendFinishState;
import de.theidler.create_mobile_packages.entities.robo_entity.states.LaunchPrepareState;
import de.theidler.create_mobile_packages.index.CMPItems;
import de.theidler.create_mobile_packages.index.config.CMPConfigs;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class RoboEntity
extends Mob {
    private static final EntityDataAccessor<Float> ROT_YAW = SynchedEntityData.defineId(RoboEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.defineId(RoboEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Float> PACKAGE_HEIGHT_SCALE = SynchedEntityData.defineId(RoboEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private RoboEntityState state;
    private Vec3 targetVelocity = Vec3.ZERO;
    private Player targetPlayer;
    private BeePortBlockEntity targetBlockEntity;
    private BeePortBlockEntity startBeePortBlockEntity;
    private String targetAddress = "";
    private int damageCounter = 0;
    private boolean isRequest = true;
    private String activeTargetAddress = "";

    public RoboEntity(EntityType<? extends Mob> type, Level level, ItemStack itemStack, BlockPos targetPos, BlockPos spawnPos) {
        super(type, level);
        BeePortBlockEntity dpbe;
        BlockEntity blockEntity;
        CreateMobilePackages.ROBO_MANAGER.addRobo(this);
        if (targetPos != null) {
            blockEntity = level.getBlockEntity(targetPos);
            BeePortBlockEntity beePortBlockEntity = this.targetBlockEntity = blockEntity instanceof BeePortBlockEntity ? (dpbe = (BeePortBlockEntity)blockEntity) : null;
            if (this.targetBlockEntity != null) {
                this.setState(new LaunchPrepareState());
            }
        }
        this.setItemStack(itemStack);
        this.setTargetFromItemStack(itemStack);
        this.setPos(spawnPos.getCenter().subtract(0.0, 0.5, 0.0));
        if (this.targetBlockEntity != null) {
            this.targetBlockEntity.trySetEntityOnTravel(this);
        }
        if ((blockEntity = this.level().getBlockEntity(spawnPos)) instanceof BeePortBlockEntity) {
            this.startBeePortBlockEntity = dpbe = (BeePortBlockEntity)blockEntity;
        }
        if (!this.level().isClientSide()) {
            this.entityData.set(ROT_YAW, (Object)Float.valueOf(this.getSnapAngle(this.getAngleToTarget())));
        }
        if (this.targetBlockEntity != null && ((Object)((Object)this.targetBlockEntity)).equals((Object)this.startBeePortBlockEntity)) {
            this.setState(new LandingDescendFinishState());
            return;
        }
        if (this.startBeePortBlockEntity == null) {
            this.setState(new AdjustRotationToTarget());
            return;
        }
        this.setState(new LaunchPrepareState());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ROT_YAW, (Object)Float.valueOf(this.getYRot()));
        builder.define(DATA_ITEM_STACK, (Object)ItemStack.EMPTY);
        builder.define(PACKAGE_HEIGHT_SCALE, (Object)Float.valueOf(0.0f));
    }

    private void setTargetFromItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        this.targetAddress = PackageItem.getAddress((ItemStack)itemStack);
        this.updateTarget();
    }

    private Player getTargetPlayerFromAddress() {
        return this.level().players().stream().filter(player -> BeePortBlockEntity.doesAddressStringMatchPlayerName(player, PackageItem.getAddress((ItemStack)this.getItemStack()))).findFirst().orElse(null);
    }

    private void updateTarget() {
        BeePortBlockEntity newTargetBlockEntity;
        if (this.level().isClientSide) {
            return;
        }
        this.targetPlayer = this.getTargetPlayerFromAddress();
        if (this.targetPlayer != null) {
            return;
        }
        if (this.targetBlockEntity == null || !this.targetBlockEntity.canAcceptEntity(this, !this.getItemStack().isEmpty()) || !Objects.equals(this.activeTargetAddress, this.targetAddress)) {
            BeePortBlockEntity oldTarget = this.targetBlockEntity;
            this.activeTargetAddress = this.targetAddress;
            this.targetBlockEntity = RoboEntity.getClosestBeePort(this.level(), Objects.equals(this.targetAddress, "") ? null : this.targetAddress, this.blockPosition(), this);
            if (oldTarget != this.targetBlockEntity) {
                if (oldTarget != null) {
                    oldTarget.releaseEntityOnTravel(this);
                }
                if (this.targetBlockEntity != null) {
                    this.targetBlockEntity.trySetEntityOnTravel(this);
                }
            }
            if (this.targetBlockEntity == null && this.targetPlayer == null) {
                this.setTargetVelocity(Vec3.ZERO);
            }
        }
        if (!this.isRequest && (newTargetBlockEntity = RoboEntity.getClosestBeePort(this.level(), Objects.equals(this.targetAddress, "") ? null : this.targetAddress, this.blockPosition(), this)) != null && newTargetBlockEntity != this.targetBlockEntity) {
            if (this.targetBlockEntity != null) {
                this.targetBlockEntity.releaseEntityOnTravel(this);
            }
            this.targetBlockEntity = newTargetBlockEntity;
            this.targetBlockEntity.trySetEntityOnTravel(this);
        }
    }

    public BlockPos getTargetPosition() {
        this.updateTarget();
        if (this.targetPlayer != null) {
            return RoboEntity.isWithinRange(this.targetPlayer.blockPosition(), this.blockPosition()) ? this.targetPlayer.blockPosition().above().above() : null;
        }
        if (this.targetBlockEntity != null) {
            return RoboEntity.isWithinRange(this.targetBlockEntity.getBlockPos(), this.blockPosition()) ? this.targetBlockEntity.getBlockPos().above().above() : null;
        }
        return null;
    }

    public static boolean isWithinRange(BlockPos targetPos, BlockPos originPos) {
        int maxDistance = (Integer)CMPConfigs.server().beeMaxDistance.get();
        if (targetPos == null || originPos == null) {
            return false;
        }
        if (maxDistance == -1) {
            return true;
        }
        return targetPos.distSqr((Vec3i)originPos) <= (double)(maxDistance * maxDistance);
    }

    public static BeePortBlockEntity getClosestBeePort(Level level, String address, BlockPos origin, RoboEntity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DronePortTracker tracker = DronePortTracker.get(serverLevel);
            ArrayList<BeePortBlockEntity> allBEs = new ArrayList<BeePortBlockEntity>(tracker.getAll());
            allBEs.removeIf(dpbe -> !RoboEntity.isWithinRange(dpbe.getBlockPos(), origin));
            if (address != null) {
                allBEs.removeIf(dpbe -> !PackageItem.matchAddress((String)address, (String)dpbe.addressFilter));
            }
            allBEs.removeIf(dpbe -> !dpbe.canAcceptEntity(entity, entity != null && !entity.getItemStack().isEmpty()));
            return allBEs.stream().min(Comparator.comparingDouble(a -> a.getBlockPos().distSqr((Vec3i)origin))).orElse(null);
        }
        return null;
    }

    public void tick() {
    }

    public void roboMangerTick() {
        super.tick();
        if (this.targetBlockEntity != null && this.targetBlockEntity.isRemoved()) {
            this.targetBlockEntity = null;
        }
        if (this.startBeePortBlockEntity != null && this.startBeePortBlockEntity.isRemoved()) {
            this.startBeePortBlockEntity = null;
        }
        CreateMobilePackages.ROBO_MANAGER.markDirty();
        if (this.state != null) {
            this.state.tick(this);
        }
        this.setDeltaMovement(this.targetVelocity);
        this.move(MoverType.SELF, this.targetVelocity);
        float rotYaw = ((Float)this.entityData.get(ROT_YAW)).floatValue();
        this.setYRot(rotYaw);
        this.setYHeadRot(rotYaw);
        this.yBodyRot = rotYaw;
        this.updateNametag();
    }

    private void updateNametag() {
        if (this.level().isClientSide) {
            return;
        }
        if (!((Boolean)CMPConfigs.server().displayNametag.get()).booleanValue()) {
            this.setCustomName(null);
            this.setCustomNameVisible(false);
        } else if (this.targetAddress != null && !this.targetAddress.isBlank()) {
            this.setCustomName((Component)Component.literal((String)("-> " + this.targetAddress)));
            this.setCustomNameVisible(true);
        } else if (this.targetBlockEntity != null) {
            BlockPos pos = this.targetBlockEntity.getBlockPos();
            this.setCustomName((Component)Component.literal((String)("-> [" + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + "]")));
            this.setCustomNameVisible(true);
        } else {
            this.setCustomName(null);
            this.setCustomNameVisible(false);
        }
    }

    public void setState(RoboEntityState state) {
        if (state == null) {
            return;
        }
        this.state = state;
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.entityData.get(DATA_ITEM_STACK);
    }

    public void setItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        this.entityData.set(DATA_ITEM_STACK, (Object)itemStack);
    }

    public Float getPackageHeightScale() {
        return (Float)this.entityData.get(PACKAGE_HEIGHT_SCALE);
    }

    public void setPackageHeightScale(float scale) {
        if (scale < 0.0f || scale > 1.0f) {
            return;
        }
        this.entityData.set(PACKAGE_HEIGHT_SCALE, (Object)Float.valueOf(scale));
    }

    public BeePortBlockEntity getStartBeePortBlockEntity() {
        return this.startBeePortBlockEntity;
    }

    public void setTargetVelocity(Vec3 targetVelocity) {
        if (targetVelocity == null) {
            return;
        }
        this.targetVelocity = targetVelocity;
    }

    public int getSnapAngle(double angle) {
        return (int)Math.abs(Math.round(angle / 90.0) * 90L - 45L);
    }

    public double getAngleToTarget() {
        BlockPos targetPos = this.getTargetPosition();
        return targetPos != null ? Math.atan2((double)targetPos.getZ() - this.getZ(), (double)targetPos.getX() - this.getX()) : 0.0;
    }

    public void remove(Entity.RemovalReason pReason) {
        this.handleItemStackOnRemove();
        if (this.getTargetBlockEntity() != null && this.getTargetBlockEntity().getRoboEntity() != null) {
            this.getTargetBlockEntity().releaseEntityOnTravel(this);
        }
        super.remove(pReason);
    }

    private void handleItemStackOnRemove() {
        if (!this.getItemStack().isEmpty()) {
            this.level().addFreshEntity((Entity)PackageEntity.fromItemStack((Level)this.level(), (Vec3)this.position(), (ItemStack)this.getItemStack()));
            this.setItemStack(ItemStack.EMPTY);
            if (this.targetPlayer != null) {
                this.targetPlayer.displayClientMessage((Component)Component.translatable((String)"create_mobile_packages.robo_entity.death", (Object[])new Object[]{Math.round(this.getX()), Math.round(this.getY()), Math.round(this.getZ()), this.targetPlayer.getName().getString()}), false);
            }
        }
    }

    public Player getTargetPlayer() {
        this.updateTarget();
        return this.targetPlayer;
    }

    public BeePortBlockEntity getTargetBlockEntity() {
        return this.targetBlockEntity;
    }

    public void updateDisplay(Player player) {
        if (player == null) {
            return;
        }
        player.displayClientMessage((Component)Component.translatable((String)"create_mobile_packages.robo_entity.eta", (Object[])new Object[]{RoboEntity.calcETA(player.position(), this.position())}), true);
    }

    public static int calcETA(Vec3 targetPosition, Vec3 currentPosition) {
        if (targetPosition == null || currentPosition == null) {
            return Integer.MAX_VALUE;
        }
        double distance = targetPosition.distanceTo(currentPosition);
        return (int)(distance / (double)((Integer)CMPConfigs.server().beeSpeed.get()).intValue()) + 1;
    }

    public void lookAtTarget() {
        if (this.level().isClientSide()) {
            return;
        }
        BlockPos targetPos = this.getTargetPosition();
        if (targetPos != null) {
            Vec3 direction = new Vec3((double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ()).subtract(this.position()).normalize();
            this.entityData.set(ROT_YAW, (Object)Float.valueOf((float)Math.toDegrees(Math.atan2(direction.z, direction.x)) - 90.0f));
        }
    }

    public int rotateLookAtTarget() {
        return this.rotateToAngle((float)this.getAngleToTarget() + 90.0f);
    }

    public int rotateToSnap() {
        return this.rotateToAngle((float)this.getSnapAngle(this.getAngleToTarget()) + 90.0f);
    }

    private int rotateToAngle(float targetYaw) {
        if (this.level().isClientSide()) {
            return -1;
        }
        float currentYaw = ((Float)this.entityData.get(ROT_YAW)).floatValue();
        float deltaYaw = targetYaw - currentYaw;
        deltaYaw = deltaYaw > 180.0f ? deltaYaw - 360.0f : (deltaYaw < -180.0f ? deltaYaw + 360.0f : deltaYaw);
        float rotationSpeed = ((Integer)CMPConfigs.server().beeRotationSpeed.get()).intValue();
        currentYaw = Math.abs(deltaYaw) > rotationSpeed ? (currentYaw += deltaYaw > 0.0f ? rotationSpeed : -rotationSpeed) : targetYaw;
        this.entityData.set(ROT_YAW, (Object)Float.valueOf(currentYaw));
        return (int)Math.ceil(Math.abs(deltaYaw) / rotationSpeed);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (!this.getItemStack().isEmpty()) {
            nbt.put("itemStack", this.getItemStack().save((HolderLookup.Provider)this.level().registryAccess(), (Tag)new CompoundTag()));
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("itemStack", 10)) {
            this.setItemStack(ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)nbt.getCompound("itemStack")).orElse(ItemStack.EMPTY));
        } else {
            this.setItemStack(ItemStack.EMPTY);
        }
        this.setTargetFromItemStack(this.getItemStack());
    }

    public void load(CompoundTag pCompound) {
        super.load(pCompound);
        if (pCompound.contains("itemStack")) {
            this.setItemStack(ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)pCompound.getCompound("itemStack")).orElse(ItemStack.EMPTY));
        }
        this.setTargetFromItemStack(this.getItemStack());
        if (!this.level().isClientSide() && !this.getItemStack().isEmpty()) {
            this.setPackageHeightScale(1.0f);
        }
    }

    public void setTargetAddress(String address) {
        this.targetAddress = address;
        this.updateTarget();
    }

    public void kill() {
        this.level().broadcastEntityEvent((Entity)this, (byte)60);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack drop = new ItemStack((ItemLike)CMPItems.ROBO_BEE.get());
            Containers.dropItemStack((Level)serverLevel, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)drop);
        }
        this.discard();
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 60) {
            for (int i = 0; i < 3; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isInvulnerableTo(pSource)) {
            return false;
        }
        if (!this.level().isClientSide && !this.isRemoved()) {
            this.markHurt();
            this.damageCounter += (int)(pAmount * 10.0f);
            if (this.damageCounter > 40) {
                this.handleItemStackOnRemove();
                this.discard();
                this.kill();
            }
        }
        return true;
    }

    public void setRequest(boolean request) {
        this.isRequest = request;
    }
}

