/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.compat;

import java.util.Optional;
import java.util.function.Supplier;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;

public enum Mods {
    JEI,
    CREATE_FACTORY_LOGISTICS;

    private final String id = Lang.asId((String)this.name());

    public String id() {
        return this.id;
    }

    public ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.id, (String)path);
    }

    public Block getBlock(String id) {
        return (Block)BuiltInRegistries.BLOCK.get(this.rl(id));
    }

    public Item getItem(String id) {
        return (Item)BuiltInRegistries.ITEM.get(this.rl(id));
    }

    public boolean contains(ItemLike entry) {
        if (!this.isLoaded()) {
            return false;
        }
        Item asItem = entry.asItem();
        return asItem != null && RegisteredObjectsHelper.getKeyOrThrow((Item)asItem).getNamespace().equals(this.id);
    }

    public boolean isLoaded() {
        return ModList.get().isLoaded(this.id);
    }

    public <T> Optional<T> runIfInstalled(Supplier<Supplier<T>> toRun) {
        if (this.isLoaded()) {
            return Optional.of(toRun.get().get());
        }
        return Optional.empty();
    }

    public void executeIfInstalled(Supplier<Runnable> toExecute) {
        if (this.isLoaded()) {
            toExecute.get().run();
        }
    }
}

