/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages;

import de.theidler.create_mobile_packages.CreateMobilePackages;
import de.theidler.create_mobile_packages.RoboManager;
import de.theidler.create_mobile_packages.entities.robo_entity.RoboEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class RoboManagerSavedData
extends SavedData {
    private Map<UUID, RoboEntity> robos = new HashMap<UUID, RoboEntity>();

    public static RoboManagerSavedData load(MinecraftServer server) {
        return (RoboManagerSavedData)server.overworld().getDataStorage().computeIfAbsent(RoboManagerSavedData.factory(), "robo_manager");
    }

    public static SavedData.Factory<RoboManagerSavedData> factory() {
        return new SavedData.Factory(RoboManagerSavedData::new, RoboManagerSavedData::load);
    }

    private static RoboManagerSavedData load(CompoundTag compoundTag, HolderLookup.Provider provider) {
        RoboManagerSavedData savedData = new RoboManagerSavedData();
        savedData.robos = new HashMap<UUID, RoboEntity>();
        Level level = CreateMobilePackages.ROBO_MANAGER.getLevel();
        NBTHelper.iterateCompoundList((ListTag)compoundTag.getList("Robos", 10), c -> {
            Entity patt0$temp = level.getEntity(c.getInt("Id"));
            if (patt0$temp instanceof RoboEntity) {
                RoboEntity robo = (RoboEntity)patt0$temp;
                savedData.robos.put(robo.getUUID(), robo);
            }
        });
        return savedData;
    }

    public Map<UUID, RoboEntity> getRobos() {
        return this.robos;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        RoboManager roboManager = CreateMobilePackages.ROBO_MANAGER;
        CreateMobilePackages.LOGGER.info("Saving RoboManager...");
        nbt.put("Robos", (Tag)NBTHelper.writeCompoundList(roboManager.robos.values(), robo -> {
            CompoundTag roboTag = new CompoundTag();
            roboTag.putInt("Id", robo.getId());
            return roboTag;
        }));
        return nbt;
    }
}

