/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.integration.jei.category.printing;

import com.mojang.serialization.Codec;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlocks;
import plus.dragons.createenchantmentindustry.common.registry.CEIRecipes;
import plus.dragons.createenchantmentindustry.integration.jei.category.printing.AnimatedPrinter;
import plus.dragons.createenchantmentindustry.integration.jei.category.printing.PrintingRecipeJEI;
import plus.dragons.createenchantmentindustry.mixin.accessor.CreateRecipeCategoryAccessor;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class PrintingCategory
implements IRecipeCategory<PrintingRecipeJEI> {
    public static final RecipeType<PrintingRecipeJEI> TYPE = new RecipeType(CEIRecipes.PRINTING.getId(), PrintingRecipeJEI.class);
    private final Component title = CEILang.translate("recipe.printing", new Object[0]).component();
    private final IDrawable icon = new ItemIcon(() -> CEIBlocks.PRINTER.asStack());
    private final AnimatedPrinter printer = new AnimatedPrinter();

    public RecipeType<PrintingRecipeJEI> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 177;
    }

    public int getHeight() {
        return 70;
    }

    @Nullable
    public ResourceLocation getRegistryName(PrintingRecipeJEI recipe) {
        return recipe.getRegistryName();
    }

    public Codec<PrintingRecipeJEI> getCodec(ICodecHelper codecHelper, IRecipeManager recipeManager) {
        return PrintingRecipeJEI.TYPE_CODEC.dispatch(PrintingRecipeJEI::getType, type -> type.codec(codecHelper, recipeManager));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PrintingRecipeJEI recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder base = builder.addSlot(RecipeIngredientRole.INPUT, 27, 51).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1);
        recipe.setBase(base);
        IRecipeSlotBuilder template = builder.addSlot(RecipeIngredientRole.CATALYST, 51, 5).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1);
        recipe.setTemplate(template);
        IRecipeSlotBuilder fluid = builder.addSlot(RecipeIngredientRole.INPUT, 27, 32).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).setFluidRenderer(1L, false, 16, 16).addTooltipCallback(CreateRecipeCategoryAccessor::invokeAddPotionTooltip);
        recipe.setFluid(fluid);
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 132, 51).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1);
        recipe.setOutput(output);
    }

    public void onDisplayedIngredientsUpdate(PrintingRecipeJEI recipe, List<IRecipeSlotDrawable> recipeSlots, IFocusGroup focuses) {
        IRecipeSlotDrawable base = recipeSlots.get(0);
        IRecipeSlotDrawable template = recipeSlots.get(1);
        IRecipeSlotDrawable fluid = recipeSlots.get(2);
        IRecipeSlotDrawable output = recipeSlots.get(3);
        recipe.onDisplayedIngredientsUpdate(base, template, fluid, output, focuses);
    }

    public void draw(PrintingRecipeJEI recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 62, 57);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 126, 29);
        FluidStack fluid = ((IRecipeSlotView)recipeSlotsView.getSlotViews().get(2)).getDisplayedIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK).orElse(FluidStack.EMPTY);
        this.printer.withFluid(fluid).draw(graphics, this.getWidth() / 2 - 13, 22);
    }
}

