/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.processing.enchanter.behaviour;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.CEIEnchantmentHelper;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.EnchantingTemplateItem;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.behaviour.EnchantingBehaviour;

public class TemplateEnchantingBehaviour
extends EnchantingBehaviour {
    private final ItemStack target;

    public TemplateEnchantingBehaviour(ItemStack target) {
        this.target = target;
    }

    @Override
    public boolean canProcess(Level level, ItemStack stack, boolean special) {
        if (this.enchantments.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof EnchantingTemplateItem) {
            EnchantingTemplateItem template = (EnchantingTemplateItem)item;
            if (((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty()) {
                return !special && !template.isSpecial() || special && template.isSpecial();
            }
        }
        return false;
    }

    @Override
    public void update(Level level, ItemStack stack, int enchantingLevel, boolean special, boolean cursed) {
        super.update(level, this.target, enchantingLevel, special, cursed);
    }

    @Override
    public ItemStack getResult(Level level, ItemStack stack, RandomSource random, boolean special) {
        List<EnchantmentInstance> enchantments = CEIEnchantmentHelper.selectEnchantments(random, this.enchantingLevel, this.enchantments, special);
        if (enchantments.size() > 1) {
            enchantments.remove(random.nextInt(enchantments.size()));
        }
        return stack.getItem().applyEnchantments(stack, enchantments);
    }
}

