/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.printer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.client.model.CEIPartialModels;
import plus.dragons.createenchantmentindustry.common.fluids.printer.PrinterBlockEntity;

public class PrinterRenderer
extends SmartBlockEntityRenderer<PrinterBlockEntity> {
    private static final int PISTON_MOVING_TIME = 5;
    private static final PartialModel[] NOZZLE = new PartialModel[]{CEIPartialModels.PRINTER_NOZZLE_TOP, CEIPartialModels.PRINTER_NOZZLE_BOTTOM};

    public PrinterRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(PrinterBlockEntity printer, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)printer, partialTicks, poseStack, buffer, light, overlay);
        SmartFluidTankBehaviour.TankSegment tank = printer.tank.getPrimaryTank();
        FluidStack fluidStack = tank.getRenderedFluid();
        float fluidLevel = tank.getFluidLevel().getValue(partialTicks);
        if (!fluidStack.isEmpty() && fluidLevel != 0.0f) {
            boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
            fluidLevel = Math.max(fluidLevel, 0.175f) * 0.6875f;
            float min = 0.15625f;
            float max = min + 0.6875f;
            float minY = top ? max - fluidLevel : min;
            float maxY = top ? max : min + fluidLevel;
            NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, min, minY, min, max, maxY, max, buffer, poseStack, light, false, true);
        }
        float progress = PrinterRenderer.getProgress((float)printer.processingTicks - partialTicks);
        BlockState state = printer.getBlockState();
        poseStack.pushPose();
        for (PartialModel nozzle : NOZZLE) {
            poseStack.translate(0.0f, 3.0f * progress / 32.0f, 0.0f);
            CachedBuffers.partial((PartialModel)nozzle, (BlockState)state).light(light).renderInto(poseStack, buffer.getBuffer(RenderType.solid()));
        }
        poseStack.popPose();
        ((SuperByteBuffer)CachedBuffers.partial((PartialModel)CEIPartialModels.PRINTER_PISTON, (BlockState)state).translate(0.0f, -progress / 2.0f, 0.0f)).light(light).renderInto(poseStack, buffer.getBuffer(RenderType.solid()));
    }

    public static float getProgress(float partialTicks) {
        if (partialTicks < 0.0f) {
            return 0.0f;
        }
        if (partialTicks < 5.0f) {
            return Mth.lerp((float)(partialTicks / 5.0f), (float)0.0f, (float)1.0f);
        }
        if (partialTicks < 45.0f) {
            return 1.0f;
        }
        if (partialTicks < 50.0f) {
            return Mth.lerp((float)((50.0f - partialTicks) / 5.0f), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }
}

