/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.lantern;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;
import plus.dragons.createenchantmentindustry.common.registry.CEIFluids;
import plus.dragons.createenchantmentindustry.config.CEIConfig;

public class ExperienceLanternMovementBehavior
implements MovementBehaviour {
    public void tick(MovementContext context) {
        AABB effectiveAABB = new AABB(context.position.subtract(0.5, 0.5, 0.5), context.position.add(0.5, 0.5, 0.5)).inflate(0.5);
        if (!context.world.isClientSide && context.world.getGameTime() % 10L == 0L) {
            this.drainExp(context.world, effectiveAABB, context.contraption.getStorage().getFluids());
        }
        if (!context.world.isClientSide && ((Boolean)CEIConfig.fluids().experienceLanternPullToggle.get()).booleanValue()) {
            this.pullExp(context.world, effectiveAABB, context.position);
        }
    }

    protected void drainExp(Level level, AABB effectiveAABB, MountedFluidStorageWrapper tank) {
        List experienceOrbs;
        Integer rate = (Integer)CEIConfig.fluids().experienceLanternDrainRate.get();
        List players = level.getEntitiesOfClass(Player.class, effectiveAABB, player -> player.isAlive() && !player.isSpectator());
        if (!players.isEmpty()) {
            int inserted;
            AtomicInteger sum = new AtomicInteger();
            players.forEach(player -> {
                int playerExp = ExperienceHelper.getExperienceForPlayer(player);
                if (playerExp >= rate) {
                    sum.addAndGet(rate);
                } else if (playerExp != 0) {
                    sum.addAndGet(playerExp);
                }
            });
            if (sum.get() != 0 && (inserted = tank.fill(new FluidStack(CEIFluids.EXPERIENCE, sum.get()), IFluidHandler.FluidAction.EXECUTE)) != 0) {
                for (Player player2 : players) {
                    int total = ExperienceHelper.getExperienceForPlayer(player2);
                    if (inserted >= rate) {
                        if (total >= rate) {
                            player2.giveExperiencePoints(-rate.intValue());
                            inserted -= rate.intValue();
                            continue;
                        }
                        if (total == 0) continue;
                        inserted -= total;
                        player2.giveExperiencePoints(-total);
                        continue;
                    }
                    if (inserted <= 0) break;
                    if (total >= inserted) {
                        player2.giveExperiencePoints(-inserted);
                        inserted = 0;
                        continue;
                    }
                    inserted -= total;
                    player2.giveExperiencePoints(-total);
                }
            }
        }
        if (!(experienceOrbs = level.getEntitiesOfClass(ExperienceOrb.class, effectiveAABB)).isEmpty()) {
            for (ExperienceOrb orb : experienceOrbs) {
                int amount = orb.value;
                FluidStack fluidStack = new FluidStack((Fluid)CEIFluids.EXPERIENCE.get(), amount);
                int inserted = tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                if (inserted == amount) {
                    orb.remove(Entity.RemovalReason.DISCARDED);
                    continue;
                }
                if (inserted == 0) break;
                orb.value -= inserted;
                break;
            }
        }
    }

    protected void pullExp(Level level, AABB effectiveAABB, Vec3 position) {
        List experienceOrbs = level.getEntitiesOfClass(ExperienceOrb.class, effectiveAABB.inflate((double)((Integer)CEIConfig.fluids().experienceLanternPullRadius.get()).intValue()));
        if (!experienceOrbs.isEmpty()) {
            for (ExperienceOrb orb : experienceOrbs) {
                if (!(orb.getDeltaMovement().length() <= 0.5)) continue;
                double pushForce = (Double)CEIConfig.fluids().experienceLanternPullForceMultiplier.get() * 1.0 / orb.position().distanceTo(position);
                Vec3 directionToLantern = position.subtract(orb.position()).normalize().multiply(pushForce, pushForce, pushForce);
                orb.push(directionToLantern);
            }
        }
    }
}

